/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.kems;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.KeyEncapsulation;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KDFParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DerivationFunction b;
    private SecureRandom c;
    private ECKeyParameters d;
    private boolean e;
    private boolean f;
    private boolean g;

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.b = derivationFunction;
        this.c = secureRandom;
        this.e = false;
        this.f = false;
        this.g = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom, boolean bl2, boolean bl3, boolean bl4) {
        this.b = derivationFunction;
        this.c = secureRandom;
        this.e = bl2;
        this.f = bl3;
        this.g = bl4;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.d = (ECKeyParameters)cipherParameters;
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n2, int n3) throws IllegalArgumentException {
        if (!(this.d instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.d;
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger, this.c);
        BigInteger bigInteger4 = this.e ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3), eCPublicKeyParameters.getQ().multiply(bigInteger4)};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint eCPoint = eCPointArray[0];
        ECPoint eCPoint2 = eCPointArray[1];
        byte[] byArray2 = eCPoint.getEncoded(false);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        byte[] byArray3 = eCPoint2.getAffineXCoord().getEncoded();
        return this.deriveKey(n3, byArray2, byArray3);
    }

    public CipherParameters encrypt(byte[] byArray, int n2) {
        return this.encrypt(byArray, 0, n2);
    }

    @Override
    public CipherParameters decrypt(byte[] byArray, int n2, int n3, int n4) throws IllegalArgumentException {
        ECPoint eCPoint;
        if (!(this.d instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.d;
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        ECPoint eCPoint2 = eCPoint = eCCurve.decodePoint(byArray2);
        if (this.e || this.f) {
            eCPoint2 = eCPoint2.multiply(bigInteger2);
        }
        BigInteger bigInteger3 = eCPrivateKeyParameters.getD();
        if (this.e) {
            bigInteger3 = bigInteger3.multiply(bigInteger2.modInverse(bigInteger)).mod(bigInteger);
        }
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger3).normalize();
        byte[] byArray3 = eCPoint3.getAffineXCoord().getEncoded();
        return this.deriveKey(n4, byArray2, byArray3);
    }

    public CipherParameters decrypt(byte[] byArray, int n2) {
        return this.decrypt(byArray, 0, byArray.length, n2);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyParameter deriveKey(int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        if (!this.g) {
            byArray3 = Arrays.concatenate(byArray, byArray2);
            Arrays.fill(byArray2, (byte)0);
        }
        try {
            this.b.init(new KDFParameters(byArray3, null));
            byte[] byArray4 = new byte[n2];
            this.b.generateBytes(byArray4, 0, byArray4.length);
            KeyParameter keyParameter = new KeyParameter(byArray4);
            return keyParameter;
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
        }
    }
}

