/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.engines;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.StreamCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] a = new int[1024];
    private int[] b = new int[1024];
    private int c = 0;
    private byte[] d;
    private byte[] e;
    private boolean f;
    private byte[] g = new byte[4];
    private int h = 0;

    private int a() {
        int n2;
        int n3 = this.c & 0x3FF;
        if (this.c < 1024) {
            int n4 = this.a[n3 - 3 & 0x3FF];
            int n5 = this.a[n3 - 1023 & 0x3FF];
            int n6 = n3;
            this.a[n6] = this.a[n6] + (this.a[n3 - 10 & 0x3FF] + (HC256Engine.a(n4, 10) ^ HC256Engine.a(n5, 23)) + this.b[(n4 ^ n5) & 0x3FF]);
            n4 = this.a[n3 - 12 & 0x3FF];
            n2 = this.b[n4 & 0xFF] + this.b[(n4 >> 8 & 0xFF) + 256] + this.b[(n4 >> 16 & 0xFF) + 512] + this.b[(n4 >> 24 & 0xFF) + 768] ^ this.a[n3];
        } else {
            int n7 = this.b[n3 - 3 & 0x3FF];
            int n8 = this.b[n3 - 1023 & 0x3FF];
            int n9 = n3;
            this.b[n9] = this.b[n9] + (this.b[n3 - 10 & 0x3FF] + (HC256Engine.a(n7, 10) ^ HC256Engine.a(n8, 23)) + this.a[(n7 ^ n8) & 0x3FF]);
            n7 = this.b[n3 - 12 & 0x3FF];
            n2 = this.a[n7 & 0xFF] + this.a[(n7 >> 8 & 0xFF) + 256] + this.a[(n7 >> 16 & 0xFF) + 512] + this.a[(n7 >> 24 & 0xFF) + 768] ^ this.b[n3];
        }
        this.c = this.c + 1 & 0x7FF;
        return n2;
    }

    private void b() {
        int n2;
        Object[] objectArray;
        if (this.d.length != 32 && this.d.length != 16) {
            throw new IllegalArgumentException("The key must be 128/256 bits long");
        }
        if (this.e.length < 16) {
            throw new IllegalArgumentException("The IV must be at least 128 bits long");
        }
        if (this.d.length != 32) {
            objectArray = new byte[32];
            System.arraycopy(this.d, 0, objectArray, 0, this.d.length);
            System.arraycopy(this.d, 0, objectArray, 16, this.d.length);
            this.d = objectArray;
        }
        if (this.e.length < 32) {
            objectArray = new byte[32];
            System.arraycopy(this.e, 0, objectArray, 0, this.e.length);
            System.arraycopy(this.e, 0, objectArray, this.e.length, objectArray.length - this.e.length);
            this.e = objectArray;
        }
        this.h = 0;
        this.c = 0;
        objectArray = new int[2560];
        for (n2 = 0; n2 < 32; ++n2) {
            int n3 = n2 >> 2;
            objectArray[n3] = objectArray[n3] | (this.d[n2] & 0xFF) << 8 * (n2 & 3);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            int n4 = (n2 >> 2) + 8;
            objectArray[n4] = objectArray[n4] | (this.e[n2] & 0xFF) << 8 * (n2 & 3);
        }
        for (n2 = 16; n2 < 2560; ++n2) {
            byte by2 = objectArray[n2 - 2];
            byte by3 = objectArray[n2 - 15];
            objectArray[n2] = (HC256Engine.a(by2, 17) ^ HC256Engine.a(by2, 19) ^ by2 >>> 10) + objectArray[n2 - 7] + (HC256Engine.a(by3, 7) ^ HC256Engine.a(by3, 18) ^ by3 >>> 3) + objectArray[n2 - 16] + n2;
        }
        System.arraycopy(objectArray, 512, this.a, 0, 1024);
        System.arraycopy(objectArray, 1536, this.b, 0, 1024);
        for (n2 = 0; n2 < 4096; ++n2) {
            this.a();
        }
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "HC-256";
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.e = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.e = new byte[0];
        }
        if (!(cipherParameters2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC256 init - " + cipherParameters.getClass().getName());
        }
        this.d = ((KeyParameter)cipherParameters2).getKey();
        this.b();
        this.f = true;
    }

    private byte c() {
        int n2;
        if (this.h == 0) {
            n2 = this.a();
            this.g[0] = (byte)(n2 & 0xFF);
            this.g[1] = (byte)((n2 >>= 8) & 0xFF);
            this.g[2] = (byte)((n2 >>= 8) & 0xFF);
            this.g[3] = (byte)((n2 >>= 8) & 0xFF);
        }
        n2 = this.g[this.h];
        this.h = this.h + 1 & 3;
        return (byte)n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (!this.f) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n4 + n3 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2[n4 + i2] = (byte)(byArray[n2 + i2] ^ this.c());
        }
        return n3;
    }

    @Override
    public void reset() {
        this.b();
    }

    @Override
    public byte returnByte(byte by2) {
        return (byte)(by2 ^ this.c());
    }

    private static int a(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }
}

