/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.agreement;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithUKM;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest a;
    private ECPrivateKeyParameters b;
    private BigInteger c;

    public ECVKOAgreement(Digest digest) {
        this.a = digest;
    }

    public void init(CipherParameters cipherParameters) {
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)cipherParameters;
        this.b = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        this.c = ECVKOAgreement.a(parametersWithUKM.getUKM());
    }

    public int getFieldSize() {
        return (this.b.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        if (!eCDomainParameters.equals(this.b.getParameters())) {
            throw new IllegalStateException("ECVKO public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.c).multiply(this.b.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = eCPublicKeyParameters.getQ().multiply(bigInteger).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
        }
        return this.a(eCPoint.normalize());
    }

    private static BigInteger a(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - i2 - 1];
        }
        return new BigInteger(1, byArray2);
    }

    private byte[] a(ECPoint eCPoint) {
        int n2;
        BigInteger bigInteger = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = eCPoint.getAffineYCoord().toBigInteger();
        int n3 = bigInteger.toByteArray().length > 33 ? 64 : 32;
        byte[] byArray = new byte[2 * n3];
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(n3, bigInteger);
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(n3, bigInteger2);
        for (n2 = 0; n2 != n3; ++n2) {
            byArray[n2] = byArray2[n3 - n2 - 1];
        }
        for (n2 = 0; n2 != n3; ++n2) {
            byArray[n3 + n2] = byArray3[n3 - n2 - 1];
        }
        this.a.update(byArray, 0, byArray.length);
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray4, 0);
        return byArray4;
    }
}

