/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.agreement;

import com.aspose.imaging.internal.bouncycastle.crypto.BasicAgreement;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;

public class DHBasicAgreement
implements BasicAgreement {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters b;
    private DHParameters c;

    @Override
    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.b = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.c = this.b.getParameters();
    }

    @Override
    public int getFieldSize() {
        return (this.b.getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)cipherParameters;
        if (!dHPublicKeyParameters.getParameters().equals(this.c)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger = this.c.getP();
        BigInteger bigInteger2 = dHPublicKeyParameters.getY();
        if (bigInteger2 == null || bigInteger2.compareTo(a) <= 0 || bigInteger2.compareTo(bigInteger.subtract(a)) >= 0) {
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        BigInteger bigInteger3 = bigInteger2.modPow(this.b.getX(), bigInteger);
        if (bigInteger3.equals(a)) {
            throw new IllegalStateException("Shared key can't be 1");
        }
        return bigInteger3;
    }
}

