/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.Gost2814789EncryptedKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GostR3410KeyTransport;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GostR3410TransportParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.KeyTransRecipient;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.a;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.b;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.w;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.x;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.GOST28147WrapParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorException;
import com.aspose.imaging.internal.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public abstract class JceKeyTransRecipient
implements KeyTransRecipient {
    private PrivateKey a;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected Map extraMappings;
    protected boolean validateKeySize;
    protected boolean unwrappedKeyMustBeEncodable;

    public JceKeyTransRecipient(PrivateKey privateKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new b());
        this.extraMappings = new HashMap();
        this.validateKeySize = false;
        this.a = privateKey;
    }

    public JceKeyTransRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceKeyTransRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceKeyTransRecipient setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        this.extraMappings.put(aSN1ObjectIdentifier, string);
        return this;
    }

    public JceKeyTransRecipient setContentProvider(Provider provider) {
        this.contentHelper = com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(provider);
        return this;
    }

    public JceKeyTransRecipient setMustProduceEncodableUnwrappedKey(boolean bl2) {
        this.unwrappedKeyMustBeEncodable = bl2;
        return this;
    }

    public JceKeyTransRecipient setContentProvider(String string) {
        this.contentHelper = com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(string);
        return this;
    }

    public JceKeyTransRecipient setKeySizeValidation(boolean bl2) {
        this.validateKeySize = bl2;
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        if (com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.c(algorithmIdentifier.getAlgorithm())) {
            try {
                GostR3410KeyTransport gostR3410KeyTransport = GostR3410KeyTransport.getInstance(byArray);
                GostR3410TransportParameters gostR3410TransportParameters = gostR3410KeyTransport.getTransportParameters();
                KeyFactory keyFactory = this.helper.createKeyFactory(algorithmIdentifier.getAlgorithm());
                PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(gostR3410TransportParameters.getEphemeralPublicKey().getEncoded()));
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(algorithmIdentifier.getAlgorithm());
                keyAgreement.init((Key)this.a, new UserKeyingMaterialSpec(gostR3410TransportParameters.getUkm()));
                keyAgreement.doPhase(publicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret("GOST28147");
                Cipher cipher = this.helper.createCipher(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap);
                cipher.init(4, (Key)secretKey, new GOST28147WrapParameterSpec(gostR3410TransportParameters.getEncryptionParamSet(), gostR3410TransportParameters.getUkm()));
                Gost2814789EncryptedKey gost2814789EncryptedKey = gostR3410KeyTransport.getSessionEncryptedKey();
                return cipher.unwrap(Arrays.concatenate(gost2814789EncryptedKey.getEncryptedKey(), gost2814789EncryptedKey.getMacKey()), this.helper.getBaseCipherName(algorithmIdentifier2.getAlgorithm()), 3);
            }
            catch (Exception exception) {
                throw new CMSException("exception unwrapping key: " + exception.getMessage(), exception);
            }
        }
        JceAsymmetricKeyUnwrapper jceAsymmetricKeyUnwrapper = this.helper.createAsymmetricUnwrapper(algorithmIdentifier, this.a).setMustProduceEncodableUnwrappedKey(this.unwrappedKeyMustBeEncodable);
        if (!this.extraMappings.isEmpty()) {
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : this.extraMappings.keySet()) {
                jceAsymmetricKeyUnwrapper.setAlgorithmMapping(aSN1ObjectIdentifier, (String)this.extraMappings.get(aSN1ObjectIdentifier));
            }
        }
        try {
            Key key = this.helper.getJceKey(algorithmIdentifier2.getAlgorithm(), jceAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(algorithmIdentifier2, key);
            }
            return key;
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

