/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.RecipientIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.KeyTransRecipient;
import com.aspose.imaging.internal.bouncycastle.cms.KeyTransRecipientId;
import com.aspose.imaging.internal.bouncycastle.cms.Recipient;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientInformation;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientOperator;
import com.aspose.imaging.internal.bouncycastle.cms.a;
import com.aspose.imaging.internal.bouncycastle.cms.l;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo a;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, l l2, a a2) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, l2, a2);
        this.a = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.a.getEncryptedKey().getOctets());
    }
}

