/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.selector;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.selector.a;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Selector;
import java.math.BigInteger;

public class X509CertificateHolderSelector
implements Selector {
    private byte[] a;
    private X500Name b;
    private BigInteger c;

    public X509CertificateHolderSelector(byte[] byArray) {
        this(null, null, byArray);
    }

    public X509CertificateHolderSelector(X500Name x500Name, BigInteger bigInteger) {
        this(x500Name, bigInteger, null);
    }

    public X509CertificateHolderSelector(X500Name x500Name, BigInteger bigInteger, byte[] byArray) {
        this.b = x500Name;
        this.c = bigInteger;
        this.a = byArray;
    }

    public X500Name getIssuer() {
        return this.b;
    }

    public BigInteger getSerialNumber() {
        return this.c;
    }

    public byte[] getSubjectKeyIdentifier() {
        return Arrays.clone(this.a);
    }

    public int hashCode() {
        int n2 = Arrays.hashCode(this.a);
        if (this.c != null) {
            n2 ^= this.c.hashCode();
        }
        if (this.b != null) {
            n2 ^= this.b.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509CertificateHolderSelector)) {
            return false;
        }
        X509CertificateHolderSelector x509CertificateHolderSelector = (X509CertificateHolderSelector)object;
        return Arrays.areEqual(this.a, x509CertificateHolderSelector.a) && this.a(this.c, x509CertificateHolderSelector.c) && this.a(this.b, x509CertificateHolderSelector.b);
    }

    private boolean a(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public boolean match(Object object) {
        if (object instanceof X509CertificateHolder) {
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure());
                return issuerAndSerialNumber.getName().equals(this.b) && issuerAndSerialNumber.getSerialNumber().getValue().equals(this.c);
            }
            if (this.a != null) {
                Extension extension = x509CertificateHolder.getExtension(Extension.subjectKeyIdentifier);
                if (extension == null) {
                    return Arrays.areEqual(this.a, com.aspose.imaging.internal.bouncycastle.cert.selector.a.a(x509CertificateHolder.getSubjectPublicKeyInfo()));
                }
                byte[] byArray = ASN1OctetString.getInstance(extension.getParsedValue()).getOctets();
                return Arrays.areEqual(this.a, byArray);
            }
        } else if (object instanceof byte[]) {
            return Arrays.areEqual(this.a, (byte[])object);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new X509CertificateHolderSelector(this.b, this.c, this.a);
    }
}

