/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.crmf;

import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PBMParameter;
import com.aspose.imaging.internal.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.PKMACValuesCalculator;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.b;
import com.aspose.imaging.internal.bouncycastle.operator.MacCalculator;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.security.SecureRandom;

public class PKMACBuilder {
    private AlgorithmIdentifier a;
    private int b;
    private AlgorithmIdentifier c;
    private int d = 20;
    private SecureRandom e;
    private PKMACValuesCalculator f;
    private PBMParameter g;
    private int h;

    public PKMACBuilder(PKMACValuesCalculator pKMACValuesCalculator) {
        this(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), 1000, new AlgorithmIdentifier(IANAObjectIdentifiers.hmacSHA1, DERNull.INSTANCE), pKMACValuesCalculator);
    }

    public PKMACBuilder(PKMACValuesCalculator pKMACValuesCalculator, int n2) {
        this.h = n2;
        this.f = pKMACValuesCalculator;
    }

    private PKMACBuilder(AlgorithmIdentifier algorithmIdentifier, int n2, AlgorithmIdentifier algorithmIdentifier2, PKMACValuesCalculator pKMACValuesCalculator) {
        this.a = algorithmIdentifier;
        this.b = n2;
        this.c = algorithmIdentifier2;
        this.f = pKMACValuesCalculator;
    }

    public PKMACBuilder setSaltLength(int n2) {
        if (n2 < 8) {
            throw new IllegalArgumentException("salt length must be at least 8 bytes");
        }
        this.d = n2;
        return this;
    }

    public PKMACBuilder setIterationCount(int n2) {
        if (n2 < 100) {
            throw new IllegalArgumentException("iteration count must be at least 100");
        }
        this.a(n2);
        this.b = n2;
        return this;
    }

    public PKMACBuilder setSecureRandom(SecureRandom secureRandom) {
        this.e = secureRandom;
        return this;
    }

    public PKMACBuilder setParameters(PBMParameter pBMParameter) {
        this.a(pBMParameter.getIterationCount().getValue().intValue());
        this.g = pBMParameter;
        return this;
    }

    public MacCalculator build(char[] cArray) throws CRMFException {
        if (this.g != null) {
            return this.a(this.g, cArray);
        }
        byte[] byArray = new byte[this.d];
        if (this.e == null) {
            this.e = new SecureRandom();
        }
        this.e.nextBytes(byArray);
        return this.a(new PBMParameter(byArray, this.a, this.b, this.c), cArray);
    }

    private void a(int n2) {
        if (this.h > 0 && n2 > this.h) {
            throw new IllegalArgumentException("iteration count exceeds limit (" + n2 + " > " + this.h + ")");
        }
    }

    private MacCalculator a(PBMParameter pBMParameter, char[] cArray) throws CRMFException {
        byte[] byArray = Strings.toUTF8ByteArray(cArray);
        byte[] byArray2 = pBMParameter.getSalt().getOctets();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this.f.setup(pBMParameter.getOwf(), pBMParameter.getMac());
        int n2 = pBMParameter.getIterationCount().getValue().intValue();
        do {
            byArray3 = this.f.calculateDigest(byArray3);
        } while (--n2 > 0);
        byte[] byArray4 = byArray3;
        return new b(this, pBMParameter, byArray4);
    }

    static /* synthetic */ PKMACValuesCalculator access$000(PKMACBuilder pKMACBuilder) {
        return pKMACBuilder.f;
    }
}

