/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.crmf;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.CertReqMsg;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.CertTemplate;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.Controls;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.PKMACValue;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.POPOSigningKey;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.ProofOfPossession;
import com.aspose.imaging.internal.bouncycastle.cert.CertIOException;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.AuthenticatorControl;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.Control;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.PKIArchiveControl;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.PKMACBuilder;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.RegTokenControl;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.a;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.d;
import com.aspose.imaging.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.imaging.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.util.Encodable;
import java.io.IOException;

public class CertificateRequestMessage
implements Encodable {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg a;
    private final Controls b;

    private static CertReqMsg a(byte[] byArray) throws IOException {
        try {
            return CertReqMsg.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public CertificateRequestMessage(byte[] byArray) throws IOException {
        this(CertificateRequestMessage.a(byArray));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.a = certReqMsg;
        this.b = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.a;
    }

    public CertTemplate getCertTemplate() {
        return this.a.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.b != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.a(aSN1ObjectIdentifier) != null;
    }

    public Control getControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTypeAndValue attributeTypeAndValue = this.a(aSN1ObjectIdentifier);
        if (attributeTypeAndValue != null) {
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl(DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl(DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.b == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = this.b.toAttributeTypeAndValueArray();
        AttributeTypeAndValue attributeTypeAndValue = null;
        for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
            if (!attributeTypeAndValueArray[i2].getType().equals(aSN1ObjectIdentifier)) continue;
            attributeTypeAndValue = attributeTypeAndValueArray[i2];
            break;
        }
        return attributeTypeAndValue;
    }

    public boolean hasProofOfPossession() {
        return this.a.getPopo() != null;
    }

    public int getProofOfPossessionType() {
        return this.a.getPopo().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession proofOfPossession = this.a.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            return pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null;
        }
        return false;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.a.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() != null && pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null) {
                throw new IllegalStateException("verification requires password check");
            }
            return this.a(contentVerifierProvider, pOPOSigningKey);
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider, PKMACBuilder pKMACBuilder, char[] cArray) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.a.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() == null || pOPOSigningKey.getPoposkInput().getSender() != null) {
                throw new IllegalStateException("no PKMAC present in proof of possession");
            }
            d d2 = new d(pKMACBuilder);
            PKMACValue pKMACValue = pOPOSigningKey.getPoposkInput().getPublicKeyMAC();
            if (d2.a(pKMACValue, cArray, this.getCertTemplate().getPublicKey())) {
                return this.a(contentVerifierProvider, pOPOSigningKey);
            }
            return false;
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    private boolean a(ContentVerifierProvider contentVerifierProvider, POPOSigningKey pOPOSigningKey) throws CRMFException {
        ContentVerifier contentVerifier;
        try {
            contentVerifier = contentVerifierProvider.get(pOPOSigningKey.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CRMFException("unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        if (pOPOSigningKey.getPoposkInput() != null) {
            com.aspose.imaging.internal.bouncycastle.cert.crmf.a.a(pOPOSigningKey.getPoposkInput(), contentVerifier.getOutputStream());
        } else {
            com.aspose.imaging.internal.bouncycastle.cert.crmf.a.a(this.a.getCertReq(), contentVerifier.getOutputStream());
        }
        return contentVerifier.verify(pOPOSigningKey.getSignature().getOctets());
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }
}

