/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.cmp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.CMPCertificate;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIBody;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIFreeText;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIHeader;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIMessage;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.cmp.CMPException;
import com.aspose.imaging.internal.bouncycastle.cert.cmp.ProtectedPKIMessage;
import com.aspose.imaging.internal.bouncycastle.operator.ContentSigner;
import com.aspose.imaging.internal.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtectedPKIMessageBuilder {
    private PKIHeaderBuilder a;
    private PKIBody b;
    private List c = new ArrayList();
    private List d = new ArrayList();

    public ProtectedPKIMessageBuilder(GeneralName generalName, GeneralName generalName2) {
        this(2, generalName, generalName2);
    }

    public ProtectedPKIMessageBuilder(int n2, GeneralName generalName, GeneralName generalName2) {
        this.a = new PKIHeaderBuilder(n2, generalName, generalName2);
    }

    public ProtectedPKIMessageBuilder setTransactionID(byte[] byArray) {
        this.a.setTransactionID(byArray);
        return this;
    }

    public ProtectedPKIMessageBuilder setFreeText(PKIFreeText pKIFreeText) {
        this.a.setFreeText(pKIFreeText);
        return this;
    }

    public ProtectedPKIMessageBuilder addGeneralInfo(InfoTypeAndValue infoTypeAndValue) {
        this.c.add(infoTypeAndValue);
        return this;
    }

    public ProtectedPKIMessageBuilder setMessageTime(Date date) {
        this.a.setMessageTime(new ASN1GeneralizedTime(date));
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipKID(byte[] byArray) {
        this.a.setRecipKID(byArray);
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipNonce(byte[] byArray) {
        this.a.setRecipNonce(byArray);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderKID(byte[] byArray) {
        this.a.setSenderKID(byArray);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderNonce(byte[] byArray) {
        this.a.setSenderNonce(byArray);
        return this;
    }

    public ProtectedPKIMessageBuilder setBody(PKIBody pKIBody) {
        this.b = pKIBody;
        return this;
    }

    public ProtectedPKIMessageBuilder addCMPCertificate(X509CertificateHolder x509CertificateHolder) {
        this.d.add(x509CertificateHolder);
        return this;
    }

    public ProtectedPKIMessage build(MacCalculator macCalculator) throws CMPException {
        this.a(macCalculator.getAlgorithmIdentifier());
        PKIHeader pKIHeader = this.a.build();
        try {
            DERBitString dERBitString = new DERBitString(this.a(macCalculator, pKIHeader, this.b));
            return this.a(pKIHeader, dERBitString);
        }
        catch (IOException iOException) {
            throw new CMPException("unable to encode MAC input: " + iOException.getMessage(), iOException);
        }
    }

    public ProtectedPKIMessage build(ContentSigner contentSigner) throws CMPException {
        this.a(contentSigner.getAlgorithmIdentifier());
        PKIHeader pKIHeader = this.a.build();
        try {
            DERBitString dERBitString = new DERBitString(this.a(contentSigner, pKIHeader, this.b));
            return this.a(pKIHeader, dERBitString);
        }
        catch (IOException iOException) {
            throw new CMPException("unable to encode signature input: " + iOException.getMessage(), iOException);
        }
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) {
        this.a.setProtectionAlg(algorithmIdentifier);
        if (!this.c.isEmpty()) {
            InfoTypeAndValue[] infoTypeAndValueArray = new InfoTypeAndValue[this.c.size()];
            this.a.setGeneralInfo(this.c.toArray(infoTypeAndValueArray));
        }
    }

    private ProtectedPKIMessage a(PKIHeader pKIHeader, DERBitString dERBitString) {
        if (!this.d.isEmpty()) {
            CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.d.size()];
            for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
                cMPCertificateArray[i2] = new CMPCertificate(((X509CertificateHolder)this.d.get(i2)).toASN1Structure());
            }
            return new ProtectedPKIMessage(new PKIMessage(pKIHeader, this.b, dERBitString, cMPCertificateArray));
        }
        return new ProtectedPKIMessage(new PKIMessage(pKIHeader, this.b, dERBitString));
    }

    private byte[] a(ContentSigner contentSigner, PKIHeader pKIHeader, PKIBody pKIBody) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(pKIHeader);
        aSN1EncodableVector.add(pKIBody);
        OutputStream outputStream = contentSigner.getOutputStream();
        outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
        outputStream.close();
        return contentSigner.getSignature();
    }

    private byte[] a(MacCalculator macCalculator, PKIHeader pKIHeader, PKIBody pKIBody) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(pKIHeader);
        aSN1EncodableVector.add(pKIBody);
        OutputStream outputStream = macCalculator.getOutputStream();
        outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
        outputStream.close();
        return macCalculator.getMac();
    }
}

