/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DisplayText;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.NoticeReference;

public class UserNotice
extends ASN1Object {
    private final NoticeReference a;
    private final DisplayText b;

    public UserNotice(NoticeReference noticeReference, DisplayText displayText) {
        this.a = noticeReference;
        this.b = displayText;
    }

    public UserNotice(NoticeReference noticeReference, String string) {
        this(noticeReference, new DisplayText(string));
    }

    private UserNotice(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.a = NoticeReference.getInstance(aSN1Sequence.getObjectAt(0));
            this.b = DisplayText.getInstance(aSN1Sequence.getObjectAt(1));
        } else if (aSN1Sequence.size() == 1) {
            if (aSN1Sequence.getObjectAt(0).toASN1Primitive() instanceof ASN1Sequence) {
                this.a = NoticeReference.getInstance(aSN1Sequence.getObjectAt(0));
                this.b = null;
            } else {
                this.a = null;
                this.b = DisplayText.getInstance(aSN1Sequence.getObjectAt(0));
            }
        } else if (aSN1Sequence.size() == 0) {
            this.a = null;
            this.b = null;
        } else {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
    }

    public static UserNotice getInstance(Object object) {
        if (object instanceof UserNotice) {
            return (UserNotice)object;
        }
        if (object != null) {
            return new UserNotice(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public NoticeReference getNoticeRef() {
        return this.a;
    }

    public DisplayText getExplicitText() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

