/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.util.Enumeration;

public class SubjectPublicKeyInfo
extends ASN1Object {
    private AlgorithmIdentifier a;
    private DERBitString b;

    public static SubjectPublicKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static SubjectPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)object;
        }
        if (object != null) {
            return new SubjectPublicKeyInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this.b = new DERBitString(aSN1Encodable);
        this.a = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.b = new DERBitString(byArray);
        this.a = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.b = DERBitString.getInstance(enumeration.nextElement());
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.a;
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.a;
    }

    public ASN1Primitive parsePublicKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.b.getOctets());
    }

    public ASN1Primitive getPublicKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.b.getOctets());
    }

    public DERBitString getPublicKeyData() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

