/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DisplayText;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class NoticeReference
extends ASN1Object {
    private DisplayText a;
    private ASN1Sequence b;

    private static ASN1EncodableVector a(Vector vector) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ASN1Integer aSN1Integer;
            Object e2 = enumeration.nextElement();
            if (e2 instanceof BigInteger) {
                aSN1Integer = new ASN1Integer((BigInteger)e2);
            } else if (e2 instanceof Integer) {
                aSN1Integer = new ASN1Integer(((Integer)e2).intValue());
            } else {
                throw new IllegalArgumentException();
            }
            aSN1EncodableVector.add(aSN1Integer);
        }
        return aSN1EncodableVector;
    }

    public NoticeReference(String string, Vector vector) {
        this(string, NoticeReference.a(vector));
    }

    public NoticeReference(String string, ASN1EncodableVector aSN1EncodableVector) {
        this(new DisplayText(string), aSN1EncodableVector);
    }

    public NoticeReference(DisplayText displayText, ASN1EncodableVector aSN1EncodableVector) {
        this.a = displayText;
        this.b = new DERSequence(aSN1EncodableVector);
    }

    private NoticeReference(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = DisplayText.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static NoticeReference getInstance(Object object) {
        if (object instanceof NoticeReference) {
            return (NoticeReference)object;
        }
        if (object != null) {
            return new NoticeReference(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DisplayText getOrganization() {
        return this.a;
    }

    public ASN1Integer[] getNoticeNumbers() {
        ASN1Integer[] aSN1IntegerArray = new ASN1Integer[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            aSN1IntegerArray[i2] = ASN1Integer.getInstance(this.b.getObjectAt(i2));
        }
        return aSN1IntegerArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

