/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Name;
import com.aspose.imaging.internal.bouncycastle.util.IPAddress;
import java.io.IOException;
import java.util.StringTokenizer;

public class GeneralName
extends ASN1Object
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    private ASN1Encodable a;
    private int b;

    public GeneralName(X509Name x509Name) {
        this.a = X500Name.getInstance(x509Name);
        this.b = 4;
    }

    public GeneralName(X500Name x500Name) {
        this.a = x500Name;
        this.b = 4;
    }

    public GeneralName(int n2, ASN1Encodable aSN1Encodable) {
        this.a = aSN1Encodable;
        this.b = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralName(int n2, String string) {
        this.b = n2;
        if (n2 == 1 || n2 == 2 || n2 == 6) {
            this.a = new DERIA5String(string);
            return;
        } else if (n2 == 8) {
            this.a = new ASN1ObjectIdentifier(string);
            return;
        } else if (n2 == 4) {
            this.a = new X500Name(string);
            return;
        } else {
            if (n2 != 7) throw new IllegalArgumentException("can't process String for tag: " + n2);
            byte[] byArray = this.a(string);
            if (byArray == null) throw new IllegalArgumentException("IP Address is invalid");
            this.a = new DEROctetString(byArray);
        }
    }

    public static GeneralName getInstance(Object object) {
        if (object == null || object instanceof GeneralName) {
            return (GeneralName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            int n2 = aSN1TaggedObject.getTagNo();
            switch (n2) {
                case 0: {
                    return new GeneralName(n2, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 1: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 2: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + n2);
                }
                case 4: {
                    return new GeneralName(n2, X500Name.getInstance(aSN1TaggedObject, true));
                }
                case 5: {
                    return new GeneralName(n2, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 6: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 7: {
                    return new GeneralName(n2, ASN1OctetString.getInstance(aSN1TaggedObject, false));
                }
                case 8: {
                    return new GeneralName(n2, ASN1ObjectIdentifier.getInstance(aSN1TaggedObject, false));
                }
            }
        }
        if (object instanceof byte[]) {
            try {
                return GeneralName.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to parse encoded general name");
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    public int getTagNo() {
        return this.b;
    }

    public ASN1Encodable getName() {
        return this.a;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.b);
        stringBuffer.append(": ");
        switch (this.b) {
            case 1: 
            case 2: 
            case 6: {
                stringBuffer.append(DERIA5String.getInstance(this.a).getString());
                break;
            }
            case 4: {
                stringBuffer.append(X500Name.getInstance(this.a).toString());
                break;
            }
            default: {
                stringBuffer.append(this.a.toString());
            }
        }
        return stringBuffer.toString();
    }

    private byte[] a(String string) {
        if (IPAddress.isValidIPv6WithNetmask(string) || IPAddress.isValidIPv6(string)) {
            int n2 = string.indexOf(47);
            if (n2 < 0) {
                byte[] byArray = new byte[16];
                int[] nArray = this.c(string);
                this.a(nArray, byArray, 0);
                return byArray;
            }
            byte[] byArray = new byte[32];
            int[] nArray = this.c(string.substring(0, n2));
            this.a(nArray, byArray, 0);
            String string2 = string.substring(n2 + 1);
            nArray = string2.indexOf(58) > 0 ? this.c(string2) : this.b(string2);
            this.a(nArray, byArray, 16);
            return byArray;
        }
        if (IPAddress.isValidIPv4WithNetmask(string) || IPAddress.isValidIPv4(string)) {
            int n3 = string.indexOf(47);
            if (n3 < 0) {
                byte[] byArray = new byte[4];
                this.b(string, byArray, 0);
                return byArray;
            }
            byte[] byArray = new byte[8];
            this.b(string.substring(0, n3), byArray, 0);
            String string3 = string.substring(n3 + 1);
            if (string3.indexOf(46) > 0) {
                this.b(string3, byArray, 4);
            } else {
                this.a(string3, byArray, 4);
            }
            return byArray;
        }
        return null;
    }

    private void a(String string, byte[] byArray, int n2) {
        int n3 = Integer.parseInt(string);
        for (int i2 = 0; i2 != n3; ++i2) {
            int n4 = i2 / 8 + n2;
            byArray[n4] = (byte)(byArray[n4] | 1 << 7 - i2 % 8);
        }
    }

    private void b(String string, byte[] byArray, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byArray[n2 + n3++] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    private int[] b(String string) {
        int[] nArray = new int[8];
        int n2 = Integer.parseInt(string);
        for (int i2 = 0; i2 != n2; ++i2) {
            int n3 = i2 / 16;
            nArray[n3] = nArray[n3] | 1 << 15 - i2 % 16;
        }
        return nArray;
    }

    private void a(int[] nArray, byte[] byArray, int n2) {
        for (int i2 = 0; i2 != nArray.length; ++i2) {
            byArray[i2 * 2 + n2] = (byte)(nArray[i2] >> 8);
            byArray[i2 * 2 + 1 + n2] = (byte)nArray[i2];
        }
    }

    private int[] c(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        int n2 = 0;
        int[] nArray = new int[8];
        if (string.charAt(0) == ':' && string.charAt(1) == ':') {
            stringTokenizer.nextToken();
        }
        int n3 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                n3 = n2;
                nArray[n2++] = 0;
                continue;
            }
            if (string2.indexOf(46) < 0) {
                nArray[n2++] = Integer.parseInt(string2, 16);
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringTokenizer.nextToken();
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            nArray[n2++] = Integer.parseInt(stringTokenizer2.nextToken()) << 8 | Integer.parseInt(stringTokenizer2.nextToken());
            nArray[n2++] = Integer.parseInt(stringTokenizer2.nextToken()) << 8 | Integer.parseInt(stringTokenizer2.nextToken());
        }
        if (n2 != nArray.length) {
            System.arraycopy(nArray, n3, nArray, nArray.length - (n2 - n3), n2 - n3);
            for (int i2 = n3; i2 != nArray.length - (n2 - n3); ++i2) {
                nArray[i2] = 0;
            }
        }
        return nArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.b == 4) {
            return new DERTaggedObject(true, this.b, this.a);
        }
        return new DERTaggedObject(false, this.b, this.a);
    }
}

