/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class SignerInfo
extends ASN1Object {
    private ASN1Integer a;
    private IssuerAndSerialNumber b;
    private AlgorithmIdentifier c;
    private ASN1Set d;
    private AlgorithmIdentifier e;
    private ASN1OctetString f;
    private ASN1Set g;

    public static SignerInfo getInstance(Object object) {
        if (object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public SignerInfo(ASN1Integer aSN1Integer, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier algorithmIdentifier, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set2) {
        this.a = aSN1Integer;
        this.b = issuerAndSerialNumber;
        this.c = algorithmIdentifier;
        this.d = aSN1Set;
        this.e = algorithmIdentifier2;
        this.f = aSN1OctetString;
        this.g = aSN1Set2;
    }

    public SignerInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = IssuerAndSerialNumber.getInstance(enumeration.nextElement());
        this.c = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        Object e2 = enumeration.nextElement();
        if (e2 instanceof ASN1TaggedObject) {
            this.d = ASN1Set.getInstance((ASN1TaggedObject)e2, false);
            this.e = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        } else {
            this.d = null;
            this.e = AlgorithmIdentifier.getInstance(e2);
        }
        this.f = DEROctetString.getInstance(enumeration.nextElement());
        this.g = enumeration.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)enumeration.nextElement(), false) : null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.b;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.d;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.c;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.f;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.e;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.d));
        }
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.g));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

