/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.esf;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.esf.CrlIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.esf.OtherHash;

public class CrlValidatedID
extends ASN1Object {
    private OtherHash a;
    private CrlIdentifier b;

    public static CrlValidatedID getInstance(Object object) {
        if (object instanceof CrlValidatedID) {
            return (CrlValidatedID)object;
        }
        if (object != null) {
            return new CrlValidatedID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlValidatedID(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = OtherHash.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = CrlIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public CrlValidatedID(OtherHash otherHash) {
        this(otherHash, null);
    }

    public CrlValidatedID(OtherHash otherHash, CrlIdentifier crlIdentifier) {
        this.a = otherHash;
        this.b = crlIdentifier;
    }

    public OtherHash getCrlHash() {
        return this.a;
    }

    public CrlIdentifier getCrlIdentifier() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a.toASN1Primitive());
        if (null != this.b) {
            aSN1EncodableVector.add(this.b.toASN1Primitive());
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

