/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.eac;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.UnsignedInteger;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKey
extends PublicKeyDataObject {
    private ASN1ObjectIdentifier a;
    private BigInteger b;
    private BigInteger c;
    private int d = 0;
    private static int e = 1;
    private static int f = 2;

    RSAPublicKey(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
        block4: while (enumeration.hasMoreElements()) {
            UnsignedInteger unsignedInteger = UnsignedInteger.getInstance(enumeration.nextElement());
            switch (unsignedInteger.getTagNo()) {
                case 1: {
                    this.a(unsignedInteger);
                    continue block4;
                }
                case 2: {
                    this.b(unsignedInteger);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown DERTaggedObject :" + unsignedInteger.getTagNo() + "-> not an Iso7816RSAPublicKeyStructure");
        }
        if (this.d != 3) {
            throw new IllegalArgumentException("missing argument -> not an Iso7816RSAPublicKeyStructure");
        }
    }

    public RSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = aSN1ObjectIdentifier;
        this.b = bigInteger;
        this.c = bigInteger2;
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.a;
    }

    public BigInteger getModulus() {
        return this.b;
    }

    public BigInteger getPublicExponent() {
        return this.c;
    }

    private void a(UnsignedInteger unsignedInteger) {
        if ((this.d & e) == 0) {
            this.d |= e;
        } else {
            throw new IllegalArgumentException("Modulus already set");
        }
        this.b = unsignedInteger.getValue();
    }

    private void b(UnsignedInteger unsignedInteger) {
        if ((this.d & f) == 0) {
            this.d |= f;
        } else {
            throw new IllegalArgumentException("Exponent already set");
        }
        this.c = unsignedInteger.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new UnsignedInteger(1, this.getModulus()));
        aSN1EncodableVector.add(new UnsignedInteger(2, this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector);
    }
}

