/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.eac;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.UnsignedInteger;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECDSAPublicKey
extends PublicKeyDataObject {
    private ASN1ObjectIdentifier a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private byte[] e;
    private BigInteger f;
    private byte[] g;
    private BigInteger h;
    private int i;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 4;
    private static final int m = 8;
    private static final int n = 16;
    private static final int o = 32;
    private static final int p = 64;

    ECDSAPublicKey(ASN1Sequence aSN1Sequence) throws IllegalArgumentException {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
        this.i = 0;
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e2;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 1: {
                        this.d(UnsignedInteger.getInstance(aSN1TaggedObject).getValue());
                        break;
                    }
                    case 2: {
                        this.b(UnsignedInteger.getInstance(aSN1TaggedObject).getValue());
                        break;
                    }
                    case 3: {
                        this.e(UnsignedInteger.getInstance(aSN1TaggedObject).getValue());
                        break;
                    }
                    case 4: {
                        this.a(ASN1OctetString.getInstance(aSN1TaggedObject, false));
                        break;
                    }
                    case 5: {
                        this.c(UnsignedInteger.getInstance(aSN1TaggedObject).getValue());
                        break;
                    }
                    case 6: {
                        this.b(ASN1OctetString.getInstance(aSN1TaggedObject, false));
                        break;
                    }
                    case 7: {
                        this.a(UnsignedInteger.getInstance(aSN1TaggedObject).getValue());
                        break;
                    }
                    default: {
                        this.i = 0;
                        throw new IllegalArgumentException("Unknown Object Identifier!");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown Object Identifier!");
        }
        if (this.i != 32 && this.i != 127) {
            throw new IllegalArgumentException("All options must be either present or absent!");
        }
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IllegalArgumentException {
        this.a = aSN1ObjectIdentifier;
        this.b(new DEROctetString(byArray));
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, BigInteger bigInteger4, byte[] byArray2, int n2) {
        this.a = aSN1ObjectIdentifier;
        this.d(bigInteger);
        this.b(bigInteger2);
        this.e(bigInteger3);
        this.a(new DEROctetString(byArray));
        this.c(bigInteger4);
        this.b(new DEROctetString(byArray2));
        this.a(BigInteger.valueOf(n2));
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.a;
    }

    public byte[] getBasePointG() {
        if ((this.i & 8) != 0) {
            return Arrays.clone(this.e);
        }
        return null;
    }

    private void a(ASN1OctetString aSN1OctetString) throws IllegalArgumentException {
        if ((this.i & 8) == 0) {
            this.i |= 8;
        } else {
            throw new IllegalArgumentException("Base Point G already set");
        }
        this.e = aSN1OctetString.getOctets();
    }

    public BigInteger getCofactorF() {
        if ((this.i & 0x40) != 0) {
            return this.h;
        }
        return null;
    }

    private void a(BigInteger bigInteger) throws IllegalArgumentException {
        if ((this.i & 0x40) == 0) {
            this.i |= 0x40;
        } else {
            throw new IllegalArgumentException("Cofactor F already set");
        }
        this.h = bigInteger;
    }

    public BigInteger getFirstCoefA() {
        if ((this.i & 2) != 0) {
            return this.c;
        }
        return null;
    }

    private void b(BigInteger bigInteger) throws IllegalArgumentException {
        if ((this.i & 2) == 0) {
            this.i |= 2;
        } else {
            throw new IllegalArgumentException("First Coef A already set");
        }
        this.c = bigInteger;
    }

    public BigInteger getOrderOfBasePointR() {
        if ((this.i & 0x10) != 0) {
            return this.f;
        }
        return null;
    }

    private void c(BigInteger bigInteger) throws IllegalArgumentException {
        if ((this.i & 0x10) == 0) {
            this.i |= 0x10;
        } else {
            throw new IllegalArgumentException("Order of base point R already set");
        }
        this.f = bigInteger;
    }

    public BigInteger getPrimeModulusP() {
        if ((this.i & 1) != 0) {
            return this.b;
        }
        return null;
    }

    private void d(BigInteger bigInteger) {
        if ((this.i & 1) == 0) {
            this.i |= 1;
        } else {
            throw new IllegalArgumentException("Prime Modulus P already set");
        }
        this.b = bigInteger;
    }

    public byte[] getPublicPointY() {
        if ((this.i & 0x20) != 0) {
            return Arrays.clone(this.g);
        }
        return null;
    }

    private void b(ASN1OctetString aSN1OctetString) throws IllegalArgumentException {
        if ((this.i & 0x20) == 0) {
            this.i |= 0x20;
        } else {
            throw new IllegalArgumentException("Public Point Y already set");
        }
        this.g = aSN1OctetString.getOctets();
    }

    public BigInteger getSecondCoefB() {
        if ((this.i & 4) != 0) {
            return this.d;
        }
        return null;
    }

    private void e(BigInteger bigInteger) throws IllegalArgumentException {
        if ((this.i & 4) == 0) {
            this.i |= 4;
        } else {
            throw new IllegalArgumentException("Second Coef B already set");
        }
        this.d = bigInteger;
    }

    public boolean hasParameters() {
        return this.b != null;
    }

    public ASN1EncodableVector getASN1EncodableVector(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1ObjectIdentifier);
        if (!bl2) {
            aSN1EncodableVector.add(new UnsignedInteger(1, this.getPrimeModulusP()));
            aSN1EncodableVector.add(new UnsignedInteger(2, this.getFirstCoefA()));
            aSN1EncodableVector.add(new UnsignedInteger(3, this.getSecondCoefB()));
            aSN1EncodableVector.add(new DERTaggedObject(false, 4, new DEROctetString(this.getBasePointG())));
            aSN1EncodableVector.add(new UnsignedInteger(5, this.getOrderOfBasePointR()));
        }
        aSN1EncodableVector.add(new DERTaggedObject(false, 6, new DEROctetString(this.getPublicPointY())));
        if (!bl2) {
            aSN1EncodableVector.add(new UnsignedInteger(7, this.getCofactorF()));
        }
        return aSN1EncodableVector;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.getASN1EncodableVector(this.a, !this.hasParameters()));
    }
}

