/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class GCMParameters
extends ASN1Object {
    private byte[] a;
    private int b;

    public static GCMParameters getInstance(Object object) {
        if (object instanceof GCMParameters) {
            return (GCMParameters)object;
        }
        if (object != null) {
            return new GCMParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private GCMParameters(ASN1Sequence aSN1Sequence) {
        this.a = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets();
        this.b = aSN1Sequence.size() == 2 ? ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue().intValue() : 12;
    }

    public GCMParameters(byte[] byArray, int n2) {
        this.a = Arrays.clone(byArray);
        this.b = n2;
    }

    public byte[] getNonce() {
        return Arrays.clone(this.a);
    }

    public int getIcvLen() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        if (this.b != 12) {
            aSN1EncodableVector.add(new ASN1Integer(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

