/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.bc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERGeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.bc.ObjectDataSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.util.Date;

public class ObjectStoreData
extends ASN1Object {
    private final BigInteger a;
    private final AlgorithmIdentifier b;
    private final ASN1GeneralizedTime c;
    private final ASN1GeneralizedTime d;
    private final ObjectDataSequence e;
    private final String f;

    public ObjectStoreData(AlgorithmIdentifier algorithmIdentifier, Date date, Date date2, ObjectDataSequence objectDataSequence, String string) {
        this.a = BigInteger.valueOf(1L);
        this.b = algorithmIdentifier;
        this.c = new DERGeneralizedTime(date);
        this.d = new DERGeneralizedTime(date2);
        this.e = objectDataSequence;
        this.f = string;
    }

    private ObjectStoreData(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(3));
        this.e = ObjectDataSequence.getInstance(aSN1Sequence.getObjectAt(4));
        this.f = aSN1Sequence.size() == 6 ? DERUTF8String.getInstance(aSN1Sequence.getObjectAt(5)).getString() : null;
    }

    public static ObjectStoreData getInstance(Object object) {
        if (object instanceof ObjectStoreData) {
            return (ObjectStoreData)object;
        }
        if (object != null) {
            return new ObjectStoreData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public String getComment() {
        return this.f;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.c;
    }

    public AlgorithmIdentifier getIntegrityAlgorithm() {
        return this.b;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.d;
    }

    public ObjectDataSequence getObjectDataSequence() {
        return this.e;
    }

    public BigInteger getVersion() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERUTF8String(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

