/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imageoptions;

import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.FileFormat;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.fileformats.bmp.BitmapInfoHeader;
import com.aspose.imaging.imageoptions.BmpOptions;
import com.aspose.imaging.imageoptions.PngOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.li.aV;
import com.aspose.imaging.internal.li.au;
import com.aspose.imaging.internal.li.bC;
import com.aspose.imaging.internal.qm.d;
import com.aspose.imaging.system.EnumExtensions;
import java.util.Arrays;

public class IcoOptions
extends ImageOptionsBase {
    private long a;
    private int b;

    public IcoOptions() {
        this(16L, 32);
    }

    public IcoOptions(IcoOptions icoOptions) {
        super(icoOptions);
        this.a = icoOptions.a;
        this.b = icoOptions.b;
    }

    @Override
    protected Object memberwiseClone() {
        return new IcoOptions(this);
    }

    public IcoOptions(long l2) {
        this(l2, 32);
    }

    public IcoOptions(long l2, int n2) {
        IcoOptions.a(l2, n2);
        this.a = l2;
        this.b = n2;
    }

    public final long getFormat() {
        return this.a;
    }

    public final void setFormat(long l2) {
        IcoOptions.a(l2, this.b);
        this.a = l2;
    }

    public final int getBitsPerPixel() {
        return this.b;
    }

    public final void setBitsPerPixel(int n2) {
        IcoOptions.a(this.a, n2);
        this.b = n2;
    }

    public final int c() {
        switch (this.b) {
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 24: {
                return 2;
            }
            case 32: {
                return 6;
            }
        }
        throw new ArgumentException("ICO format supports PNG frames of 8, 16, 24, 32 bits per pixel.");
    }

    public final ImageOptionsBase a(Image image) {
        Object object;
        IColorPalette iColorPalette = super.getPalette();
        int n2 = this.b;
        int n3 = d.e(bC.f(2.0, (double)n2));
        if (d.b((Object)iColorPalette, IColorPalette.class)) {
            if (this.a == 2L && iColorPalette.getEntriesCount() < n3) {
                object = this.getPalette().getArgb32Entries();
                object = Arrays.copyOf(object, n3);
                iColorPalette = new ColorPalette((int[])object);
            }
        } else if (n2 > 1 && n2 <= 8) {
            iColorPalette = ColorPaletteHelper.getCloseImagePalette((RasterImage)((Object)d.a(image, RasterImage.class)), n3);
        } else if (n2 == 1) {
            iColorPalette = ColorPaletteHelper.createMonochrome();
        }
        if (this.a == 2L) {
            BmpOptions bmpOptions = new BmpOptions();
            bmpOptions.setBitsPerPixel(n2);
            bmpOptions.setCompression(0L);
            bmpOptions.a(BitmapInfoHeader.a());
            bmpOptions.setPalette(iColorPalette);
            object = bmpOptions;
        } else {
            PngOptions pngOptions = new PngOptions();
            pngOptions.setColorType(this.c());
            pngOptions.setPalette(iColorPalette);
            object = pngOptions;
        }
        return object;
    }

    public static void a(long l2, int n2) {
        if (l2 == 16L) {
            if (Arrays.binarySearch(new int[]{8, 16, 24, 32}, n2) >= 0) {
                return;
            }
            throw new ArgumentException(aV.a(new String[]{"ICO format supports PNG frames of 8, 16, 24, 32 bits per pixel. Specified value: ", au.b(n2)}), "bitsPerPixel");
        }
        if (l2 == 2L) {
            if (Arrays.binarySearch(new int[]{1, 4, 8, 24, 32}, n2) >= 0) {
                return;
            }
            throw new ArgumentException(aV.a(new String[]{"ICO format supports BMP frames of 1, 4, 8, 24, 32 bit per pixel. Specified value: ", au.b(n2)}), "bitsPerPixel");
        }
        throw new ArgumentException(aV.a(new String[]{"ICO image supports only FileFormat.Png and FileFormat.Bmp images as enteries. Specified: ", EnumExtensions.toString(FileFormat.class, l2)}), "format");
    }
}

