/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif.blocks;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IAnimationFrame;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.GifImage;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.imageoptions.GifOptions;
import com.aspose.imaging.internal.E.e;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.aI.H;
import com.aspose.imaging.internal.aI.aC;
import com.aspose.imaging.internal.aI.aK;
import com.aspose.imaging.internal.aI.bA;
import com.aspose.imaging.internal.aI.bM;
import com.aspose.imaging.internal.aI.bP;
import com.aspose.imaging.internal.aI.bl;
import com.aspose.imaging.internal.aI.br;
import com.aspose.imaging.internal.aI.cc;
import com.aspose.imaging.internal.aP.g;
import com.aspose.imaging.internal.aP.n;
import com.aspose.imaging.internal.eZ.c;
import com.aspose.imaging.internal.fq.o;
import com.aspose.imaging.internal.jf.i;
import com.aspose.imaging.internal.jf.z;
import com.aspose.imaging.internal.jq.b;
import com.aspose.imaging.internal.li.aV;
import com.aspose.imaging.internal.li.bC;
import com.aspose.imaging.internal.li.w;
import com.aspose.imaging.internal.qm.d;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.util.Arrays;

public final class GifFrameBlock
extends RasterCachedImage
implements IAnimationFrame,
IGifBlock,
com.aspose.imaging.internal.K.a {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private static final String i = "value";
    private byte j;
    private int k;
    private int l;
    private int m;
    private int n;
    private byte o;
    private GifGraphicsControlBlock p;
    private int q;
    private int r;

    public GifFrameBlock(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5) {
        this(null, n2, n3, n4, n5, null, false, false, 8);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        this(null, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public GifFrameBlock(RasterImage rasterImage) {
        this(rasterImage, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3) {
        this(rasterImage, n2, n3, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (rasterImage == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new bP(rasterImage), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    public GifFrameBlock(Stream stream) {
        this(stream, 0, 0, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3) {
        this(Stream.fromJava(inputStream), n2, n3);
    }

    GifFrameBlock(Stream stream, int n2, int n3) {
        this(stream, n2, n3, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        this(Stream.fromJava(inputStream), n2, n3, bl2, bl3, by2);
    }

    GifFrameBlock(Stream stream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new bP(stream), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(String string) {
        this(string, 0, 0, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3) {
        this(string, n2, n3, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new bP(string), n2, n3, bl2, bl3, by2);
    }

    private GifFrameBlock(com.aspose.imaging.internal.eZ.a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        super(iColorPalette);
        this.a(iColorPalette, n2, n3, n4 & 0xFFFF, n5 & 0xFFFF, bl2, bl3, by2);
        if (a2 != null) {
            this.setDataLoader(a2);
            a2.a(this);
        }
    }

    public static IColorPalette getColorPalette(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        IColorPalette iColorPalette3 = null;
        if (iColorPalette != null) {
            iColorPalette3 = iColorPalette;
        } else if (iColorPalette2 != null) {
            iColorPalette3 = iColorPalette2;
        }
        if (iColorPalette3 == null) {
            throw new GifImageException("Cannot process GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
        }
        return iColorPalette3;
    }

    public static byte createFlags(IColorPalette iColorPalette, boolean bl2, boolean bl3) {
        byte by2 = 0;
        if (iColorPalette != null) {
            if (iColorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            int n2 = 0;
            int n3 = iColorPalette.getEntriesCount();
            while (n3 > 2) {
                if ((n3 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n3 >>= 1;
                n2 = (byte)(n2 + 1);
            }
            by2 = (byte)(n2 & 0xFF);
            by2 = (byte)(by2 & 0xFF | 0x80);
        }
        if (bl2) {
            by2 = (byte)(by2 & 0xFF | 0x20);
        }
        if (bl3) {
            by2 = (byte)(by2 & 0xFF | 0x40);
        }
        return by2;
    }

    public static GifFrameBlock a(com.aspose.imaging.internal.eZ.a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        return new GifFrameBlock(a2, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public static void a(StreamContainer streamContainer, Rectangle rectangle, byte by2) {
        streamContainer.writeByte((byte)44);
        com.aspose.imaging.internal.iE.b b2 = new com.aspose.imaging.internal.iE.b(streamContainer);
        b2.a(rectangle.getLeft());
        b2.a(rectangle.getTop());
        b2.a(rectangle.getWidth());
        b2.a(rectangle.getHeight());
        streamContainer.writeByte(by2);
    }

    public static void a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, Rectangle rectangle, GifOptions gifOptions) {
        if (iColorPalette == null) {
            throw new ArgumentNullException("palette");
        }
        if (gifOptions == null) {
            throw new ArgumentNullException("gifSaveOptions");
        }
        if (gifOptions.getMaxDiff() < 0 || gifOptions.getMaxDiff() > 1000) {
            throw new ArgumentException("GifOptions.MaxDiff must be in range [0, 1000].");
        }
        streamContainer.writeByte(by2);
        GifFrameBlock.b(rasterImage, streamContainer, iColorPalette, by2, rectangle, gifOptions);
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, Rectangle rectangle, GifOptions gifOptions) {
        a a2 = new a(rasterImage, streamContainer, iColorPalette, by2 & 0xFF, rectangle, gifOptions.getMaxDiff(), gifOptions.getBackgroundColor());
        try {
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                com.aspose.imaging.internal.eZ.a a3;
                boolean bl2 = gifOptions.getInterlaced();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qm.d.a(rasterImage, GifFrameBlock.class));
                com.aspose.imaging.internal.eZ.a a4 = a3 = gifFrameBlock == null ? null : (com.aspose.imaging.internal.eZ.a)((Object)com.aspose.imaging.internal.qm.d.a(gifFrameBlock.getDataLoader(), com.aspose.imaging.internal.eZ.a.class));
                if (a3 != null) {
                    bl2 = !gifFrameBlock.getInterlaced() && gifOptions.getInterlaced();
                    a3.a(!bl2);
                }
                if (bl2) {
                    bA.a(rectangle2, rasterImage.getWidth(), rasterImage.getHeight(), a2, rasterImage);
                } else {
                    bA.a(rectangle2, a2, (b)rasterImage);
                }
                if (a3 != null) {
                    a3.a(false);
                }
            }
            a2.a(true);
        }
        finally {
            a2.close();
        }
    }

    @Override
    public long getFileFormat() {
        return 4L;
    }

    @Override
    public int getWidth() {
        return this.k;
    }

    @Override
    public int getHeight() {
        return this.l;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.j & 0xFF;
    }

    @Override
    public int getFrameTime() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 10;
        }
        return (gifGraphicsControlBlock.getDelayTime() & 0xFFFF) * 10;
    }

    public void setFrameTime(int n2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setDelayTime(n2 / 10 & 0xFFFF);
        }
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (this.o & 0xFF & 0x40) != 0;
    }

    public void setInterlaced(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.o;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x40) : (byte)(by2 & 0xFF & 0xBF);
        this.o = by2;
    }

    @Override
    public boolean isInterlaced() {
        return this.getInterlaced();
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (this.o & 0xFF & 0x20) != 0;
    }

    public void setPaletteSorted(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.o;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x20) : (byte)(by2 & 0xFF & 0xDF);
        this.o = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.j;
    }

    public void setGifFrameBitsPerPixel(byte by2) {
        this.verifyNotDisposed();
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 8) {
            throw new ArgumentOutOfRangeException(i, aV.a(new String[]{"GifFrameBitsPerPixel is out of range [1, 4, 8] :", w.b(by2)}));
        }
        this.j = by2;
    }

    public int getLeft() {
        this.verifyNotDisposed();
        return this.m;
    }

    public void setLeft(int n2) {
        this.verifyNotDisposed();
        this.m = n2;
    }

    public int getTop() {
        this.verifyNotDisposed();
        return this.n;
    }

    public void setTop(int n2) {
        this.verifyNotDisposed();
        this.n = n2;
    }

    @Override
    public int getFrameTop() {
        return this.getTop() & 0xFFFF;
    }

    @Override
    public int getFrameLeft() {
        return this.getLeft() & 0xFFFF;
    }

    @Override
    public int getDisposalMethod() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 1;
        }
        switch (gifGraphicsControlBlock.getDisposalMethod()) {
            case 0: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.o;
    }

    public void setFlags(byte by2) {
        this.verifyNotDisposed();
        if ((this.o & 0xFF) != (by2 & 0xFF)) {
            if ((by2 & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException(i, "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((by2 & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException(i, "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (by2 & 7)) {
                throw new ArgumentOutOfRangeException(i, "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.o = by2;
        }
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifGraphicsControlBlock gifGraphicsControlBlock = null;
        Image image = this.getContainer();
        if (image instanceof GifImage) {
            if (this.p != null) {
                return this.p;
            }
            IGifBlock[] iGifBlockArray = ((GifImage)image).s();
            block0: for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                if (i2 <= 0) break;
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    IGifBlock iGifBlock = iGifBlockArray[i3];
                    if (com.aspose.imaging.internal.qm.d.b((Object)iGifBlock, GifGraphicsControlBlock.class)) {
                        gifGraphicsControlBlock = (GifGraphicsControlBlock)iGifBlock;
                        break block0;
                    }
                    if (iGifBlock instanceof GifFrameBlock) break block0;
                }
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        return gifGraphicsControlBlock != null && gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setTransparentColor(bl2);
        } else if (this.getContainer() instanceof GifImage) {
            IGifBlock[] iGifBlockArray = ((GifImage)this.getContainer()).s();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = (GifImage)((Object)com.aspose.imaging.internal.qm.d.a(this.getContainer(), GifImage.class));
                gifGraphicsControlBlock = new GifGraphicsControlBlock();
                gifGraphicsControlBlock.setTransparentColor(bl2);
                gifImage.a(i2, gifGraphicsControlBlock);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image so transparent color can not be set.");
        }
    }

    @Override
    public Color getTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return Color.getEmpty();
        }
        IColorPalette iColorPalette = this.n();
        int n2 = gifGraphicsControlBlock.getTransparentColorIndex() & 0xFF;
        if (n2 < iColorPalette.getEntriesCount()) {
            return Color.fromArgb(iColorPalette.getArgb32Color(n2));
        }
        return Color.getEmpty();
    }

    @Override
    public void setTransparentColor(Color color) {
        IColorPalette iColorPalette = this.n();
        int n2 = color.toArgb();
        this.a(n2, iColorPalette);
    }

    @Override
    public i h() {
        return this.getContainer() != null ? this.getContainer().h() : super.h();
    }

    @Override
    public Color getBackgroundColor() {
        return this.getContainer().getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getContainer().setBackgroundColor(color);
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        if (this.getContainer() != null) {
            GifImage gifImage = (GifImage)this.getContainer();
            return gifImage.r();
        }
        return null;
    }

    @Override
    public void adjustBrightness(int n2) {
        if (this.getPalette() != null) {
            int[] nArray = this.getPalette().getArgb32Entries();
            com.aspose.imaging.internal.fq.o.a(nArray, n2);
            this.setPalette(new ColorPalette(nArray));
        }
    }

    @Override
    public void replaceColor(int n2, byte by2, int n3) {
        Image image = this.getContainer();
        H h2 = new H(n2, by2, n3, this, !((GifImage)((Object)com.aspose.imaging.internal.qm.d.a(image, GifImage.class))).hasTransparentColor());
        bA.a(this.getBounds(), h2, (b)image);
    }

    @Override
    public void replaceNonTransparentColors(int n2) {
        bl bl2 = new bl(n2, this, !((GifImage)((Object)com.aspose.imaging.internal.qm.d.a(this.getContainer(), GifImage.class))).hasTransparentColor());
        bA.a(this.getBounds(), bl2);
    }

    @Override
    public RasterImage getFullFrame() {
        GifFrameBlock gifFrameBlock = this.f(true);
        gifFrameBlock.p = new GifGraphicsControlBlock();
        gifFrameBlock.p.setFlags(GifGraphicsControlBlock.createFlags(false, false, 0));
        gifFrameBlock.p.setTransparentColor(false);
        gifFrameBlock.setFrameTime(this.getFrameTime());
        return gifFrameBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b(int n2, int n3, int n4) {
        RasterImage rasterImage = this.getFullFrame();
        try {
            this.a(rasterImage);
            this.updateDimensions(rasterImage.getWidth(), rasterImage.getHeight());
            this.onCached();
        }
        finally {
            this.d(true);
        }
        this.resize(n2, n3, n4);
    }

    @Override
    public IColorPalette p() {
        return this.getContainer() != null ? this.getContainer().getPalette() : this.getPalette();
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2;
        boolean bl3 = bl2 = this.getContainer() != null;
        if (bl2) {
            this.getContainer().setPalette(iColorPalette);
        }
        return bl2;
    }

    public void a(int n2, Size size) {
        int n3;
        int n4;
        switch (n2) {
            case 2: 
            case 12: {
                n4 = size.getWidth() - this.k - (this.getLeft() & 0xFFFF);
                n3 = size.getHeight() - this.l - (this.getTop() & 0xFFFF);
                break;
            }
            case 6: 
            case 8: {
                n4 = this.getLeft() & 0xFFFF;
                n3 = size.getHeight() - this.l - (this.getTop() & 0xFFFF);
                break;
            }
            case 4: 
            case 10: {
                n4 = size.getWidth() - this.k - (this.getLeft() & 0xFFFF);
                n3 = this.getTop() & 0xFFFF;
                break;
            }
            case 3: 
            case 13: {
                n4 = this.getTop() & 0xFFFF;
                n3 = size.getWidth() - this.k - (this.getLeft() & 0xFFFF);
                break;
            }
            case 7: 
            case 9: {
                n4 = size.getHeight() - this.l - (this.getTop() & 0xFFFF);
                n3 = size.getWidth() - this.k - (this.getLeft() & 0xFFFF);
                break;
            }
            case 1: 
            case 15: {
                n4 = size.getHeight() - this.l - (this.getTop() & 0xFFFF);
                n3 = this.getLeft() & 0xFFFF;
                break;
            }
            case 5: 
            case 11: {
                n4 = this.getTop() & 0xFFFF;
                n3 = this.getLeft() & 0xFFFF;
                break;
            }
            default: {
                return;
            }
        }
        this.setLeft(n4 & 0xFFFF);
        this.setTop(n3 & 0xFFFF);
    }

    @Override
    public void b(Stream stream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            GifFrameBlock.a(streamContainer, new Rectangle(this.m & 0xFFFF, this.n & 0xFFFF, this.k, this.l), this.o);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                com.aspose.imaging.internal.eZ.c.a(streamContainer, iColorPalette);
            }
            GifOptions gifOptions = new GifOptions();
            gifOptions.setInterlaced(this.getInterlaced());
            gifOptions.setMaxDiff(0);
            GifFrameBlock.a(this, streamContainer, this.n(), this.j, this.getBounds(), gifOptions);
        }
        finally {
            streamContainer.close();
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.k = n2;
        this.l = n3;
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (this.hasTransparentColor()) {
            int n2 = this.getTransparentColor().toArgb();
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.n();
            }
            this.a(n2, iColorPalette3);
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.o = GifFrameBlock.createFlags(iColorPalette2, (this.o & 0x20) > 0, (this.o & 0x40) > 0);
        if (this.l()) {
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.n();
            }
            this.setGifFrameBitsPerPixel((byte)com.aspose.imaging.internal.jp.c.a(iColorPalette3));
        }
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    public IColorPalette n() {
        IColorPalette iColorPalette = null;
        if (this.getContainer() != null) {
            iColorPalette = this.getContainer().getPalette();
        }
        return GifFrameBlock.getColorPalette(this.getPalette(), iColorPalette);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(int n2, IColorPalette iColorPalette) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            if (!(this.getContainer() instanceof GifImage)) throw new FrameworkException("The block does not belong to any image so transparent color could not be set.");
            IGifBlock[] iGifBlockArray = ((GifImage)this.getContainer()).s();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = (GifImage)this.getContainer();
                GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
                gifGraphicsControlBlock2.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
                gifGraphicsControlBlock2.setTransparentColor(true);
                gifImage.a(i2, gifGraphicsControlBlock2);
                return;
            }
            return;
        } else {
            gifGraphicsControlBlock.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
            gifGraphicsControlBlock.setTransparentColor(true);
        }
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.o = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.m = n2;
        this.n = n3;
        this.j = (by2 & 0xFF) > 8 ? (byte)8 : ((by2 & 0xFF) < 2 ? (byte)2 : by2);
        this.k = n4;
        this.l = n5;
    }

    private void r() {
        GifImage gifImage = (GifImage)this.getContainer();
        if (gifImage == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (Image image : gifImage.getPages()) {
            GifGraphicsControlBlock gifGraphicsControlBlock;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)image;
            if (n3 > 0 && (gifGraphicsControlBlock = gifFrameBlock.getControlBlock()) != null) {
                switch (gifGraphicsControlBlock.getDisposalMethod()) {
                    case 0: 
                    case 2: {
                        n2 = n3;
                        break;
                    }
                    case 3: {
                        n2 = bC.d(0, n3 - 2);
                        break;
                    }
                }
            }
            gifFrameBlock.q = n2;
            gifFrameBlock.r = n3++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GifFrameBlock f(boolean bl2) {
        GifFrameBlock gifFrameBlock;
        GifImage gifImage;
        if (bl2) {
            this.r();
        }
        if ((gifImage = (GifImage)this.getContainer()) == null || gifImage.getPageCount() < 2) {
            return this;
        }
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null && gifGraphicsControlBlock.getDisposalMethod() == 2) {
            gifFrameBlock = new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF);
            boolean bl3 = true;
            try {
                int[] nArray = new int[gifFrameBlock.k];
                int n2 = this.getBackgroundColor().toArgb();
                Arrays.fill(nArray, n2);
                for (int i2 = 0; i2 < gifFrameBlock.l; ++i2) {
                    gifFrameBlock.saveArgb32Pixels(new Rectangle(0, i2, gifFrameBlock.k, 1), nArray);
                }
                bl3 = false;
            }
            finally {
                if (bl3) {
                    gifFrameBlock.close();
                }
            }
        } else {
            gifFrameBlock = this.q == this.r ? new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF) : ((GifFrameBlock)gifImage.getPages()[this.r - 1]).f(false);
        }
        gifFrameBlock.a(this.j());
        this.a(gifFrameBlock, this);
        return gifFrameBlock;
    }

    private void a(RasterImage rasterImage, RasterImage rasterImage2) {
        GifFrameBlock gifFrameBlock = (GifFrameBlock)rasterImage2;
        Rectangle rectangle = new Rectangle(gifFrameBlock.getLeft() & 0xFFFF, gifFrameBlock.getTop() & 0xFFFF, gifFrameBlock.k, gifFrameBlock.l);
        aK aK2 = new aK(rasterImage2, rectangle, rasterImage);
        rasterImage.a(this.getContainer());
        ((GifFrameBlock)rasterImage).p = this.getControlBlock();
        rasterImage.loadPartialArgb32Pixels(rectangle, aK2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(bP bP2, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        boolean bl4 = true;
        try {
            RasterImage rasterImage = bP2.a();
            this.a(rasterImage.getPalette(), n2, n3, rasterImage.getWidth(), rasterImage.getHeight(), bl2, bl3, by2);
            this.setPalette(rasterImage.getPalette());
            this.setDataLoader(bP2);
            bl4 = false;
        }
        finally {
            if (bl4) {
                bP2.dispose();
            }
        }
    }

    private static class a
    extends DisposableObject
    implements IAdvancedBufferProcessor,
    IPartialArgb32PixelLoader,
    IPartialRawDataLoader,
    aC {
        private final StreamContainer a;
        private final IColorPalette b;
        private final cc c;
        private final g d;
        private final Rectangle e = new Rectangle();
        private final RasterImage f;
        private final e<Byte> g;
        private final Color h = new Color();
        private final boolean i;
        private byte[] j;
        private int k;
        private int l;
        private final br m;

        public a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, int n2, Rectangle rectangle, int n3, Color color) {
            this.f = rasterImage;
            this.b = iColorPalette;
            color.CloneTo(this.h);
            this.i = !color.isEmpty();
            this.a = new StreamContainer(streamContainer.a());
            this.a.seekBegin();
            if (n3 > 0) {
                GifGraphicsControlBlock gifGraphicsControlBlock;
                int n4 = -1;
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qm.d.a(this.f, GifFrameBlock.class));
                if (gifFrameBlock != null && (gifGraphicsControlBlock = gifFrameBlock.getControlBlock()) != null) {
                    n4 = gifGraphicsControlBlock.getTransparentColorIndex() & 0xFF;
                }
                this.d = new n(this, n2, n3, iColorPalette, n4);
            } else {
                this.d = new g(this, n2);
            }
            this.d.d();
            rectangle.CloneTo(this.e);
            this.l = rectangle.getWidth() * rectangle.getHeight();
            if (this.f.h().c()) {
                this.g = com.aspose.imaging.internal.E.a.a(Byte.TYPE, 1);
                this.c = null;
            } else {
                this.j = (byte[])z.b(0).c(Byte.TYPE, (long)rectangle.getWidth() * (long)rectangle.getHeight());
                this.c = new cc(iColorPalette);
                this.g = null;
            }
            this.m = new br(this.f, this.e, this, iColorPalette, true);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            if (this.g != null) {
                this.a(rectangle, nArray);
                return;
            }
            byte[] byArray = this.j;
            int n2 = this.k;
            cc cc2 = this.c;
            this.k = this.a(byArray, n2, nArray, cc2);
            this.l -= nArray.length;
            if (this.l == 0) {
                this.a(false);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.d.a(byArray, byArray.length);
            this.l -= byArray.length;
            if (this.l == 0) {
                this.d.a(this.e.getHeight());
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            this.a.write(byArray, 0, n2);
        }

        @Override
        public void finishRow() {
        }

        @Override
        public void finishRows(int n2) {
        }

        @Override
        public void a(Rectangle rectangle) {
            this.f.loadPartialArgb32Pixels(rectangle, this.m);
        }

        public void a(boolean bl2) {
            if (!bl2 || this.l > 0) {
                this.m.a();
                this.d.a(this.j, this.k);
                this.d.a(this.e.getHeight());
            }
        }

        private int a(byte[] byArray, int n2, int[] nArray, IColorPalette iColorPalette) {
            int n3;
            Object object;
            int n4 = bC.d(byArray.length - n2, nArray.length);
            int n5 = 0;
            int n6 = -1;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qm.d.a(this.f, GifFrameBlock.class));
            int n7 = 0;
            if (gifFrameBlock != null && gifFrameBlock.getControlBlock() != null && gifFrameBlock.hasTransparentColor()) {
                n6 = gifFrameBlock.getControlBlock().getTransparentColorIndex() & 0xFF;
                object = gifFrameBlock.getTransparentColor();
                n3 = iColorPalette.getEntriesCount() == gifFrameBlock.n().getEntriesCount() && iColorPalette.getEntriesCount() > n6 && iColorPalette.getArgb32Color(n6) == ((Color)object).toArgb() ? 1 : 0;
                n6 = (n3 != 0 ? (byte)n6 : (byte)iColorPalette.getNearestColorIndex((Color)object)) & 0xFF;
            } else if (this.f.hasAlpha()) {
                n6 = 0;
            }
            object = InterruptMonitor.getThreadLocalInstance();
            do {
                int n8;
                if (n6 == -1) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (object != null && object.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n8 = this.i ? com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock$a.a(nArray[n5++], this.h) : com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock$a.a(nArray[n5++]);
                        byArray[n2++] = (byte)iColorPalette.getNearestColorIndex(n8);
                    }
                } else {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (object != null && object.isInterrupted()) {
                            throw new OperationInterruptedException("The operation has been interrupted.");
                        }
                        n8 = this.i ? com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock$a.a(nArray[n5++], this.h) : com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock$a.a(nArray[n5++]);
                        byArray[n2++] = n8 == n7 ? (byte)n6 : (byte)iColorPalette.getNearestColorIndex(n8);
                    }
                }
                if (byArray.length - n2 != 0) continue;
                this.d.a(byArray, n2);
                n2 = 0;
            } while ((n4 = bC.d(byArray.length - n2, nArray.length - n5)) > 0);
            return n2;
        }

        @Override
        protected void releaseManagedResources() {
            this.m.dispose();
            this.a.dispose();
            super.releaseManagedResources();
        }

        protected static int a(int n2) {
            if (n2 == 0 || n2 >> 24 == 0) {
                return 0;
            }
            return (int)(((long)n2 | 0xFF000000L) & 0xFFFFFFFFL);
        }

        protected static int a(int n2, Color color) {
            int n3 = n2 >> 24 & 0xFF;
            if (n2 == 0 || n3 == 0) {
                return 0;
            }
            if (n3 == 255) {
                return (int)(((long)n2 | 0xFF000000L) & 0xFFFFFFFFL);
            }
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            n4 = bM.a(n4, n3);
            n5 = bM.a(n5, n3);
            n6 = bM.a(n6, n3);
            int n7 = bM.a(color.getR() & 0xFF, 255 - n3);
            int n8 = bM.a(color.getG() & 0xFF, 255 - n3);
            int n9 = bM.a(color.getB() & 0xFF, 255 - n3);
            return (int)(((long)((n4 += n7) << 16 | (n5 += n8) << 8 | (n6 += n9)) | 0xFF000000L) & 0xFFFFFFFFL);
        }

        private void a(Rectangle rectangle, int[] nArray) {
            this.j = (byte[])this.g.a(rectangle.getWidth() * rectangle.getHeight());
            this.k = 0;
            byte[] byArray = this.j;
            int n2 = this.k;
            this.k = this.a(byArray, n2, nArray, this.b);
            this.l -= nArray.length;
            if (this.l == 0) {
                this.a(false);
            } else {
                this.d.a(this.j, this.k);
            }
        }
    }
}

