/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.dicom;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.DicomImageException;
import com.aspose.imaging.fileformats.dicom.DicomImageInfo;
import com.aspose.imaging.fileformats.dicom.DicomPage;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.DicomOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.Z.b;
import com.aspose.imaging.internal.ac.c;
import com.aspose.imaging.internal.ac.g;
import com.aspose.imaging.internal.cq.M;
import com.aspose.imaging.internal.iP.e;
import com.aspose.imaging.internal.iP.f;
import com.aspose.imaging.internal.li.aV;
import com.aspose.imaging.internal.li.au;
import com.aspose.imaging.internal.qm.d;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public final class DicomImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private static final String i = "pageIndex";
    private DicomImageInfo j = DicomImageInfo.d();
    private List<DicomPage> k;
    private DicomPage l;
    private com.aspose.imaging.internal.Q.a m;

    public DicomImage(DicomOptions dicomOptions, int n2, int n3) {
        this.b(n2, n3);
        this.a(new a(this));
        this.a(DicomImage.class, com.aspose.imaging.internal.iP.e.a());
    }

    public DicomImage(InputStream inputStream, LoadOptions loadOptions) {
        this(Stream.fromJava(inputStream), loadOptions);
    }

    DicomImage(Stream stream, LoadOptions loadOptions) {
        this(new StreamContainer(stream), loadOptions);
    }

    public DicomImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    DicomImage(Stream stream) {
        this(stream, new LoadOptions());
    }

    private DicomImage(StreamContainer streamContainer, LoadOptions loadOptions) {
        if (loadOptions == null) {
            loadOptions = new LoadOptions();
        } else {
            this.a((Object)loadOptions);
        }
        this.a(new a(this));
        this.a(streamContainer);
        this.a(loadOptions);
        this.a((Object)loadOptions);
    }

    @Override
    public int getPageCount() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.j.getNumberOfFrames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image[] getPages() {
        if (this.k == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.getPageCount()];
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.k.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                DicomPage dicomPage = (DicomPage)iGenericEnumerator.next();
                imageArray[n2++] = dicomPage;
            }
        }
        finally {
            if (com.aspose.imaging.internal.qm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
        return imageArray;
    }

    @Override
    public Image n() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.getActivePage();
    }

    public DicomImageInfo getFileInfo() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.j;
    }

    public DicomPage[] getDicomPages() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.k.toArray((DicomPage[])new DicomPage[0]);
    }

    public DicomPage getActivePage() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.l;
    }

    public void setActivePage(DicomPage dicomPage) {
        this.verifyNotDisposed();
        if (dicomPage == null) {
            throw new ArgumentNullException("ActivePage");
        }
        if (dicomPage.getContainer() != this) {
            throw new DicomImageException("The active page cannot be set as it belongs to another image.");
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
        this.l = dicomPage;
    }

    public int getActivePageIndex() {
        this.verifyNotDisposed();
        DicomPage dicomPage = this.getActivePage();
        return dicomPage != null ? dicomPage.getIndex() : -1;
    }

    @Override
    public long getFileFormat() {
        return 8192L;
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    @Override
    public PageExportingAction getPageExportingAction() {
        return null;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        throw new NotSupportedException("DicomImage does not support batch export mode.");
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    public com.aspose.imaging.internal.Q.a r() {
        return this.m;
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
        DicomPage dicomPage = this.addPage();
        Rectangle rectangle = rasterImage.getBounds();
        int[] nArray = rasterImage.loadArgb32Pixels(rectangle);
        dicomPage.saveArgb32Pixels(rectangle, nArray);
    }

    public void saveAll(String string, ImageOptionsBase imageOptionsBase) {
        this.verifyNotDisposed();
        int n2 = 1;
        this.a(DicomImage.class, com.aspose.imaging.internal.iP.e.a());
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.save(aV.a(new String[]{au.b(n2), string}), imageOptionsBase);
        }
        this.b(this.getDataStreamContainer().a());
    }

    @Override
    public void setResolution(double d2, double d3) {
        throw new NotImplementedException("The method is not implemented");
    }

    public void resizeProportional(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iP.e.a());
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        for (DicomPage dicomPage : this.getDicomPages()) {
            int n5 = com.aspose.imaging.internal.qm.d.e(d2 * (double)dicomPage.getWidth() + 0.5);
            int n6 = com.aspose.imaging.internal.qm.d.e(d3 * (double)dicomPage.getHeight() + 0.5);
            dicomPage.resize(n5, n6, n4);
        }
    }

    public DicomPage addPage() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iP.e.a());
        DicomPage dicomPage = DicomPage.a(this);
        dicomPage.setIndex_internalized(this.j.getNumberOfFrames());
        this.j.g(this.j.getNumberOfFrames() + 1);
        this.k.addItem(dicomPage);
        return dicomPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomPage insertPage(int n2) {
        this.verifyNotDisposed();
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException(i, "Page index is less than 0.");
        }
        if (n2 > this.getPageCount()) {
            throw new ArgumentOutOfRangeException(i, "Page index is greater than PageCount.");
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
        DicomPage dicomPage = DicomPage.a(this);
        this.k.insertItem(n2, dicomPage);
        int n3 = 0;
        IGenericEnumerator iGenericEnumerator = this.k.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                DicomPage dicomPage2 = (DicomPage)iGenericEnumerator.next();
                if (n3 >= n2) {
                    dicomPage2.setIndex_internalized(n3);
                }
                ++n3;
            }
        }
        finally {
            if (com.aspose.imaging.internal.qm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.j.g(this.j.getNumberOfFrames() + 1);
        return dicomPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int n2) {
        this.verifyNotDisposed();
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException(i, "Page index is less than 0.");
        }
        if (n2 >= this.getPageCount()) {
            throw new ArgumentOutOfRangeException(i, "Page index is equal to or greater than PageCount.");
        }
        int n3 = this.getActivePageIndex();
        this.k.get_Item(n2).dispose();
        this.k.removeAt(n2);
        this.j.g(this.j.getNumberOfFrames() - 1);
        int n4 = 0;
        IGenericEnumerator iGenericEnumerator = this.k.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                DicomPage dicomPage = (DicomPage)iGenericEnumerator.next();
                if (n4 >= n2) {
                    dicomPage.setIndex_internalized(n4);
                }
                ++n4;
            }
        }
        finally {
            if (com.aspose.imaging.internal.qm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        if (n3 == n2) {
            this.l = this.j.getNumberOfFrames() > 0 ? this.k.get_Item(0) : null;
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color);
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        super.resize(n2, n3, n4);
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle);
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle, filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    @Override
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        super.a(stream, imageOptionsBase, rectangle);
    }

    @Override
    public void cacheData() {
        super.cacheData();
    }

    public static DicomImage a(StreamContainer streamContainer, LoadOptions loadOptions) {
        return new DicomImage(streamContainer, loadOptions);
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    @Override
    protected void a(Rectangle rectangle, int[] nArray) {
        this.verifyNotDisposed();
        DicomPage dicomPage = this.getActivePage();
        if (dicomPage == null) {
            return;
        }
        dicomPage.saveArgb32Pixels(rectangle, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        DicomOptions dicomOptions = com.aspose.imaging.internal.Z.b.a();
        try {
            List<c> list = com.aspose.imaging.internal.Z.b.a(this.xmpData);
            if (list.size() > 0) {
                this.j.c().addRange(list);
            }
            g g2 = new g(stream, this.getBounds(), this.h(), dicomOptions, this.getPageCount(), this.j.c());
            g2.a();
            IGenericEnumerator iGenericEnumerator = this.k.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    DicomPage dicomPage = (DicomPage)iGenericEnumerator.next();
                    g2.a(dicomPage);
                    com.aspose.imaging.internal.iP.f.a(this.h, dicomPage.h);
                }
            }
            finally {
                if (com.aspose.imaging.internal.qm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            g2.b();
        }
        finally {
            dicomOptions.close();
        }
    }

    @Override
    protected void releaseManagedResources() {
        if (this.m != null) {
            this.m.dispose();
        }
        super.releaseManagedResources();
    }

    private void a(LoadOptions loadOptions) {
        if (this.getDataStreamContainer().a() == null) {
            throw new ArgumentNullException("The stream is null.");
        }
        this.j = DicomImageInfo.d();
        this.j.g(1);
        M m2 = new M(this.getDataStreamContainer().a(), this.j);
        m2.b();
        this.m = m2.a();
        int n2 = 1;
        if (this.j.getNumberOfFrames() > 0) {
            n2 = this.j.getNumberOfFrames();
        }
        this.k = new List(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.k.addItem(new DicomPage(this, i2, loadOptions));
        }
        this.l = this.k.get_Item(0);
    }

    private void b(int n2, int n3) {
        this.j = DicomImageInfo.d();
        this.j.d(n2);
        this.j.e(n3);
        this.j.g(1);
        this.l = DicomPage.a(this);
        this.l.setIndex_internalized(0);
        List<DicomPage> list = new List<DicomPage>();
        list.addItem(this.l);
        this.k = list;
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<DicomImage> a;

        public a(DicomImage dicomImage) {
            this.a = new WeakReference<DicomImage>(dicomImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            DicomPage dicomPage = ((DicomImage)this.a.get()).l;
            return dicomPage != null && dicomPage.isRawDataAvailable();
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            DicomPage dicomPage = ((DicomImage)this.a.get()).l;
            return dicomPage != null ? dicomPage.getRawDataSettings() : null;
        }

        @Override
        public final void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            ((DicomImage)this.a.get()).verifyNotDisposed();
            DicomPage dicomPage = ((DicomImage)this.a.get()).l;
            if (dicomPage == null) {
                return;
            }
            dicomPage.loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
        }

        @Override
        public final void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            ((DicomImage)this.a.get()).verifyNotDisposed();
            DicomPage dicomPage = ((DicomImage)this.a.get()).l;
            if (dicomPage == null) {
                return;
            }
            dicomPage.loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
        }
    }
}

