/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.general.PBKD;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseKDFSecretKeyFactory;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.PBKDFPBEKey;
import com.aspose.html.utils.ms.core.bc.util.Strings;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

class ProvOpenSSLPBKDF
extends AlgorithmProvider {
    private static final String PREFIX = ProvOpenSSLPBKDF.class.getName();

    ProvOpenSSLPBKDF() {
    }

    void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-OPENSSL", PREFIX + "$PBKDF", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new PBKDF();
            }
        }));
    }

    static class PBKDF
    extends BaseKDFSecretKeyFactory {
        PBKDF() {
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                if (pBEKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("Positive key length required: " + pBEKeySpec.getKeyLength());
                }
                PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.OpenSSL.using(Strings.toByteArray(pBEKeySpec.getPassword())).withSalt(pBEKeySpec.getSalt()));
                return new PBKDFPBEKey(passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, pBEKeySpec.getKeyLength() / 8), "PBKDF-OpenSSL", pBEKeySpec);
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

