/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.KDFCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.ConcatenationKDFGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAES;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAgreementParameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsEngineProvider;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsKDFOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSelfTestFailedError;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsTripleDES;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.crypto.fips.KDF2BytesGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.KDFCounterBytesGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.KDFDoublePipelineIterationBytesGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.KDFFeedbackBytesGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.MD5Digest;
import com.aspose.html.utils.ms.core.bc.crypto.fips.SelfTestExecutor;
import com.aspose.html.utils.ms.core.bc.crypto.fips.Utils;
import com.aspose.html.utils.ms.core.bc.crypto.fips.VariantKatTest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ExtendedDigest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.StreamCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.macs.HMac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.SICBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KDFCounterParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KDFDoublePipelineIterationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KDFFeedbackParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KDFParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.internal.test.BasicKatTest;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Pack;
import com.aspose.html.utils.ms.core.bc.util.Properties;
import com.aspose.html.utils.ms.core.bc.util.Strings;
import com.aspose.html.utils.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsKDF {
    private static final byte[] ZERO_BYTE = new byte[1];
    public static final CounterModeParametersBuilder COUNTER_MODE = new CounterModeParametersBuilder(new FipsAlgorithm("CounterMode"));
    public static final FeedbackModeParametersBuilder FEEDBACK_MODE = new FeedbackModeParametersBuilder(new FipsAlgorithm("FeedbackMode"));
    public static final DoublePipelineModeParametersBuilder DOUBLE_PIPELINE_ITERATION_MODE = new DoublePipelineModeParametersBuilder(new FipsAlgorithm("DoublePipelineIterationMode"));
    public static final SSHParametersBuilder SSH = new SSHParametersBuilder(new FipsAlgorithm("SSH"), SSHPRF.SHA1);
    public static final IKEv2ParametersBuilder IKEv2 = new IKEv2ParametersBuilder(new FipsAlgorithm("IKEv2"), IKEv2PRF.SHA1);
    public static final SRTPParametersBuilder SRTP = new SRTPParametersBuilder(new FipsAlgorithm("SRTP"), SRTPPRF.AES_CM);
    public static final TLSParametersBuilder TLS1_0 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.0"));
    public static final TLSParametersBuilder TLS1_1 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.1"));
    public static final TLSParametersWithPRFBuilder TLS1_2 = new TLSParametersWithPRFBuilder(new FipsAlgorithm("TLS1.2"), TLSPRF.SHA256_HMAC);
    public static final AgreementKDFParametersBuilder X963 = new AgreementKDFParametersBuilder(new FipsAlgorithm("X9.63"), AgreementKDFPRF.SHA1);
    public static final AgreementKDFParametersBuilder CONCATENATION = new AgreementKDFParametersBuilder(new FipsAlgorithm("Concatenation"), AgreementKDFPRF.SHA1);
    private static EngineProvider<Digest> md5Provider;

    private FipsKDF() {
    }

    private static byte[] buildFixedInput(byte[] byArray, byte[] byArray2, int n2) {
        return Arrays.concatenate(byArray, ZERO_BYTE, byArray2, Pack.intToBigEndian(n2));
    }

    private static FipsEngineProvider<Mac> createPRF(PRF pRF) {
        FipsEngineProvider<Mac> fipsEngineProvider;
        if (pRF == PRF.TRIPLEDES_CMAC) {
            if (!FipsStatus.isBooting() && CryptoServicesRegistrar.isInApprovedOnlyMode() && !Properties.isOverrideSet("com.aspose.html.utils.ms.core.bc.tripledes.allow_prf")) {
                throw new FipsUnapprovedOperationError("Triple-DES prf disallowed");
            }
            fipsEngineProvider = FipsTripleDES.getMacProvider(FipsTripleDES.CMAC.getAlgorithm());
        } else {
            fipsEngineProvider = pRF == PRF.AES_CMAC ? FipsAES.getMacProvider(FipsAES.CMAC.getAlgorithm()) : FipsSHS.getMacProvider(pRF.algorithm);
        }
        if (fipsEngineProvider == null) {
            throw new IllegalArgumentException("Unknown algorithm passed to FipsKDF.createPRF: " + (Object)((Object)pRF));
        }
        return fipsEngineProvider;
    }

    static byte[] processZBytes(byte[] byArray, FipsAgreementParameters fipsAgreementParameters) {
        PRF pRF = fipsAgreementParameters.getPrfAlgorithm();
        byte[] byArray2 = fipsAgreementParameters.salt;
        FipsAlgorithm fipsAlgorithm = fipsAgreementParameters.digestAlgorithm;
        AgreementOperatorFactory agreementOperatorFactory = new AgreementOperatorFactory();
        AgreementKDFParametersBuilder agreementKDFParametersBuilder = fipsAgreementParameters.kdfType;
        if (pRF == PRF.TRIPLEDES_CMAC && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Requested PRF has insufficient security level for approved mode: " + pRF.name());
        }
        if (pRF != null) {
            Mac mac = (Mac)FipsKDF.createPRF(pRF).createEngine();
            if (byArray2 == null) {
                if (mac instanceof HMac) {
                    mac.init(new KeyParameterImpl(new byte[((HMac)mac).getUnderlyingDigest().getByteLength()]));
                } else {
                    mac.init(new KeyParameterImpl(new byte[16]));
                }
            } else {
                mac.init(new KeyParameterImpl(Arrays.clone(byArray2)));
            }
            byte[] byArray3 = new byte[mac.getMacSize()];
            mac.update(byArray, 0, byArray.length);
            mac.doFinal(byArray3, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray3;
        }
        if (fipsAlgorithm != null) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(fipsAlgorithm);
            byte[] byArray4 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.update(byArray, 0, byArray.length);
            extendedDigest.doFinal(byArray4, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray4;
        }
        if (agreementKDFParametersBuilder != null) {
            KDFCalculator<AgreementKDFParameters> kDFCalculator = agreementOperatorFactory.createKDFCalculator(agreementKDFParametersBuilder.using(byArray).withIV(byArray2));
            Arrays.fill(byArray, (byte)0);
            byte[] byArray5 = new byte[fipsAgreementParameters.outputSize];
            kDFCalculator.generateBytes(byArray5);
            return byArray5;
        }
        return byArray;
    }

    private static byte[] PRF(TLSParameters tLSParameters, TLSPRF tLSPRF, byte[] byArray, String string, int n2) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        Mac mac = FipsSHS.createHMac(tLSPRF.algorithm);
        byte[] byArray4 = new byte[n2];
        FipsKDF.hmac_hash(mac, byArray, byArray3, byArray4);
        return byArray4;
    }

    private static byte[] PRF_legacy(TLSParameters tLSParameters, byte[] byArray, String string, int n2, Mac mac, Mac mac2) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        int n3 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, byArray.length - n3, byArray5, 0, n3);
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        FipsKDF.hmac_hash(mac, byArray4, byArray3, byArray6);
        FipsKDF.hmac_hash(mac2, byArray5, byArray3, byArray7);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray7[i2]);
        }
        return byArray6;
    }

    private static void hmac_hash(Mac mac, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        mac.init(new KeyParameterImpl(byArray));
        byte[] byArray4 = byArray2;
        int n2 = mac.getMacSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[mac.getMacSize()];
        byte[] byArray6 = new byte[mac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    private static KDFCalculator<AgreementKDFParameters> createX963KDFCalculator(boolean bl2, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl2, agreementKDFParameters.getAlgorithm());
        final KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(FipsSHS.createDigest(((AgreementKDFPRF)agreementKDFParameters.getAlgorithm().basicVariation()).algorithm));
        kDF2BytesGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl2, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n2, int n3) {
                kDF2BytesGenerator.generateBytes(byArray, n2, n3);
            }
        });
    }

    private static KDFCalculator<AgreementKDFParameters> createConcatenationKDFCalculator(boolean bl2, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl2, agreementKDFParameters.getAlgorithm());
        final ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFGenerator(FipsSHS.createDigest(((AgreementKDFPRF)agreementKDFParameters.getAlgorithm().basicVariation()).algorithm));
        concatenationKDFGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl2, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n2, int n3) {
                concatenationKDFGenerator.generateBytes(byArray, n2, n3);
            }
        });
    }

    private static void tlsLegacyKAT() {
        HMac hMac = new HMac(new MD5Digest());
        Mac mac = FipsSHS.createHMac(FipsSHS.Algorithm.SHA1_HMAC);
        TLSParameters tLSParameters = new TLSParameters(TLS1_0.getAlgorithm(), Hex.decode("0102030405060708090a0b0c0d0e0f"), "master secret", Hex.decode("deadbeefbeefdead"));
        byte[] byArray = FipsKDF.PRF_legacy(tLSParameters, tLSParameters.secret, tLSParameters.label, 32, hMac, mac);
        if (!Arrays.areEqual(byArray, Hex.decode("ef9dca01113c0f6fcaef528e604b3092c8e65022de73a1b117408297a0d969a9"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: TLS Legacy KAT", TLS1_0.getAlgorithm()));
        }
    }

    private static void tls1_1and2KAT() {
        TLSParameters tLSParameters = new TLSParameters(TLS1_2.getAlgorithm(), Hex.decode("0102030405060708090a0b0c0d0e0f"), "master secret", Hex.decode("deadbeefbeefdead"));
        byte[] byArray = FipsKDF.PRF(tLSParameters, TLSPRF.SHA256_HMAC, tLSParameters.secret, tLSParameters.label, 32);
        if (!Arrays.areEqual(byArray, Hex.decode("fd9224c363882243d0d949139981093693407e438a508b3c324fd163247e210f"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: TLS KAT", TLS1_1.getAlgorithm()));
        }
    }

    private static void sshKAT() {
        ExtendedDigest extendedDigest = FipsSHS.createDigest(FipsSHS.Algorithm.SHA256);
        SSHParameters sSHParameters = new SSHParameters(SSH.getAlgorithm(), 'A', Hex.decode("0102030405060708090a0b0c0d0e0f"), Hex.decode("deadbeefbeefdead"), Hex.decode("a1a2a3a4a5a6a7a8a9a0aaabacadaeaf"));
        byte[] byArray = new byte[32];
        SSHOperatorFactory.hash(extendedDigest, sSHParameters, byArray, 0, 32);
        if (!Arrays.areEqual(byArray, Hex.decode("5ec5d5b69202eecc55e4d932cd9907352c349b0c2ecd2432356dba984495cf2d"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: SSH KAT", SSH.getAlgorithm()));
        }
    }

    static {
        new CounterModeProvider(PRF.AES_CMAC).createEngine();
        new CounterModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new CounterModeProvider(PRF.SHA1_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA224_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA256_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA384_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_256_HMAC).createEngine();
        new FeedbackModeProvider(PRF.AES_CMAC).createEngine();
        new FeedbackModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA1_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA224_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA256_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA384_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_256_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.AES_CMAC).createEngine();
        new DoublePipelineModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA1_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA224_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA256_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA384_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_256_HMAC).createEngine();
        FipsKDF.tlsLegacyKAT();
        FipsKDF.tls1_1and2KAT();
        FipsKDF.sshKAT();
        md5Provider = new EngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return SelfTestExecutor.validate(TLS1_0.getAlgorithm(), new MD5Digest(), new Md5KatTest());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementKDFPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512),
        SHA512_224(FipsSHS.Algorithm.SHA512_224),
        SHA512_256(FipsSHS.Algorithm.SHA512_256),
        SHA3_224(FipsSHS.Algorithm.SHA3_224),
        SHA3_256(FipsSHS.Algorithm.SHA3_256),
        SHA3_384(FipsSHS.Algorithm.SHA3_384),
        SHA3_512(FipsSHS.Algorithm.SHA3_512);

        private final FipsAlgorithm algorithm;

        private AgreementKDFPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class AgreementKDFParameters
    extends FipsParameters {
        private final byte[] shared;
        private final byte[] iv;

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            this(fipsAlgorithm, byArray, null);
        }

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.shared = byArray;
            this.iv = byArray2;
        }

        public AgreementKDFParameters withIV(byte[] byArray) {
            return new AgreementKDFParameters(this.getAlgorithm(), this.shared, Arrays.clone(byArray));
        }
    }

    public static final class AgreementKDFParametersBuilder
    extends FipsParameters {
        AgreementKDFPRF prf;

        AgreementKDFParametersBuilder(FipsAlgorithm fipsAlgorithm, AgreementKDFPRF agreementKDFPRF) {
            super(fipsAlgorithm);
            this.prf = agreementKDFPRF;
        }

        public AgreementKDFParametersBuilder withPRF(AgreementKDFPRF agreementKDFPRF) {
            return new AgreementKDFParametersBuilder(this.getAlgorithm(), agreementKDFPRF);
        }

        public AgreementKDFParameters using(byte[] byArray) {
            return new AgreementKDFParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray));
        }

        public AgreementKDFPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AgreementOperatorFactory
    extends FipsKDFOperatorFactory<AgreementKDFParameters> {
        @Override
        public KDFCalculator<AgreementKDFParameters> createKDFCalculator(AgreementKDFParameters agreementKDFParameters) {
            if (agreementKDFParameters.getAlgorithm().getName().startsWith(X963.getAlgorithm().getName())) {
                return FipsKDF.createX963KDFCalculator(this.approvedModeOnly, agreementKDFParameters);
            }
            return FipsKDF.createConcatenationKDFCalculator(this.approvedModeOnly, agreementKDFParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface BaseKDFCalculator<T extends Parameters> {
        public T getParameters();

        public void generateBytes(byte[] var1, int var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CounterLocation {
        AFTER_ITERATION_DATA(1),
        AFTER_FIXED_INPUT(2),
        BEFORE_ITERATION_DATA(0);

        private final int code;

        private CounterLocation(int n3) {
            this.code = n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CounterModeFactory
    extends FipsKDFOperatorFactory<CounterModeParameters> {
        @Override
        public KDFCalculator<CounterModeParameters> createKDFCalculator(final CounterModeParameters counterModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, counterModeParameters.getAlgorithm());
            final KDFCounterBytesGenerator kDFCounterBytesGenerator = new CounterModeProvider(counterModeParameters.getAlgorithm()).createEngine();
            kDFCounterBytesGenerator.init(new KDFCounterParameters(counterModeParameters.ki, counterModeParameters.fixedInputPrefix, counterModeParameters.fixedInputSuffix, counterModeParameters.r));
            return new MonitoringKDFCalculator<CounterModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<CounterModeParameters>(){

                @Override
                public CounterModeParameters getParameters() {
                    return counterModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    kDFCounterBytesGenerator.generateBytes(byArray, n2, n3);
                }
            });
        }
    }

    public static final class CounterModeParameters
    extends FipsParameters {
        final int r;
        final byte[] ki;
        final byte[] fixedInputPrefix;
        final byte[] fixedInputSuffix;

        private CounterModeParameters(FipsAlgorithm fipsAlgorithm, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n2;
            this.ki = byArray;
            this.fixedInputPrefix = byArray2;
            this.fixedInputSuffix = byArray3;
        }
    }

    public static final class CounterModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;

        CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, 8);
        }

        private CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n2) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n2;
        }

        public CounterModeParametersBuilder withPRFAndR(PRF pRF, int n2) {
            return new CounterModeParametersBuilder(this.getAlgorithm(), pRF, n2);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), null);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public CounterModeParameters using(byte[] byArray, boolean bl2, byte[] byArray2, byte[] byArray3, int n2) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), bl2 ? FipsKDF.buildFixedInput(byArray2, byArray3, n2) : null, bl2 ? null : FipsKDF.buildFixedInput(byArray2, byArray3, n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CounterModeProvider
    extends FipsEngineProvider<KDFCounterBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FIP = new byte[]{1};
        private static final byte[] FIS = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("53023e21d00cc5046b15");
        private static final byte[] tripleDes_vec = Hex.decode("d4e062f13b0baefa4943");
        private static final byte[] sha1_vec = Hex.decode("76f881b780e4939d485a");
        private static final byte[] sha224_vec = Hex.decode("66db824abdf2b4e85de2");
        private static final byte[] sha256_vec = Hex.decode("3a46d9be7ab8ea092558");
        private static final byte[] sha384_vec = Hex.decode("d209b2f985ff77301fd1");
        private static final byte[] sha512_vec = Hex.decode("0c51da7c89503acc0050");
        private static final byte[] sha512_224_vec = Hex.decode("86e14446abd90b94c828");
        private static final byte[] sha512_256_vec = Hex.decode("26593c9ef9b39d94bafc");
        private final FipsAlgorithm algorithm;

        public CounterModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public CounterModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(COUNTER_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFCounterBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFCounterBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFCounterBytesGenerator>(){

                @Override
                public void evaluate(KDFCounterBytesGenerator kDFCounterBytesGenerator) {
                    kDFCounterBytesGenerator.init(new KDFCounterParameters(KI, FIP, FIS, 8));
                    byte[] byArray = new byte[10];
                    kDFCounterBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(CounterModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublePipelineModeFactory
    extends FipsKDFOperatorFactory<DoublePipelineModeParameters> {
        @Override
        public KDFCalculator<DoublePipelineModeParameters> createKDFCalculator(final DoublePipelineModeParameters doublePipelineModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, doublePipelineModeParameters.getAlgorithm());
            final KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = new DoublePipelineModeProvider(doublePipelineModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = doublePipelineModeParameters.counterLocation;
            int n2 = doublePipelineModeParameters.r;
            if (n2 > 0) {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(counterLocation.code, doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData, n2));
            } else {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithoutCounter(doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<DoublePipelineModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<DoublePipelineModeParameters>(){

                @Override
                public DoublePipelineModeParameters getParameters() {
                    return doublePipelineModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, n2, n3);
                }
            });
        }
    }

    public static final class DoublePipelineModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] fixedInputData;

        private DoublePipelineModeParameters(FipsAlgorithm fipsAlgorithm, int n2, CounterLocation counterLocation, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.r = n2;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.fixedInputData = byArray2;
        }
    }

    public static final class DoublePipelineModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n2, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n2;
            this.counterLocation = counterLocation;
        }

        public DoublePipelineModeParametersBuilder withPRF(PRF pRF) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public DoublePipelineModeParametersBuilder withR(int n2) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n2, CounterLocation.AFTER_ITERATION_DATA);
        }

        public DoublePipelineModeParametersBuilder withRAndLocation(int n2, CounterLocation counterLocation) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n2, counterLocation);
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2));
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), FipsKDF.buildFixedInput(byArray2, byArray3, n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DoublePipelineModeProvider
    extends FipsEngineProvider<KDFDoublePipelineIterationBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("ace76ed103e31681ed03");
        private static final byte[] tripleDes_vec = Hex.decode("41d79be29b5c34ffa40d");
        private static final byte[] sha1_vec = Hex.decode("e5e5666cb2a73b8ce638");
        private static final byte[] sha224_vec = Hex.decode("c4c12b540e51d106abd8");
        private static final byte[] sha256_vec = Hex.decode("b6c232a28b4b450210ee");
        private static final byte[] sha384_vec = Hex.decode("48268b8bf87297a5ce8f");
        private static final byte[] sha512_vec = Hex.decode("52d86063e22a84188285");
        private static final byte[] sha512_224_vec = Hex.decode("d1f521fbc7e736685709");
        private static final byte[] sha512_256_vec = Hex.decode("dca0e9d25e22ca54c0ca");
        private final FipsAlgorithm algorithm;

        public DoublePipelineModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public DoublePipelineModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(DOUBLE_PIPELINE_ITERATION_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFDoublePipelineIterationBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFDoublePipelineIterationBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFDoublePipelineIterationBytesGenerator>(){

                @Override
                public void evaluate(KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator) {
                    kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(0, KI, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(DoublePipelineModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FeedbackModeFactory
    extends FipsKDFOperatorFactory<FeedbackModeParameters> {
        @Override
        public KDFCalculator<FeedbackModeParameters> createKDFCalculator(final FeedbackModeParameters feedbackModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, feedbackModeParameters.getAlgorithm());
            final KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = new FeedbackModeProvider(feedbackModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = feedbackModeParameters.counterLocation;
            int n2 = feedbackModeParameters.r;
            if (n2 > 0) {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(counterLocation.code, feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData, n2));
            } else {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithoutCounter(feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<FeedbackModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<FeedbackModeParameters>(){

                @Override
                public FeedbackModeParameters getParameters() {
                    return feedbackModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    kDFFeedbackBytesGenerator.generateBytes(byArray, n2, n3);
                }
            });
        }
    }

    public static final class FeedbackModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] iv;
        private final byte[] fixedInputData;

        private FeedbackModeParameters(FipsAlgorithm fipsAlgorithm, int n2, CounterLocation counterLocation, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n2;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.iv = byArray2;
            this.fixedInputData = byArray3;
        }
    }

    public static final class FeedbackModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n2, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n2;
            this.counterLocation = counterLocation;
        }

        public FeedbackModeParametersBuilder withPRF(PRF pRF) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public FeedbackModeParametersBuilder withR(int n2) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n2, CounterLocation.AFTER_ITERATION_DATA);
        }

        public FeedbackModeParametersBuilder withRAndLocation(int n2, CounterLocation counterLocation) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n2, counterLocation);
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), FipsKDF.buildFixedInput(byArray3, byArray4, n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FeedbackModeProvider
    extends FipsEngineProvider<KDFFeedbackBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] IV = new byte[]{1};
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("af7eb5b9a3eb72a1a0cb");
        private static final byte[] tripleDes_vec = Hex.decode("cf65681ac0d3c4f65ce0");
        private static final byte[] sha1_vec = Hex.decode("bfe9d9a6cd8b7befe0fb");
        private static final byte[] sha224_vec = Hex.decode("71d5790138202ab1edc9");
        private static final byte[] sha256_vec = Hex.decode("650d3f9da0f4a8bcf602");
        private static final byte[] sha384_vec = Hex.decode("2a9375ae10e75a9a5ba2");
        private static final byte[] sha512_vec = Hex.decode("e0f3f35c27358f3d0dda");
        private static final byte[] sha512_224_vec = Hex.decode("5fd1372077522505be4a");
        private static final byte[] sha512_256_vec = Hex.decode("ae930bec79b81ee15c67");
        private final FipsAlgorithm algorithm;

        public FeedbackModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FeedbackModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(FEEDBACK_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFFeedbackBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFFeedbackBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFFeedbackBytesGenerator>(){

                @Override
                public void evaluate(KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator) {
                    kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(2, KI, IV, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFFeedbackBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(FeedbackModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IKEv2OperatorFactory
    extends FipsKDFOperatorFactory<IKEv2Parameters> {
        @Override
        public KDFCalculator<IKEv2Parameters> createKDFCalculator(final IKEv2Parameters iKEv2Parameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, iKEv2Parameters.getAlgorithm());
            final Mac mac = FipsSHS.createHMac(((IKEv2PRF)iKEv2Parameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<IKEv2Parameters>(this.approvedModeOnly, new BaseKDFCalculator<IKEv2Parameters>(){

                @Override
                public IKEv2Parameters getParameters() {
                    return iKEv2Parameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    IKEv2OperatorFactory.prf(mac, iKEv2Parameters, byArray, n2, n3);
                }
            });
        }

        private static void prf(Mac mac, IKEv2Parameters iKEv2Parameters, byte[] byArray, int n2, int n3) {
            int n4 = mac.getMacSize();
            int n5 = (n3 + n4 - 1) / n4;
            byte[] byArray2 = new byte[n4];
            if (!iKEv2Parameters.isPlus) {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            } else {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.update((byte)1);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n2, Math.min(n4, n3));
                for (int i2 = 1; i2 < n5; ++i2) {
                    mac.update(byArray2, 0, byArray2.length);
                    mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                    mac.update((byte)(i2 + 1));
                    mac.doFinal(byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray, n2 + n4 * i2, Math.min(n4, byArray.length - n4 * i2));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IKEv2PRF {
        SHA1(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private IKEv2PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class IKEv2Parameters
    extends FipsParameters {
        private final boolean isPlus;
        private final byte[] shared;
        private final byte[] keyPad;

        IKEv2Parameters(FipsAlgorithm fipsAlgorithm, boolean bl2, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.isPlus = bl2;
            this.shared = byArray;
            this.keyPad = byArray2;
        }
    }

    public static class IKEv2ParametersBuilder
    extends FipsParameters {
        private final IKEv2PRF prf;

        IKEv2ParametersBuilder(FipsAlgorithm fipsAlgorithm, IKEv2PRF iKEv2PRF) {
            super(fipsAlgorithm);
            this.prf = iKEv2PRF;
        }

        public IKEv2ParametersBuilder withPRF(IKEv2PRF iKEv2PRF) {
            return new IKEv2ParametersBuilder(this.getAlgorithm(), iKEv2PRF);
        }

        public IKEv2PRF getPRF() {
            return this.prf;
        }

        public IKEv2Parameters createForPrf(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), false, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }

        public IKEv2Parameters createForPrfPlus(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), true, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Md5KatTest
    implements BasicKatTest<Digest> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private static final byte[] kat = Hex.decode("900150983cd24fb0d6963f7d28e17f72");

        private Md5KatTest() {
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, kat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MonitoringKDFCalculator<T extends Parameters>
    implements KDFCalculator<T> {
        private final boolean approvedModeOnly;
        private final BaseKDFCalculator<T> kdf;
        private final FipsAlgorithm algorithm;

        MonitoringKDFCalculator(boolean bl2, BaseKDFCalculator<T> baseKDFCalculator) {
            this.approvedModeOnly = bl2;
            this.kdf = baseKDFCalculator;
            this.algorithm = (FipsAlgorithm)baseKDFCalculator.getParameters().getAlgorithm();
        }

        @Override
        public T getParameters() {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            return this.kdf.getParameters();
        }

        @Override
        public void generateBytes(byte[] byArray) {
            this.generateBytes(byArray, 0, byArray.length);
        }

        @Override
        public void generateBytes(byte[] byArray, int n2, int n3) {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            this.kdf.generateBytes(byArray, n2, n3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PRF {
        AES_CMAC(FipsAES.CMAC.getAlgorithm()),
        TRIPLEDES_CMAC(FipsTripleDES.CMAC.getAlgorithm()),
        SHA1_HMAC(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224_HMAC(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC),
        SHA512_224_HMAC(FipsSHS.Algorithm.SHA512_224_HMAC),
        SHA512_256_HMAC(FipsSHS.Algorithm.SHA512_256_HMAC);

        private final FipsAlgorithm algorithm;

        private PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SRTPOperatorFactory
    extends FipsKDFOperatorFactory<SRTPParameters> {
        @Override
        public KDFCalculator<SRTPParameters> createKDFCalculator(final SRTPParameters sRTPParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sRTPParameters.getAlgorithm());
            final SICBlockCipher sICBlockCipher = new SICBlockCipher((BlockCipher)((SRTPPRF)sRTPParameters.getAlgorithm().basicVariation()).engineProvider.createEngine());
            byte[] byArray = new byte[sICBlockCipher.getBlockSize()];
            System.arraycopy(sRTPParameters.masterSalt, 0, byArray, 0, sRTPParameters.masterSalt.length);
            int n2 = sRTPParameters.masterSalt.length - (sRTPParameters.div.length + 1);
            byArray[n2] = (byte)(byArray[n2] ^ sRTPParameters.label);
            for (int i2 = 0; i2 != sRTPParameters.div.length; ++i2) {
                int n3 = i2 + (sRTPParameters.masterSalt.length - sRTPParameters.div.length);
                byArray[n3] = (byte)(byArray[n3] ^ sRTPParameters.div[i2]);
            }
            sICBlockCipher.init(true, new ParametersWithIV(new KeyParameterImpl(sRTPParameters.kMaster), byArray));
            return new MonitoringKDFCalculator<SRTPParameters>(this.approvedModeOnly, new BaseKDFCalculator<SRTPParameters>(){

                @Override
                public SRTPParameters getParameters() {
                    return sRTPParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    SRTPOperatorFactory.prf(sICBlockCipher, byArray, n2, n3);
                }
            });
        }

        private static void prf(StreamCipher streamCipher, byte[] byArray, int n2, int n3) {
            for (int i2 = n2; i2 != n2 + n3; ++i2) {
                byArray[i2] = 0;
            }
            streamCipher.processBytes(byArray, n2, n3, byArray, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SRTPPRF {
        AES_CM(FipsAES.CTR.getAlgorithm(), FipsAES.ENGINE_PROVIDER);

        private final FipsAlgorithm algorithm;
        private final EngineProvider<BlockCipher> engineProvider;

        private SRTPPRF(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
            this.algorithm = fipsAlgorithm;
            this.engineProvider = engineProvider;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class SRTPParameters
    extends FipsParameters {
        private final byte label;
        private final byte[] kMaster;
        private final byte[] masterSalt;
        private final int kdr;
        private final byte[] index;
        private final byte[] div;

        SRTPParameters(FipsAlgorithm fipsAlgorithm, byte by2, byte[] byArray, byte[] byArray2, int n2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.label = by2;
            this.kMaster = byArray;
            this.masterSalt = byArray2;
            this.kdr = n2;
            this.index = byArray3;
            this.div = new byte[byArray3.length];
            if (n2 != 0) {
                byte[] byArray4;
                if (byArray3.length <= 7) {
                    byte[] byArray5 = new byte[8];
                    System.arraycopy(byArray3, 0, byArray5, byArray5.length - byArray3.length, byArray3.length);
                    long l2 = Pack.bigEndianToLong(byArray5, 0) / (long)n2;
                    byArray4 = Pack.longToBigEndian(l2);
                } else {
                    BigInteger bigInteger = new BigInteger(1, byArray3).divide(BigInteger.valueOf(n2));
                    byArray4 = bigInteger.toByteArray();
                }
                if (byArray4.length < this.div.length) {
                    System.arraycopy(byArray4, 0, this.div, this.div.length - byArray4.length, byArray4.length);
                } else {
                    System.arraycopy(byArray4, byArray4.length - this.div.length, this.div, 0, this.div.length);
                }
            }
        }

        public SRTPParameters withLabel(byte by2) {
            return new SRTPParameters(this.getAlgorithm(), by2, this.kMaster, this.masterSalt, this.kdr, this.index);
        }
    }

    public static class SRTPParametersBuilder
    extends FipsParameters {
        private final SRTPPRF prf;

        SRTPParametersBuilder(FipsAlgorithm fipsAlgorithm, SRTPPRF sRTPPRF) {
            super(fipsAlgorithm);
            this.prf = sRTPPRF;
        }

        public SRTPParametersBuilder withPRF(SRTPPRF sRTPPRF) {
            return new SRTPParametersBuilder(this.getAlgorithm(), sRTPPRF);
        }

        public SRTPParameters using(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3) {
            return new SRTPParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), 0, Arrays.clone(byArray), Arrays.clone(byArray2), n2, Arrays.clone(byArray3));
        }

        public SRTPPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SSHOperatorFactory
    extends FipsKDFOperatorFactory<SSHParameters> {
        @Override
        public KDFCalculator<SSHParameters> createKDFCalculator(final SSHParameters sSHParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sSHParameters.getAlgorithm());
            final ExtendedDigest extendedDigest = FipsSHS.createDigest(((SSHPRF)sSHParameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<SSHParameters>(this.approvedModeOnly, new BaseKDFCalculator<SSHParameters>(){

                @Override
                public SSHParameters getParameters() {
                    return sSHParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    SSHOperatorFactory.hash(extendedDigest, sSHParameters, byArray, n2, n3);
                }
            });
        }

        private static void hash(Digest digest, SSHParameters sSHParameters, byte[] byArray, int n2, int n3) {
            int n4 = digest.getDigestSize();
            int n5 = (n3 + n4 - 1) / n4;
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
            digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
            digest.update((byte)sSHParameters.x);
            digest.update(sSHParameters.sessionID, 0, sSHParameters.sessionID.length);
            digest.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, Math.min(n4, n3));
            for (int i2 = 1; i2 < n5; ++i2) {
                digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
                digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
                digest.update(byArray, n2, n4 * i2);
                digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n2 + n4 * i2, Math.min(n4, byArray.length - n4 * i2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SSHPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512);

        private final FipsAlgorithm algorithm;

        private SSHPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class SSHParameters
    extends FipsParameters {
        private final char x;
        private final byte[] sharedKey;
        private final byte[] exchangeHash;
        private final byte[] sessionID;

        SSHParameters(FipsAlgorithm fipsAlgorithm, char c2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.x = c2;
            this.sharedKey = byArray;
            this.exchangeHash = byArray2;
            this.sessionID = byArray3;
        }

        SSHParameters(SSHParameters sSHParameters, SSHPRF sSHPRF) {
            this(new FipsAlgorithm(sSHParameters.getAlgorithm(), (Enum)sSHPRF), sSHParameters.x, sSHParameters.sharedKey, sSHParameters.exchangeHash, sSHParameters.sessionID);
        }

        public SSHParameters withX(char c2) {
            return new SSHParameters(this.getAlgorithm(), c2, this.sharedKey, this.exchangeHash, this.sessionID);
        }
    }

    public static final class SSHParametersBuilder
    extends FipsParameters {
        SSHPRF prf;

        SSHParametersBuilder(FipsAlgorithm fipsAlgorithm, SSHPRF sSHPRF) {
            super(fipsAlgorithm);
            this.prf = sSHPRF;
        }

        public SSHParametersBuilder withPRF(SSHPRF sSHPRF) {
            return new SSHParametersBuilder(this.getAlgorithm(), sSHPRF);
        }

        public SSHParameters using(char c2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new SSHParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), c2, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public SSHPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TLSOperatorFactory
    extends FipsKDFOperatorFactory<TLSParameters> {
        @Override
        public KDFCalculator<TLSParameters> createKDFCalculator(final TLSParameters tLSParameters) {
            final TLSPRF tLSPRF = (TLSPRF)tLSParameters.getAlgorithm().basicVariation();
            Utils.approvedModeCheck(this.approvedModeOnly, tLSParameters.getAlgorithm());
            if (tLSPRF == null) {
                final HMac hMac = new HMac((Digest)md5Provider.createEngine());
                final Mac mac = FipsSHS.createHMac(FipsSHS.Algorithm.SHA1_HMAC);
                return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                    @Override
                    public TLSParameters getParameters() {
                        return tLSParameters;
                    }

                    @Override
                    public void generateBytes(byte[] byArray, int n2, int n3) {
                        byte[] byArray2 = FipsKDF.PRF_legacy(tLSParameters, tLSParameters.secret, tLSParameters.label, n3, hMac, mac);
                        System.arraycopy(byArray2, 0, byArray, n2, n3);
                    }
                });
            }
            return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                @Override
                public TLSParameters getParameters() {
                    return tLSParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    byte[] byArray2 = FipsKDF.PRF(tLSParameters, tLSPRF, tLSParameters.secret, tLSParameters.label, n3);
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TLSPRF {
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private TLSPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class TLSParameters
    extends FipsParameters {
        private final byte[] secret;
        private final String label;
        private final byte[] seed;

        TLSParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, String string, byte[] byArray2) {
            super(fipsAlgorithm);
            this.secret = byArray;
            this.label = string;
            this.seed = byArray2;
        }
    }

    public static class TLSParametersBuilder
    extends FipsParameters {
        TLSParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(this.getAlgorithm(), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSParametersWithPRFBuilder
    extends TLSParametersBuilder {
        private final TLSPRF prf;

        TLSParametersWithPRFBuilder(FipsAlgorithm fipsAlgorithm, TLSPRF tLSPRF) {
            super(fipsAlgorithm);
            this.prf = tLSPRF;
        }

        public TLSParametersWithPRFBuilder withPRF(TLSPRF tLSPRF) {
            return new TLSParametersWithPRFBuilder(this.getAlgorithm(), tLSPRF);
        }

        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSStage {
        public static final String MASTER_SECRET = "master secret";
        public static final String KEY_EXPANSION = "key expansion";
        public static final String EXTENDED_MASTER_SECRET = "extended master secret";

        private TLSStage() {
        }
    }
}

