/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.utils.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410Key;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricGOST3410PublicKey
extends AsymmetricGOST3410Key<GOST3410DomainParameters>
implements AsymmetricPublicKey {
    private BigInteger y;

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters, BigInteger bigInteger) {
        super(algorithm, gOST3410Parameters);
        this.y = bigInteger;
    }

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_94, subjectPublicKeyInfo.getAlgorithm());
        this.y = AsymmetricGOST3410PublicKey.parsePublicKey(subjectPublicKeyInfo);
    }

    private static BigInteger parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray2[i2] = byArray[byArray.length - 1 - i2];
            }
            return new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in GOST3410 public key");
        }
    }

    public BigInteger getY() {
        return this.y;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.getY().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - 1 - i2];
        }
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray2));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94), new DEROctetString(byArray2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricGOST3410PublicKey)) {
            return false;
        }
        AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)object;
        return this.y.equals(asymmetricGOST3410PublicKey.getY()) && this.getParameters().equals(asymmetricGOST3410PublicKey.getParameters());
    }

    @Override
    public int hashCode() {
        int n2 = this.y.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }
}

