/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145BinaryField;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145ECBinary;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145Params;
import com.aspose.html.utils.ms.core.bc.asn1.ua.DSTU4145PointEncoder;
import com.aspose.html.utils.ms.core.bc.asn1.ua.UAObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSTU4145Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.utils.ms.core.bc.math.ec.ECCurve;
import java.math.BigInteger;

public abstract class AsymmetricDSTU4145Key
implements AsymmetricKey {
    private Algorithm algorithm;
    protected DSTU4145Parameters parameters;
    protected final AlgorithmIdentifier dstu4145Identifier;

    AsymmetricDSTU4145Key(Algorithm algorithm, DSTU4145Parameters dSTU4145Parameters) {
        this.algorithm = algorithm;
        this.parameters = dSTU4145Parameters;
        this.dstu4145Identifier = null;
    }

    AsymmetricDSTU4145Key(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.parameters = AsymmetricDSTU4145Key.decodeDomainParameters(algorithmIdentifier);
        this.dstu4145Identifier = algorithmIdentifier;
    }

    private static DSTU4145Parameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (!aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145be) && !aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le)) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        DSTU4145Params dSTU4145Params = DSTU4145Params.getInstance(algorithmIdentifier.getParameters());
        if (dSTU4145Params.isNamedCurve()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = dSTU4145Params.getNamedCurve();
            return new DSTU4145Parameters(aSN1ObjectIdentifier2, dSTU4145Params.getDKE());
        }
        DSTU4145ECBinary dSTU4145ECBinary = dSTU4145Params.getECBinary();
        byte[] byArray = dSTU4145ECBinary.getB();
        if (algorithmIdentifier.getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
            AsymmetricDSTU4145Key.reverseBytes(byArray);
        }
        DSTU4145BinaryField dSTU4145BinaryField = dSTU4145ECBinary.getField();
        BigInteger bigInteger = AsymmetricDSTU4145Key.deriveDSTUCofactor(dSTU4145BinaryField.getM(), dSTU4145ECBinary.getN());
        ECCurve.F2m f2m = new ECCurve.F2m(dSTU4145BinaryField.getM(), dSTU4145BinaryField.getK1(), dSTU4145BinaryField.getK2(), dSTU4145BinaryField.getK3(), dSTU4145ECBinary.getA(), new BigInteger(1, byArray), dSTU4145ECBinary.getN(), bigInteger);
        byte[] byArray2 = dSTU4145ECBinary.getG();
        if (algorithmIdentifier.getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
            AsymmetricDSTU4145Key.reverseBytes(byArray2);
        }
        return new DSTU4145Parameters(new ECDomainParameters(f2m, DSTU4145PointEncoder.decodePoint(f2m, byArray2), dSTU4145ECBinary.getN(), bigInteger));
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DSTU4145Parameters getParameters() {
        return this.parameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.parameters = null;
    }

    protected static void reverseBytes(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by2;
        }
    }

    private static BigInteger deriveDSTUCofactor(int n2, BigInteger bigInteger) {
        int n3 = bigInteger.bitLength();
        if (n3 > 1 && !bigInteger.testBit(n3 - 2)) {
            --n3;
        }
        return ECConstants.ONE.shiftLeft(Math.max(0, n2 - n3));
    }
}

