/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.DSAParameter;
import com.aspose.html.utils.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Permissions;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;

public final class AsymmetricDSAPrivateKey
extends AsymmetricDSAKey
implements AsymmetricPrivateKey,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricDSAPrivateKey(Algorithm algorithm, DSADomainParameters dSADomainParameters, BigInteger bigInteger) {
        super(algorithm, dSADomainParameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDSAPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public final DSADomainParameters getDomainParameters() {
        DSADomainParameters dSADomainParameters = super.getDomainParameters();
        KeyUtils.checkDestroyed(this);
        return dSADomainParameters;
    }

    public final byte[] getEncoded() {
        DSADomainParameters dSADomainParameters = this.getDomainParameters();
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG())), new ASN1Integer(this.getX()));
    }

    public final BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger bigInteger = this.x;
        KeyUtils.checkDestroyed(this);
        return bigInteger;
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.x.hashCode();
        n2 = 31 * n2 + this.getDomainParameters().hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDSAPrivateKey)) {
            return false;
        }
        AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)object;
        asymmetricDSAPrivateKey.checkApprovedOnlyModeStatus();
        return this.hashCode == asymmetricDSAPrivateKey.hashCode && KeyUtils.isFieldEqual(this.x, asymmetricDSAPrivateKey.x) && KeyUtils.isFieldEqual(this.domainParameters, asymmetricDSAPrivateKey.domainParameters);
    }
}

