/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.DSAParameter;
import com.aspose.html.utils.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import java.util.HashSet;
import java.util.Set;

public abstract class AsymmetricDSAKey
implements AsymmetricKey {
    private static final Set<ASN1ObjectIdentifier> dsaOids = new HashSet<ASN1ObjectIdentifier>(3);
    protected final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    protected Algorithm algorithm;
    protected DSADomainParameters domainParameters;

    AsymmetricDSAKey(Algorithm algorithm, DSADomainParameters dSADomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = dSADomainParameters;
    }

    AsymmetricDSAKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDSAKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DSADomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (!dsaOids.contains(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            DSAParameter dSAParameter = DSAParameter.getInstance(algorithmIdentifier.getParameters());
            return new DSADomainParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
        }
        return null;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DSADomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }

    static {
        dsaOids.add(X9ObjectIdentifiers.id_dsa);
        dsaOids.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        dsaOids.add(OIWObjectIdentifiers.dsaWithSHA1);
    }
}

