/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.adw;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSACryptoServiceProvider;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSASignatureDeformatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.MD5;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSAPKCS1SignatureDeformatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA256;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA384;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA512;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.MD4;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509ExtensionCollection;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.a;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.p;
import com.aspose.html.utils.ms.lang.StringSwitchMap;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.RSAPublicKey;

public class X509Certificate {
    private ASN1 a;
    private byte[] b;
    private adw c = new adw();
    private adw d = new adw();
    private ASN1 e;
    private String f;
    private String g;
    private byte[] h;
    private ASN1 i;
    private String j;
    private byte[] k;
    private byte[] l;
    private String m;
    private byte[] n;
    private byte[] o;
    private RSA p;
    private DSA q;
    private int r;
    private byte[] s;
    private byte[] t;
    private byte[] u;
    private X509ExtensionCollection v;
    private static String w = StringExtensions.format("Input data cannot be coded as a valid certificate.", new Object[0]);
    private static final StringSwitchMap x = new StringSwitchMap("1.2.840.113549.1.1.2", "1.2.840.113549.1.1.3", "1.2.840.113549.1.1.4", "1.2.840.113549.1.1.5", "1.3.14.3.2.29", "1.2.840.10040.4.3", "1.2.840.113549.1.1.11", "1.2.840.113549.1.1.12", "1.2.840.113549.1.1.13");

    private void a(byte[] byArray) {
        try {
            ASN1 aSN1;
            ASN1 aSN12;
            ASN1 aSN13;
            this.a = new ASN1(byArray);
            if (this.a.getTag() != 48) {
                throw new CryptographicException(w);
            }
            ASN1 aSN14 = null;
            aSN14 = this.a.get_Item(0).getTag() != 48 ? this.a : this.a.get_Item(0);
            int n2 = 0;
            ASN1 aSN15 = aSN14.get_Item(n2);
            this.r = 1;
            if ((aSN15.getTag() & 0xFF) == 160 && aSN15.getCount() > 0) {
                this.r += aSN15.get_Item(0).getValue()[0];
            }
            int n3 = ++n2;
            ++n2;
            ASN1 aSN16 = aSN14.get_Item(n3);
            if (aSN16.getTag() != 2) {
                throw new CryptographicException(w);
            }
            this.s = aSN16.getValue();
            msArray.reverse(this.s, 0, this.s.length);
            int n4 = ++n2;
            this.e = aSN14.element(n4, (byte)48);
            this.f = com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h.a(this.e);
            int n5 = ++n2;
            ASN1 aSN17 = aSN14.element(n5, (byte)48);
            ASN1 aSN18 = aSN17.get_Item(0);
            this.c = ASN1Convert.toDateTime(aSN18);
            ASN1 aSN19 = aSN17.get_Item(1);
            this.d = ASN1Convert.toDateTime(aSN19);
            int n6 = ++n2;
            this.i = aSN14.element(n6, (byte)48);
            this.j = com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h.a(this.i);
            int n7 = ++n2;
            ++n2;
            ASN1 aSN110 = aSN14.element(n7, (byte)48);
            ASN1 aSN111 = aSN110.element(0, (byte)48);
            ASN1 aSN112 = aSN111.element(0, (byte)6);
            this.g = ASN1Convert.toOid(aSN112);
            ASN1 aSN113 = aSN111.get_Item(1);
            this.h = aSN111.getCount() > 1 ? aSN113.getBytes() : null;
            ASN1 aSN114 = aSN110.element(1, (byte)3);
            int n8 = aSN114.getLength() - 1;
            this.k = new byte[n8];
            Buffer.blockCopy(Array.boxing(aSN114.getValue()), 1, Array.boxing(this.k), 0, n8);
            byte[] byArray2 = this.a.get_Item(2).getValue();
            this.l = new byte[byArray2.length - 1];
            Buffer.blockCopy(Array.boxing(byArray2), 1, Array.boxing(this.l), 0, this.l.length);
            if (this.a.get_Item(0).getTag() == 48) {
                aSN111 = this.a.get_Item(1);
                aSN112 = aSN111.element(0, (byte)6);
                this.m = ASN1Convert.toOid(aSN112);
                aSN113 = aSN111.get_Item(1);
                this.n = (byte[])(aSN113 != null ? aSN113.getBytes() : null);
            }
            if ((aSN13 = aSN14.element(n2, (byte)-127)) != null) {
                ++n2;
                this.t = aSN13.getValue();
            }
            if ((aSN12 = aSN14.element(n2, (byte)-126)) != null) {
                ++n2;
                this.u = aSN12.getValue();
            }
            this.v = (aSN1 = aSN14.element(n2, (byte)-93)) != null && aSN1.getCount() == 1 ? new X509ExtensionCollection(aSN1.get_Item(0)) : new X509ExtensionCollection(null);
            this.b = (byte[])byArray.clone();
        }
        catch (Exception exception) {
            throw new CryptographicException(w, exception);
        }
    }

    public X509Certificate(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length > 0 && byArray[0] != 48) {
                try {
                    byArray = X509Certificate.a("CERTIFICATE", byArray);
                }
                catch (Exception exception) {
                    throw new CryptographicException(w, exception);
                }
            }
            this.a(byArray);
        }
    }

    private X509Certificate() {
    }

    private byte[] b(byte[] byArray) {
        if (byArray[0] == 0) {
            int n2 = byArray.length - 1;
            byte[] byArray2 = new byte[n2];
            Buffer.blockCopy(Array.boxing(byArray), 1, Array.boxing(byArray2), 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public DSA getDSA() {
        if (this.h == null) {
            throw new CryptographicException("Missing key algorithm parameters.");
        }
        if (this.q == null) {
            DSAParameters dSAParameters = new DSAParameters();
            ASN1 aSN1 = new ASN1(this.k);
            if (aSN1 == null || aSN1.getTag() != 2) {
                return null;
            }
            dSAParameters.Y = this.b(aSN1.getValue());
            ASN1 aSN12 = new ASN1(this.h);
            if (aSN12 == null || aSN12.getTag() != 48 || aSN12.getCount() < 3) {
                return null;
            }
            if (aSN12.get_Item(0).getTag() != 2 || aSN12.get_Item(1).getTag() != 2 || aSN12.get_Item(2).getTag() != 2) {
                return null;
            }
            dSAParameters.P = this.b(aSN12.get_Item(0).getValue());
            dSAParameters.Q = this.b(aSN12.get_Item(1).getValue());
            dSAParameters.G = this.b(aSN12.get_Item(2).getValue());
            this.q = new DSACryptoServiceProvider(dSAParameters.Y.length << 3);
            this.q.importParameters(dSAParameters.Clone());
        }
        return this.q;
    }

    public void setDSA(DSA dSA) {
        this.q = dSA;
        if (dSA != null) {
            this.p = null;
        }
    }

    public X509ExtensionCollection getExtensions() {
        return this.v;
    }

    public byte[] getHash() {
        if (this.o == null) {
            HashAlgorithm hashAlgorithm = null;
            switch (x.of(this.m)) {
                case 0: {
                    hashAlgorithm = com.aspose.html.utils.ms.core.System.Security.Cryptography.p.a();
                    break;
                }
                case 1: {
                    hashAlgorithm = MD4.create();
                    break;
                }
                case 2: {
                    hashAlgorithm = MD5.create();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    hashAlgorithm = SHA1.create();
                    break;
                }
                case 6: {
                    hashAlgorithm = SHA256.create();
                    break;
                }
                case 7: {
                    hashAlgorithm = SHA384.create();
                    break;
                }
                case 8: {
                    hashAlgorithm = SHA512.create();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (this.a == null || this.a.getCount() < 1) {
                return null;
            }
            byte[] byArray = this.a.get_Item(0).getBytes();
            this.o = hashAlgorithm.computeHash(byArray, 0, byArray.length);
        }
        return (byte[])this.o.clone();
    }

    public String get_IssuerName() {
        return this.f;
    }

    public String getKeyAlgorithm() {
        return this.g;
    }

    public byte[] getKeyAlgorithmParameters() {
        if (this.h == null) {
            return null;
        }
        return (byte[])this.h.clone();
    }

    public void setKeyAlgorithmParameters(byte[] byArray) {
        this.h = byArray;
    }

    public byte[] getPublicKey() {
        if (this.k == null) {
            return null;
        }
        return (byte[])this.k.clone();
    }

    public RSA getRSA() {
        if (this.p == null) {
            RSAParameters rSAParameters = new RSAParameters();
            ASN1 aSN1 = new ASN1(this.k);
            ASN1 aSN12 = aSN1.get_Item(0);
            if (aSN12 == null || aSN12.getTag() != 2) {
                return null;
            }
            ASN1 aSN13 = aSN1.get_Item(1);
            if (aSN13.getTag() != 2) {
                return null;
            }
            rSAParameters.Modulus = this.b(aSN12.getValue());
            rSAParameters.Exponent = aSN13.getValue();
            int n2 = rSAParameters.Modulus.length << 3;
            this.p = new RSACryptoServiceProvider(n2);
            this.p.importParameters(rSAParameters.Clone());
        }
        return this.p;
    }

    public void setRSA(RSA rSA) {
        if (rSA != null) {
            this.q = null;
        }
        this.p = rSA;
    }

    public byte[] getRawData() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public byte[] getSerialNumber() {
        if (this.s == null) {
            return null;
        }
        return (byte[])this.s.clone();
    }

    public byte[] getSignature() {
        if (this.l == null) {
            return null;
        }
        switch (x.of(this.m)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return (byte[])this.l.clone();
            }
            case 5: {
                ASN1 aSN1 = new ASN1(this.l);
                if (aSN1 == null || aSN1.getCount() != 2) {
                    return null;
                }
                byte[] byArray = aSN1.get_Item(0).getValue();
                byte[] byArray2 = aSN1.get_Item(1).getValue();
                byte[] byArray3 = new byte[40];
                int n2 = msMath.max(0, byArray.length - 20);
                int n3 = msMath.max(0, 20 - byArray.length);
                Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(byArray3), n3, byArray.length - n2);
                int n4 = msMath.max(0, byArray2.length - 20);
                int n5 = msMath.max(20, 40 - byArray2.length);
                Buffer.blockCopy(Array.boxing(byArray2), n4, Array.boxing(byArray3), n5, byArray2.length - n4);
                return byArray3;
            }
        }
        throw new CryptographicException(StringExtensions.concat("Unsupported hash algorithm: ", this.m));
    }

    public String getSignatureAlgorithm() {
        return this.m;
    }

    public byte[] getSignatureAlgorithmParameters() {
        if (this.n == null) {
            return this.n;
        }
        return (byte[])this.n.clone();
    }

    public String get_SubjectName() {
        return this.j;
    }

    public adw getValidFrom() {
        return this.c;
    }

    public adw getValidUntil() {
        return this.d;
    }

    public int getVersion() {
        return this.r;
    }

    public boolean isCurrent() {
        return this.wasCurrent(adw.asq().asI());
    }

    public boolean wasCurrent(adw adw2) {
        return adw.a(adw2, this.getValidFrom()) && adw.d(adw2, this.getValidUntil());
    }

    public byte[] getIssuerUniqueIdentifier() {
        if (this.t == null) {
            return null;
        }
        return (byte[])this.t.clone();
    }

    public byte[] getSubjectUniqueIdentifier() {
        if (this.u == null) {
            return null;
        }
        return (byte[])this.u.clone();
    }

    boolean a(DSA dSA) {
        DSASignatureDeformatter dSASignatureDeformatter = new DSASignatureDeformatter(dSA);
        dSASignatureDeformatter.setHashAlgorithm("SHA1");
        return dSASignatureDeformatter.verifySignature(this.getHash(), this.getSignature());
    }

    boolean a(RSA rSA) {
        RSAPKCS1SignatureDeformatter rSAPKCS1SignatureDeformatter = new RSAPKCS1SignatureDeformatter(rSA);
        switch (x.of(this.m)) {
            case 0: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("MD2");
                break;
            }
            case 1: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("MD4");
                break;
            }
            case 2: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("MD5");
                break;
            }
            case 3: 
            case 4: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("SHA1");
                break;
            }
            case 6: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("SHA256");
                break;
            }
            case 7: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("SHA384");
                break;
            }
            case 8: {
                rSAPKCS1SignatureDeformatter.setHashAlgorithm("SHA512");
                break;
            }
            case 5: {
                return false;
            }
            default: {
                throw new CryptographicException(StringExtensions.concat("Unsupported hash algorithm: ", this.m));
            }
        }
        return rSAPKCS1SignatureDeformatter.verifySignature(this.getHash(), this.getSignature());
    }

    public boolean verifySignature(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (asymmetricAlgorithm == null) {
            throw new ArgumentNullException("aa");
        }
        if (asymmetricAlgorithm instanceof RSA) {
            return this.a((RSA)asymmetricAlgorithm);
        }
        if (asymmetricAlgorithm instanceof DSA) {
            return this.a((DSA)asymmetricAlgorithm);
        }
        throw new NotSupportedException(StringExtensions.concat("Unknown Asymmetric Algorithm ", asymmetricAlgorithm.toString()));
    }

    public boolean checkSignature(byte[] byArray, String string, byte[] byArray2) {
        RSACryptoServiceProvider rSACryptoServiceProvider = (RSACryptoServiceProvider)this.getRSA();
        return rSACryptoServiceProvider.verifyHash(byArray, string, byArray2);
    }

    public boolean isSelfSigned() {
        if (!StringExtensions.equals(this.f, this.j)) {
            return false;
        }
        try {
            if (this.getRSA() != null) {
                return this.a(this.getRSA());
            }
            if (this.getDSA() != null) {
                return this.a(this.getDSA());
            }
            return false;
        }
        catch (CryptographicException cryptographicException) {
            return false;
        }
    }

    public ASN1 getIssuerName() {
        return this.e;
    }

    public ASN1 getSubjectName() {
        return this.i;
    }

    static byte[] a(String string, byte[] byArray) {
        String string2 = Encoding.getASCII().getString(byArray);
        String string3 = StringExtensions.format("-----BEGIN {0}-----", string);
        String string4 = StringExtensions.format("-----END {0}-----", string);
        int n2 = StringExtensions.indexOf(string2, string3) + string3.length();
        int n3 = StringExtensions.indexOf(string2, string4, n2);
        String string5 = StringExtensions.substring(string2, n2, n3 - n2);
        return Convert.fromBase64String(string5);
    }

    public static X509Certificate fromJava(java.security.cert.X509Certificate x509Certificate, PrivateKey privateKey) {
        X509Certificate x509Certificate2 = null;
        try {
            x509Certificate2 = new X509Certificate(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException(certificateEncodingException);
        }
        x509Certificate2.s = x509Certificate.getSerialNumber().toByteArray();
        if (privateKey != null) {
            if ("RSA".equals(privateKey.getAlgorithm())) {
                RSACryptoServiceProvider rSACryptoServiceProvider = new RSACryptoServiceProvider();
                RSAParameters rSAParameters = new RSAParameters();
                RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
                rSAParameters.Exponent = com.aspose.html.utils.ms.core.System.Security.Cryptography.a.a(rSAPublicKey.getPublicExponent());
                rSAParameters.Modulus = com.aspose.html.utils.ms.core.System.Security.Cryptography.a.a(rSAPublicKey.getModulus());
                rSACryptoServiceProvider.importParameters(rSAParameters);
                rSACryptoServiceProvider.setJavaPrivateKey(privateKey);
                x509Certificate2.setRSA(rSACryptoServiceProvider);
            } else {
                throw new NotImplementedException("Not implement for " + privateKey.getAlgorithm());
            }
        }
        return x509Certificate2;
    }
}

