/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTextVar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngChunkITXT
extends PngChunkTextVar {
    public static final String ID = "iTXt";
    private boolean a = false;
    private int b;
    private String c = "";
    private String d = "";

    public PngChunkITXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(ChunkHelper.toBytes(this.key));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.a ? 1 : 0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(ChunkHelper.toBytes(this.c));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(ChunkHelper.toBytesUTF8(this.d));
            byteArrayOutputStream.write(0);
            byte[] byArray = ChunkHelper.toBytesUTF8(this.val);
            if (this.a) {
                byArray = ChunkHelper.compressBytes(byArray, true);
            }
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = 0;
        int[] nArray = new int[3];
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            nArray[n3] = n2;
            if (++n3 == 1) {
                n2 += 2;
            }
            if (n3 == 3) break;
        }
        if (n3 != 3) {
            throw new PngjException("Bad formed PngChunkITXT chunk");
        }
        this.key = ChunkHelper.toString(chunkRaw.data, 0, nArray[0]);
        n2 = nArray[0] + 1;
        this.a = chunkRaw.data[n2] != 0;
        this.b = chunkRaw.data[++n2];
        if (this.a && this.b != 0) {
            throw new PngjException("Bad formed PngChunkITXT chunk - bad compression method ");
        }
        this.c = PngHelperInternal.Latin1.getString(chunkRaw.data, n2, nArray[1] - n2);
        this.d = PngHelperInternal.UTF8.getString(chunkRaw.data, nArray[1] + 1, nArray[2] - nArray[1] - 1);
        n2 = nArray[2] + 1;
        if (this.a) {
            byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n2, chunkRaw.data.length - n2, false);
            this.val = ChunkHelper.toStringUTF8(byArray);
        } else {
            this.val = ChunkHelper.toStringUTF8(chunkRaw.data, n2, chunkRaw.data.length - n2);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkITXT pngChunkITXT = (PngChunkITXT)pngChunk;
        this.key = pngChunkITXT.key;
        this.val = pngChunkITXT.val;
        this.a = pngChunkITXT.a;
        this.c = pngChunkITXT.c;
        this.d = pngChunkITXT.d;
    }

    public boolean isCompressed() {
        return this.a;
    }

    public void setCompressed(boolean bl2) {
        this.a = bl2;
    }

    public int getCompressionMethod() {
        return this.b;
    }

    public String getLangtag() {
        return this.c;
    }

    public void setLangtag(String string) {
        this.c = string;
    }

    public String getTranslatedTag() {
        return this.d;
    }

    public void setTranslatedTag(String string) {
        this.d = string;
    }
}

