/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;

    public PngChunkIHDR(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int n2 = 0;
        PngHelperInternal.writeInt4tobytes(this.a, chunkRaw.data, n2);
        PngHelperInternal.writeInt4tobytes(this.b, chunkRaw.data, n2 += 4);
        n2 += 4;
        chunkRaw.data[n2++] = (byte)this.c;
        chunkRaw.data[n2++] = (byte)this.d;
        chunkRaw.data[n2++] = (byte)this.e;
        chunkRaw.data[n2++] = (byte)this.f;
        chunkRaw.data[n2++] = (byte)this.g;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 13) {
            throw new PngjException("Bad IDHR len " + chunkRaw.len);
        }
        ByteArrayInputStream byteArrayInputStream = chunkRaw.getAsByteStream();
        this.a = PngHelperInternal.readInt4(byteArrayInputStream);
        this.b = PngHelperInternal.readInt4(byteArrayInputStream);
        this.c = PngHelperInternal.readByte(byteArrayInputStream);
        this.d = PngHelperInternal.readByte(byteArrayInputStream);
        this.e = PngHelperInternal.readByte(byteArrayInputStream);
        this.f = PngHelperInternal.readByte(byteArrayInputStream);
        this.g = PngHelperInternal.readByte(byteArrayInputStream);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)pngChunk;
        this.a = pngChunkIHDR.a;
        this.b = pngChunkIHDR.b;
        this.c = pngChunkIHDR.c;
        this.d = pngChunkIHDR.d;
        this.e = pngChunkIHDR.e;
        this.f = pngChunkIHDR.f;
        this.g = pngChunkIHDR.g;
    }

    public int getCols() {
        return this.a;
    }

    public void setCols(int n2) {
        this.a = n2;
    }

    public int getRows() {
        return this.b;
    }

    public void setRows(int n2) {
        this.b = n2;
    }

    public int getBitspc() {
        return this.c;
    }

    public void setBitspc(int n2) {
        this.c = n2;
    }

    public int getColormodel() {
        return this.d;
    }

    public void setColormodel(int n2) {
        this.d = n2;
    }

    public int getCompmeth() {
        return this.e;
    }

    public void setCompmeth(int n2) {
        this.e = n2;
    }

    public int getFilmeth() {
        return this.f;
    }

    public void setFilmeth(int n2) {
        this.f = n2;
    }

    public int getInterlaced() {
        return this.g;
    }

    public void setInterlaced(int n2) {
        this.g = n2;
    }
}

