/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDecoderState;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegMCU;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.HuffmanBitParseState;

public abstract class JpegEntropyDecoder {
    private static final int[] a = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767};
    private static final int[] b = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    protected static final int BitBufferSize = 32;
    protected static final int MinGetBits = 25;
    protected final JpegRawDataReader RawDataReader;
    protected final int[] lastDC;
    protected JpegDecoderState decoderState;

    protected JpegEntropyDecoder(JpegDecoderState jpegDecoderState) {
        this.decoderState = jpegDecoderState;
        this.RawDataReader = jpegDecoderState.getRawDataReader();
        this.lastDC = new int[JpegConstants.MaxComponents];
    }

    public JpegDecoderState getDecoderState() {
        return this.decoderState;
    }

    public boolean decode(EntropyTable entropyTable, int[] nArray, HuffmanBitParseState[] huffmanBitParseStateArray) {
        int n2 = 0;
        boolean bl2 = false;
        if (huffmanBitParseStateArray[0].BitsLeft < JpegConstants.HuffLookahead) {
            if (!this.jpegFillBitBuffer(huffmanBitParseStateArray, 0)) {
                nArray[0] = -1;
                return false;
            }
            if (huffmanBitParseStateArray[0].BitsLeft < JpegConstants.HuffLookahead) {
                n2 = 1;
                bl2 = true;
            }
        }
        if (!bl2) {
            int n3 = JpegEntropyDecoder.peekBits(JpegConstants.HuffLookahead, huffmanBitParseStateArray[0].Clone());
            n2 = entropyTable.getLookNbits()[n3];
            if (n2 != 0) {
                int[] nArray2 = new int[]{huffmanBitParseStateArray[0].BitsLeft};
                JpegEntropyDecoder.dropBits(n2, nArray2);
                huffmanBitParseStateArray[0].BitsLeft = nArray2[0];
                nArray[0] = entropyTable.getLookSym()[n3];
                return true;
            }
            n2 = JpegConstants.HuffLookahead + 1;
        }
        nArray[0] = this.jpegHuffDecode(huffmanBitParseStateArray, entropyTable, n2);
        return nArray[0] >= 0;
    }

    protected int jpegHuffDecode(HuffmanBitParseState[] huffmanBitParseStateArray, EntropyTable entropyTable, int n2) {
        int n3 = n2;
        if (!this.checkBitBuffer(n3, huffmanBitParseStateArray)) {
            return -1;
        }
        int n4 = JpegEntropyDecoder.getBits(n3, huffmanBitParseStateArray);
        while (n4 > entropyTable.getMaxCode()[n3]) {
            n4 <<= 1;
            if (!this.checkBitBuffer(1, huffmanBitParseStateArray)) {
                return -1;
            }
            n4 |= JpegEntropyDecoder.getBits(1, huffmanBitParseStateArray);
            ++n3;
        }
        if (n3 > 16) {
            return 0;
        }
        return entropyTable.getHuffVal()[n4 + entropyTable.getValPtr()[n3]] & 0xFF;
    }

    public abstract boolean decodeMCU(JpegMCU var1);

    public abstract void initializeScan();

    protected static int huffDecode(EntropyTable entropyTable) {
        throw new NotImplementedException();
    }

    protected boolean jpegFillBitBuffer(HuffmanBitParseState[] huffmanBitParseStateArray, int n2) {
        boolean bl2 = false;
        if (this.RawDataReader.getMetMarker() == 0) {
            while (huffmanBitParseStateArray[0].BitsLeft < 25) {
                int n3 = 0;
                int[] nArray = new int[]{0};
                this.RawDataReader.getByte(nArray);
                n3 = nArray[0];
                if (n3 == 255) {
                    do {
                        nArray[0] = n3;
                        this.RawDataReader.getByte(nArray);
                    } while ((n3 = nArray[0]) == 255);
                    if (n3 == 0) {
                        n3 = 255;
                    } else {
                        this.RawDataReader.setMetMarker(n3);
                        bl2 = true;
                        break;
                    }
                }
                huffmanBitParseStateArray[0].GetBuffer = huffmanBitParseStateArray[0].GetBuffer << 8 | n3;
                huffmanBitParseStateArray[0].BitsLeft += 8;
            }
        }
        if (bl2 && n2 > huffmanBitParseStateArray[0].BitsLeft) {
            huffmanBitParseStateArray[0].GetBuffer <<= 25 - huffmanBitParseStateArray[0].BitsLeft;
            huffmanBitParseStateArray[0].BitsLeft = 25;
        }
        return true;
    }

    protected static int huffExtend(int n2, int n3) {
        return n2 < b[n3] ? n2 + a[n3] : n2;
    }

    protected boolean checkBitBuffer(int n2, HuffmanBitParseState[] huffmanBitParseStateArray) {
        return huffmanBitParseStateArray[0].BitsLeft >= n2 || this.jpegFillBitBuffer(huffmanBitParseStateArray, n2);
    }

    protected static int getBits(int n2, HuffmanBitParseState[] huffmanBitParseStateArray) {
        huffmanBitParseStateArray[0].BitsLeft -= n2;
        return huffmanBitParseStateArray[0].GetBuffer >> huffmanBitParseStateArray[0].BitsLeft & (1 << n2) - 1;
    }

    protected static int peekBits(int n2, HuffmanBitParseState huffmanBitParseState) {
        return huffmanBitParseState.GetBuffer >> huffmanBitParseState.BitsLeft - n2 & (1 << n2) - 1;
    }

    protected static void dropBits(int n2, int[] nArray) {
        nArray[0] = nArray[0] - n2;
    }
}

