/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.CachedIccCmm;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccCmm;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccInvalidProfileException;

public class IccColorConverter
extends ColorConverter {
    protected IccCmm converter;
    private Dictionary<IccConvertItem, double[]> a = new Dictionary();

    public IccColorConverter(int n2, int n3, int n4, PixelDataFormat pixelDataFormat, Rectangle rectangle, PixelDataFormat pixelDataFormat2, int n5, StreamContainer streamContainer, StreamContainer streamContainer2) {
        super(n2, n3, n4, pixelDataFormat, rectangle.Clone(), pixelDataFormat2, n5);
        this.converter = new CachedIccCmm();
        try {
            this.converter.addXform(streamContainer.getStream());
        }
        catch (IccInvalidProfileException iccInvalidProfileException) {
            this.converter.addXform(IccProfileHelper.getDefaultCmykProfile().getStream());
        }
        try {
            this.converter.addXform(streamContainer2.getStream());
        }
        catch (IccInvalidProfileException iccInvalidProfileException) {
            this.converter.addXform(IccProfileHelper.getDefaultRGBProfile().getStream());
        }
    }

    @Override
    protected void convert(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8 = this.SourceFormat.getChannelsCount();
        int n9 = this.DestinationFormat.getChannelsCount();
        for (int i2 = 0; i2 < n5; ++i2) {
            int n10 = n2 + this.LineSize * i2;
            int n11 = i2 * n7 + n6;
            double[] dArray = new double[n8];
            double[] dArray2 = new double[n9];
            int n12 = n10;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n13;
                for (n13 = 0; n13 < n8; ++n13) {
                    dArray[n13] = (double)(byArray[n12++] & 0xFF) / 255.0;
                }
                this.converter.apply(dArray, dArray2);
                for (n13 = 0; n13 < n9; ++n13) {
                    byArray2[n11++] = (byte)(dArray2[n13] * 255.0);
                }
            }
        }
    }

    private void a(double[] dArray, double[] dArray2) {
        IccConvertItem iccConvertItem = new IccConvertItem(dArray);
        double[] dArray3 = null;
        double[][] dArrayArray = new double[][]{dArray3};
        boolean bl2 = this.a.tryGetValue(iccConvertItem, (Object[])dArrayArray);
        dArray3 = dArrayArray[0];
        if (bl2) {
            System.arraycopy(dArray3, 0, dArray2, 0, dArray3.length);
        } else {
            this.converter.apply(dArray, dArray2);
            this.a.set_Item(iccConvertItem, ArrayHelper.copyDouble(dArray2));
        }
    }

    static class IccConvertItem {
        private double[] a;

        public IccConvertItem(double[] dArray) {
            this.a = ArrayHelper.copyDouble(dArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || ObjectExtensions.getType(this) != ObjectExtensions.getType(object)) {
                return false;
            }
            IccConvertItem iccConvertItem = (IccConvertItem)object;
            return IccConvertItem.equalsArr(this.a, iccConvertItem.a);
        }

        public int hashCode() {
            return IccConvertItem.hashCode(this.a);
        }

        public static int hashCode(double[] dArray) {
            if (dArray == null) {
                return 0;
            }
            int n2 = 1;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d2 = dArray[i2];
                long l2 = BitConverter.doubleToInt64Bits(d2);
                n2 = 31 * n2 + (int)(l2 ^ l2 >> 32);
            }
            return n2;
        }

        public static boolean equalsArr(double[] dArray, double[] dArray2) {
            if (dArray == dArray2) {
                return true;
            }
            if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (BitConverter.doubleToInt64Bits(dArray[i2]) == BitConverter.doubleToInt64Bits(dArray2[i2])) continue;
                return false;
            }
            return true;
        }
    }
}

