/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.Drawing2D;

import com.aspose.html.utils.ms.System.Drawing.PointF;
import java.util.ArrayList;
import java.util.LinkedList;

public class Primitive2D {
    public static PointF endOfLine(PointF pointF, double d2, double d3) {
        if (d2 == 0.0) {
            return new PointF((float)((double)pointF.getX() + d3), pointF.getY());
        }
        if (d2 == Math.PI) {
            return new PointF((float)((double)pointF.getX() - d3), pointF.getY());
        }
        if (d2 == 1.5707963267948966) {
            return new PointF(pointF.getX(), (float)((double)pointF.getY() + d3));
        }
        if (d2 == -1.5707963267948966) {
            return new PointF(pointF.getX(), (float)((double)pointF.getY() - d3));
        }
        float f2 = (float)(d3 * Math.cos(d2));
        float f3 = (float)(d3 * Math.sin(d2));
        return new PointF(pointF.getX() + f2, pointF.getY() + f3);
    }

    public static boolean belongToLine(PointF pointF, PointF pointF2, PointF pointF3) {
        return Primitive2D.belongToLine(pointF, pointF2, pointF3, 1.0E-4f);
    }

    public static boolean belongToLine(PointF pointF, PointF pointF2, PointF pointF3, float f2) {
        double d2 = Primitive2D.a(pointF, pointF2);
        double d3 = Primitive2D.a(pointF, pointF3);
        double d4 = Primitive2D.a(pointF2, pointF3);
        if (Primitive2D.linelen(pointF, pointF2) < f2) {
            return true;
        }
        if (Primitive2D.linelen(pointF, pointF3) < f2) {
            return true;
        }
        if (Primitive2D.linelen(pointF2, pointF3) < f2) {
            return true;
        }
        float f3 = 1.0E-4f;
        return Math.abs(d2 - d3) < (double)f3 || Math.abs(d2 - d4) < (double)f3 || Math.abs(d3 - d4) < (double)f3;
    }

    public static boolean belongToSection(PointF pointF, PointF pointF2, PointF pointF3) {
        return Primitive2D.belongToSection(pointF, pointF2, pointF3, 1.0E-4f);
    }

    public static boolean belongToSection(PointF pointF, PointF pointF2, PointF pointF3, float f2) {
        double d2;
        double d3 = Primitive2D.linelen(pointF, pointF2);
        double d4 = Primitive2D.linelen(pointF, pointF3);
        return Math.abs(d4 + (d2 = (double)Primitive2D.linelen(pointF2, pointF3)) - d3) < (double)f2;
    }

    public static PointF[] arrangePointsByLeft(PointF pointF, PointF pointF2) {
        if (pointF.getX() < pointF2.getX()) {
            return new PointF[]{pointF, pointF2};
        }
        if (pointF.getX() > pointF2.getX()) {
            return new PointF[]{pointF2, pointF};
        }
        if (pointF.getY() > pointF2.getY()) {
            return new PointF[]{pointF2, pointF};
        }
        return new PointF[]{pointF, pointF2};
    }

    public static PointF[] arrangePointsByTop(PointF pointF, PointF pointF2) {
        if (pointF.getY() < pointF2.getY()) {
            return new PointF[]{pointF, pointF2};
        }
        if (pointF.getY() > pointF2.getY()) {
            return new PointF[]{pointF2, pointF};
        }
        if (pointF.getX() < pointF2.getX()) {
            return new PointF[]{pointF2, pointF};
        }
        return new PointF[]{pointF, pointF2};
    }

    public static float linelen(float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        return (float)Math.sqrt(f6 * f6 + f7 * f7);
    }

    public static float linelen(PointF pointF, PointF pointF2) {
        return Primitive2D.linelen(pointF.getX(), pointF.getY(), pointF2.getX(), pointF2.getY());
    }

    public static float polyLineLength(float[] fArray, int n2, int n3) {
        assert (n3 % 2 == 0 && fArray.length >= n2 + n3) : "";
        float f2 = 0.0f;
        for (int i2 = n2 + 2; i2 < n2 + n3; i2 += 2) {
            f2 += Primitive2D.linelen(fArray[i2], fArray[i2 + 1], fArray[i2 - 2], fArray[i2 - 1]);
        }
        return f2;
    }

    public static float polyLineLength(PointF[] pointFArray, int n2, int n3) {
        float[] fArray = new float[pointFArray.length * 2];
        for (int i2 = 0; i2 < pointFArray.length; ++i2) {
            fArray[i2 * 2] = pointFArray[i2].getX();
            fArray[i2 * 2 + 1] = pointFArray[i2].getY();
        }
        return Primitive2D.polyLineLength(fArray, n2 * 2, n3 * 2);
    }

    public static double lineAngle(PointF pointF, PointF pointF2) {
        float f2 = pointF.getX();
        float f3 = pointF.getY();
        float f4 = pointF2.getX();
        float f5 = pointF2.getY();
        double d2 = f4 - f2;
        double d3 = f5 - f3;
        if (d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d2 == 0.0 && d3 != 0.0) {
            return f3 > f5 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d2 != 0.0 && d3 == 0.0) {
            return f2 > f4 ? Math.PI : 0.0;
        }
        double d4 = Math.atan(d3 / d2);
        if (d2 < 0.0 && d3 < 0.0) {
            d4 -= Math.PI;
        }
        if (d2 < 0.0 && d3 >= 0.0) {
            d4 += Math.PI;
        }
        return d4;
    }

    private static double a(PointF pointF, PointF pointF2) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(pointF, pointF2);
        float f2 = pointFArray[0].getX();
        float f3 = pointFArray[0].getY();
        float f4 = pointFArray[1].getX();
        float f5 = pointFArray[1].getY();
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        if ((double)f6 == 0.0 && (double)f7 == 0.0) {
            return 0.0;
        }
        if ((double)f6 == 0.0 && (double)f7 != 0.0) {
            return f3 > f5 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if ((double)f6 != 0.0 && (double)f7 == 0.0) {
            return 0.0;
        }
        return Math.atan(f7 / f6);
    }

    public static PointF[] formParallelogramByRandomPoints(PointF pointF, PointF pointF2, PointF pointF3) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(pointF, pointF2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(pointFArray[0], pointF3);
        PointF[] pointFArray3 = new PointF[]{pointFArray2[0], null, null, null};
        PointF[] pointFArray4 = Primitive2D.arrangePointsByTop(pointFArray[1], pointFArray2[1]);
        pointFArray3[1] = pointFArray4[0];
        pointFArray3[2] = pointFArray4[1];
        float f2 = pointFArray3[2].getX() - pointFArray3[1].getX();
        float f3 = pointFArray3[2].getY() - pointFArray3[1].getY();
        pointFArray3[3] = new PointF(pointFArray3[0].getX() + f2, pointFArray3[0].getY() + f3);
        return pointFArray3;
    }

    public static PointF[] formParallelogramByArrangedPoints(PointF pointF, PointF pointF2, PointF pointF3) {
        PointF[] pointFArray = new PointF[]{pointF, pointF2, pointF3, null};
        float f2 = pointFArray[2].getX() - pointFArray[1].getX();
        float f3 = pointFArray[2].getY() - pointFArray[1].getY();
        pointFArray[3] = new PointF(pointFArray[0].getX() + f2, pointFArray[0].getY() + f3);
        return pointFArray;
    }

    public static PointF[] formParallelogramByNetPoints(PointF pointF, PointF pointF2, PointF pointF3) {
        PointF[] pointFArray = new PointF[]{pointF3, pointF, pointF2, null};
        float f2 = pointFArray[2].getX() - pointFArray[1].getX();
        float f3 = pointFArray[2].getY() - pointFArray[1].getY();
        PointF pointF4 = new PointF(pointFArray[0].getX() + f2, pointFArray[0].getY() + f3);
        return new PointF[]{pointF, pointF2, pointF4, pointF3};
    }

    public static PointF[] formParallelogram(PointF pointF, PointF pointF2, PointF pointF3, boolean bl2) {
        return bl2 ? Primitive2D.formParallelogramByRandomPoints(pointF, pointF2, pointF3) : Primitive2D.formParallelogramByArrangedPoints(pointF, pointF2, pointF3);
    }

    public static PointF[] normalizeParallelogramGuess(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(pointF, pointF2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(pointF3, pointF4);
        PointF[] pointFArray3 = Primitive2D.arrangePointsByLeft(pointFArray[0], pointFArray2[0]);
        PointF[] pointFArray4 = new PointF[]{pointFArray3[0], null, null, null};
        if (pointFArray[0] != pointFArray3[0]) {
            pointFArray = Primitive2D.arrangePointsByTop(pointFArray[0], pointFArray[1]);
            pointFArray2 = Primitive2D.arrangePointsByTop(pointFArray[0], pointFArray2[1]);
            pointFArray4[1] = pointFArray2[0];
            pointFArray = Primitive2D.arrangePointsByLeft(pointFArray[1], pointFArray2[1]);
            pointFArray4[2] = pointFArray[1];
            pointFArray4[3] = pointFArray[0];
        } else {
            pointFArray2 = Primitive2D.arrangePointsByTop(pointFArray2[0], pointFArray2[1]);
            pointFArray = Primitive2D.arrangePointsByTop(pointFArray2[0], pointFArray[1]);
            pointFArray4[1] = pointFArray[0];
            pointFArray = Primitive2D.arrangePointsByLeft(pointFArray[1], pointFArray2[1]);
            pointFArray4[2] = pointFArray[1];
            pointFArray4[3] = pointFArray[0];
        }
        return pointFArray4;
    }

    public static PointF[] normalizeParallelogram(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        LinkedList<PointF> linkedList = new LinkedList<PointF>();
        linkedList.add(pointF);
        linkedList.add(pointF2);
        linkedList.add(pointF3);
        linkedList.add(pointF4);
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        arrayList.add(pointF);
        arrayList.add(pointF2);
        arrayList.add(pointF3);
        arrayList.add(pointF4);
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(pointF, pointF2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(pointF3, pointF4);
        PointF[] pointFArray3 = Primitive2D.arrangePointsByLeft(pointFArray[0], pointFArray2[0]);
        PointF[] pointFArray4 = new PointF[]{pointFArray3[0], null, null, null};
        int n2 = linkedList.indexOf(pointFArray4[0]);
        pointFArray4[1] = Primitive2D.arrangePointsByTop((PointF)arrayList.get(n2 == 0 ? 3 : n2 - 1), (PointF)linkedList.get(n2 == 3 ? 0 : n2 + 1))[0];
        linkedList.remove(pointFArray4[0]);
        linkedList.remove(pointFArray4[1]);
        n2 = arrayList.indexOf(pointFArray4[1]);
        if (pointFArray4[0] != arrayList.get(n2 == 0 ? 3 : n2 - 1)) {
            pointFArray4[2] = (PointF)arrayList.get(n2 == 0 ? 3 : n2 - 1);
        } else if (pointFArray4[0] != arrayList.get(n2 == 3 ? 0 : n2 + 1)) {
            pointFArray4[2] = (PointF)arrayList.get(n2 == 3 ? 0 : n2 + 1);
        }
        linkedList.remove(pointFArray4[2]);
        pointFArray4[3] = (PointF)linkedList.get(0);
        return pointFArray4;
    }

    public static PointF calcIntersectPoint(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        float f2 = pointF.getX();
        float f3 = pointF.getY();
        float f4 = pointF2.getX() - f2;
        float f5 = pointF2.getY() - f3;
        float f6 = pointF3.getX() - f2;
        float f7 = pointF3.getY() - f3;
        float f8 = pointF4.getX();
        float f9 = pointF4.getY();
        float f10 = f5;
        float f11 = f4;
        float f12 = f10 / f11;
        float f13 = (f9 -= f3) - f7;
        float f14 = (f8 -= f2) - f6;
        float f15 = f13 / f14;
        if (f12 == f15) {
            return null;
        }
        float f16 = f8;
        float f17 = f9;
        if (f14 == 0.0f && f11 != 0.0f) {
            f16 = f8;
            f17 = f12 * f8;
        } else if (f14 == 0.0f && f11 == 0.0f) {
            f16 = f6;
            f17 = f7;
        }
        float f18 = f9 - f15 * f8;
        if (f14 != 0.0f) {
            if (f12 != 0.0f) {
                f17 = f18 / (1.0f - f15 / f12);
                f16 = f17 / f12;
            } else if (f15 != 0.0f) {
                f17 = -1.0f * f18 * f12 / f15 / (1.0f - f12 / f15);
                f16 = (f17 - f18) / f15;
            }
        }
        return new PointF(f16 + f2, f17 + f3);
    }
}

