/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArithmeticException;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.core.System.l;
import com.aspose.html.utils.ms.core.System.q;
import com.aspose.html.utils.ms.lang.Operators;

public class UInt64
extends Number
implements Comparable<UInt64> {
    private static final long[] a = new long[37];
    private static final int[] b = new int[37];
    private static final int[] c = new int[37];
    private static boolean d;
    private Long e;
    public static final String MaxValueString = "18446744073709551615";
    public static UInt64 MaxValue;
    public static UInt64 MinValue;
    public static UInt64 OneValue;

    public UInt64(Long l2) {
        this.e = l2;
    }

    public UInt64(long l2) {
        this.e = l2;
    }

    public UInt64(int n2) {
        this.e = new Long(n2);
    }

    public UInt64(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            if ((string = string.substring(2)).endsWith("L")) {
                string = string.substring(0, string.length() - 1);
            }
            this.e = UInt64.parseUnsignedLong(string, 16);
        } else {
            this.e = UInt64.parseUnsignedLong(string, 10);
        }
    }

    public static boolean isOverflowCheck() {
        return d;
    }

    public static void setOverflowCheck(boolean bl2) {
        d = bl2;
    }

    @Override
    public byte byteValue() {
        return this.e.byteValue();
    }

    @Override
    public short shortValue() {
        return this.e.shortValue();
    }

    @Override
    public int intValue() {
        return this.e.intValue();
    }

    @Override
    public long longValue() {
        return this.e;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    @Override
    public int compareTo(UInt64 uInt64) {
        return UInt64.a(this.e, uInt64.e);
    }

    private static int a(long l2, long l3) {
        long l4 = l2 ^ Long.MIN_VALUE;
        long l5 = l3 ^ Long.MIN_VALUE;
        return l4 < l5 ? -1 : (l4 > l5 ? 1 : 0);
    }

    public boolean equals(UInt64 uInt64) {
        if (ObjectExtensions.referenceEquals(null, uInt64)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, uInt64)) {
            return true;
        }
        return this.e.equals(uInt64.e);
    }

    public boolean equals(Object object) {
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (ObjectExtensions.getType(object) != Operators.typeOf(UInt64.class)) {
            return false;
        }
        return this.equals((UInt64)object);
    }

    public int hashCode() {
        return this.e.hashCode();
    }

    public int getTypeCode() {
        return 12;
    }

    public static String toString(UInt64 uInt64) {
        return UInt64.a(uInt64.longValue());
    }

    public String toString() {
        return l.a(null, this, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public String toString(IFormatProvider iFormatProvider) {
        return l.a(null, this, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    public String toString(String string) {
        return l.a(string, this, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public String toString(String string, IFormatProvider iFormatProvider) {
        return l.a(string, this, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    private static boolean a(long l2, int n2, int n3) {
        if (l2 >= 0L) {
            if (l2 < a[n3]) {
                return false;
            }
            if (l2 > a[n3]) {
                return true;
            }
            return n2 > b[n3];
        }
        return true;
    }

    public static long parseUnsignedLong(String string, int n2) {
        if (string.length() == 0) {
            throw new OverflowException("empty string");
        }
        int n3 = c[n2] - 1;
        long l2 = 0L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n4 = UInt64.a(string.charAt(i2), n2);
            if (n4 == -1) {
                throw new OverflowException(string);
            }
            if (i2 > n3 && UInt64.a(l2, n4, n2)) {
                throw new OverflowException("Too large for unsigned long: " + string);
            }
            l2 = l2 * (long)n2 + (long)n4;
        }
        return l2;
    }

    private static int a(char c2, int n2) {
        char c3 = c2;
        switch (n2) {
            case 8: {
                if (c3 >= '0' && c3 <= '7') {
                    return c3 - 48;
                }
            }
            case 10: {
                if (c3 >= '0' && c3 <= '9') {
                    return c3 - 48;
                }
            }
            case 16: {
                if (c3 >= '0' && c3 <= '9') {
                    return c3 - 48;
                }
                if (c3 >= 'A' && c3 <= 'F') {
                    return c3 - 55;
                }
                if (c3 < 'a' || c3 > 'f') break;
                return c3 - 87;
            }
        }
        return Character.digit(c2, n2);
    }

    public static UInt64 parse(String string) {
        return l.a(q.a(string));
    }

    public static UInt64 parse(String string, int n2) {
        return l.a(q.a(string, n2));
    }

    public static UInt64 parse(String string, IFormatProvider iFormatProvider) {
        return l.a(q.a(string, iFormatProvider));
    }

    public static UInt64 parse(String string, int n2, IFormatProvider iFormatProvider) {
        return l.a(q.a(string, n2, iFormatProvider));
    }

    public static boolean tryParse(String string, UInt64[] uInt64Array) {
        return UInt64.tryParse(string, 7, NumberFormatInfo.getCurrentInfo(), uInt64Array);
    }

    public static boolean tryParse(String string, int n2, IFormatProvider iFormatProvider, UInt64[] uInt64Array) {
        try {
            uInt64Array[0] = UInt64.parse(string, n2, iFormatProvider);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static UInt64 op_Increment(UInt64 uInt64) {
        if (d && UInt64.op_GreaterThan(uInt64, UInt64.op_Subtraction(MaxValue, OneValue))) {
            throw new ArithmeticException("Owerflow: op_Increment");
        }
        Long l2 = uInt64.e;
        l2 = l2 + 1L;
        return new UInt64(l2);
    }

    public static UInt64 op_Decrement(UInt64 uInt64) {
        if (d && UInt64.op_LessThan(uInt64, UInt64.op_Increment(new UInt64(0L)))) {
            throw new ArithmeticException("Owerflow: op_Increment");
        }
        Long l2 = uInt64.e;
        l2 = l2 - 1L;
        return new UInt64(l2);
    }

    public static UInt64 op_OnesComplement(UInt64 uInt64) {
        return new UInt64((long)(uInt64.e ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static UInt64 op_BitwiseAnd(UInt64 uInt64, UInt64 uInt642) {
        return new UInt64(uInt64.e & uInt642.e);
    }

    public static UInt64 op_BitwiseOr(UInt64 uInt64, UInt64 uInt642) {
        return new UInt64(uInt64.e | uInt642.e);
    }

    public static UInt64 op_ExclusiveOr(UInt64 uInt64, UInt64 uInt642) {
        return new UInt64(uInt64.e ^ uInt642.e);
    }

    public static UInt64 op_Addition(UInt64 uInt64, UInt64 uInt642) {
        UInt64 uInt643 = new UInt64(uInt64.e + uInt642.e);
        if (d && UInt64.op_GreaterThan(uInt64, MinValue) && UInt64.op_GreaterThan(uInt642, MinValue) && (UInt64.op_LessThan(uInt643, uInt64) || UInt64.op_LessThan(uInt643, uInt642))) {
            throw new ArithmeticException("Owerflow: op_Addition");
        }
        return uInt643;
    }

    public static UInt64 op_Subtraction(UInt64 uInt64, UInt64 uInt642) {
        if (d && UInt64.op_LessThan(uInt64, uInt642)) {
            throw new ArithmeticException("Underflow: op_Subtraction");
        }
        return new UInt64(uInt64.e - uInt642.e);
    }

    public static UInt64 op_Multiply(UInt64 uInt64, UInt64 uInt642) {
        if (UInt64.a(uInt64.e, UInt64.MinValue.e) == 0 || UInt64.a(uInt642.e, UInt64.MinValue.e) == 0) {
            return MinValue;
        }
        long l2 = uInt64.e * uInt642.e;
        UInt64 uInt643 = UInt64.op_Division(new UInt64(l2), uInt642);
        if (d && UInt64.op_Inequality(uInt64, uInt643)) {
            throw new ArithmeticException("Owerflow: op_Multiply");
        }
        return new UInt64(l2);
    }

    public static UInt64 op_Division(UInt64 uInt64, UInt64 uInt642) {
        long l2;
        if (uInt642.equals(MinValue)) {
            throw new ArithmeticException("Division by zero");
        }
        long l3 = uInt64.e;
        long l4 = uInt642.e;
        if (l4 < 0L) {
            if (UInt64.a(l3, l4) < 0) {
                return MinValue;
            }
            return OneValue;
        }
        if (l3 >= 0L) {
            return new UInt64(l3 / l4);
        }
        long l5 = l3 - (l2 = (l3 >>> 1) / l4 << 1) * l4;
        return new UInt64(l2 + (long)(UInt64.a(l5, l4) >= 0 ? 1 : 0));
    }

    public static UInt64 op_Modulus(UInt64 uInt64, UInt64 uInt642) {
        long l2;
        if (uInt642.equals(MinValue)) {
            throw new ArithmeticException("Division by zero");
        }
        long l3 = uInt64.e;
        long l4 = uInt642.e;
        if (l4 < 0L) {
            if (UInt64.a(l3, l4) < 0) {
                return new UInt64(l3);
            }
            return new UInt64(l3 - l4);
        }
        if (l3 >= 0L) {
            return new UInt64(l3 % l4);
        }
        long l5 = (l3 >>> 1) / l4 << 1;
        return new UInt64(l2 - (UInt64.a(l2 = l3 - l5 * l4, l4) >= 0 ? l4 : 0L));
    }

    public static UInt64 op_RightShift(UInt64 uInt64, int n2) {
        return new UInt64(uInt64.e >>> n2);
    }

    public static UInt64 op_LeftShift(UInt64 uInt64, int n2) {
        return new UInt64(uInt64.e << n2);
    }

    public static boolean op_Equality(UInt64 uInt64, UInt64 uInt642) {
        return uInt64.e.equals(uInt642.e);
    }

    public static boolean op_Inequality(UInt64 uInt64, UInt64 uInt642) {
        return !uInt64.e.equals(uInt642.e);
    }

    public static boolean op_GreaterThan(UInt64 uInt64, UInt64 uInt642) {
        return UInt64.a(uInt64.e, uInt642.e) > 0;
    }

    public static boolean op_LessThan(UInt64 uInt64, UInt64 uInt642) {
        return UInt64.a(uInt64.e, uInt642.e) < 0;
    }

    public static boolean op_GreaterThanOrEqual(UInt64 uInt64, UInt64 uInt642) {
        return UInt64.a(uInt64.e, uInt642.e) >= 0;
    }

    public static boolean op_LessThanOrEqual(UInt64 uInt64, UInt64 uInt642) {
        return UInt64.a(uInt64.e, uInt642.e) <= 0;
    }

    public static int sizeOf() {
        return 8;
    }

    public byte[] toByteArray() {
        return BitConverter.getBytesUInt64(this.e);
    }

    public static UInt64 toUInt64(byte[] byArray) {
        return new UInt64(BitConverter.toUInt64(byArray, 0));
    }

    private static String a(long l2) {
        int n2;
        long l3 = l2 & Long.MAX_VALUE;
        if (l2 == l3) {
            return String.valueOf(l3);
        }
        String string = "-9223372036854775808";
        char[] cArray = string.toCharArray();
        cArray[0] = 48;
        for (n2 = cArray.length - 1; n2 != 0 && l3 != 0L; l3 /= 10L, --n2) {
            int n3 = n2;
            cArray[n3] = (char)((long)cArray[n3] + l3 % 10L);
            if (cArray[n3] <= '9') continue;
            int n4 = n2;
            cArray[n4] = (char)(cArray[n4] - 10);
            int n5 = n2 - 1;
            cArray[n5] = (char)(cArray[n5] + '\u0001');
        }
        n2 = 49 - cArray[0];
        return new String(cArray, n2, cArray.length - n2);
    }

    static {
        for (int i2 = 2; i2 <= 36; ++i2) {
            UInt64.a[i2] = UInt64.op_Division((UInt64)new UInt64((long)-1L), (UInt64)new UInt64((long)((long)i2))).e;
            UInt64.b[i2] = (int)UInt64.op_Modulus((UInt64)new UInt64((long)-1L), (UInt64)new UInt64((long)((long)i2))).e.longValue();
            UInt64.c[i2] = Long.toString(Long.MAX_VALUE, i2).length();
        }
        d = false;
        MaxValue = new UInt64(MaxValueString);
        MinValue = new UInt64(0L);
        OneValue = new UInt64(1L);
    }
}

