/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Threading;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.TimeSpan;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.IntPtr;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.Threading.EventWaitHandle;
import com.aspose.html.utils.ms.System.Threading.ThreadInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class WaitHandle
implements IDisposable {
    protected final Object syncObj = new Object();
    protected boolean isReady = false;
    protected int eventResetMode = 0;
    private CountDownLatch a = new CountDownLatch(1);
    protected static final IntPtr InvalidHandle = new IntPtr(-1L);
    private IntPtr b;
    public static final int WaitTimeout = 258;
    private boolean c = false;

    CountDownLatch b() {
        return this.a;
    }

    void a(CountDownLatch countDownLatch) {
        this.a = countDownLatch;
    }

    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.c = true;
    }

    public static boolean signalAndWait(WaitHandle waitHandle, WaitHandle waitHandle2) {
        return WaitHandle.signalAndWait(waitHandle, waitHandle2, -1, false);
    }

    public static boolean signalAndWait(WaitHandle waitHandle, WaitHandle waitHandle2, TimeSpan timeSpan, boolean bl2) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.signalAndWait(waitHandle, waitHandle2, (int)l2, bl2);
    }

    public static boolean signalAndWait(WaitHandle waitHandle, WaitHandle waitHandle2, int n2, boolean bl2) {
        if (waitHandle == null) {
            throw new ArgumentNullException("toSignal");
        }
        if (waitHandle2 == null) {
            throw new ArgumentNullException("toWaitOn");
        }
        if (-1 > n2) {
            throw new ArgumentOutOfRangeException("millisecondsTimeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        ((EventWaitHandle)waitHandle).set();
        return waitHandle2.waitOne(n2, bl2);
    }

    public static boolean waitAll(WaitHandle[] waitHandleArray) {
        return WaitHandle.waitAll(waitHandleArray, -1, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandleArray, int n2) {
        return WaitHandle.waitAll(waitHandleArray, n2, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandleArray, TimeSpan timeSpan) {
        return WaitHandle.waitAll(waitHandleArray, timeSpan, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandleArray, TimeSpan timeSpan, boolean bl2) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.waitAll(waitHandleArray, (int)l2, bl2);
    }

    public static boolean waitAll(WaitHandle[] waitHandleArray, int n2, boolean bl2) {
        boolean bl3;
        if (waitHandleArray == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandleArray.length; ++i2) {
            if (waitHandleArray[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)n2 || Integer.MAX_VALUE < (long)n2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(waitHandleArray.length);
        for (bl3 = false; bl3 < waitHandleArray.length; bl3 += 1) {
            if (waitHandleArray[bl3].b().getCount() == 1L) {
                waitHandleArray[bl3].a(countDownLatch);
                continue;
            }
            countDownLatch.countDown();
            waitHandleArray[bl3].a(countDownLatch);
        }
        try {
            if (n2 == -1) {
                countDownLatch.await();
            } else if (n2 == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(n2, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        boolean bl4 = bl3 = countDownLatch.getCount() == 0L;
        if (bl3) {
            for (int i3 = 0; i3 < waitHandleArray.length; ++i3) {
                waitHandleArray[i3].a();
            }
        }
        return bl3;
    }

    public static int waitAny(WaitHandle[] waitHandleArray) {
        return WaitHandle.waitAny(waitHandleArray, -1, true);
    }

    public static int waitAny(WaitHandle[] waitHandleArray, int n2) {
        return WaitHandle.waitAny(waitHandleArray, n2, true);
    }

    public static int waitAny(WaitHandle[] waitHandleArray, TimeSpan timeSpan) {
        return WaitHandle.waitAny(waitHandleArray, timeSpan, true);
    }

    public static int waitAny(WaitHandle[] waitHandleArray, TimeSpan timeSpan, boolean bl2) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        return WaitHandle.waitAny(waitHandleArray, (int)l2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitAny(WaitHandle[] waitHandleArray, int n2, boolean bl2) {
        int n3;
        if (waitHandleArray == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandleArray.length; ++i2) {
            if (waitHandleArray[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)n2 || Integer.MAX_VALUE < (long)n2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        for (n3 = 0; n3 < waitHandleArray.length; ++n3) {
            if (waitHandleArray[n3].b().getCount() == 0L) {
                waitHandleArray[n3].a();
                return n3;
            }
            waitHandleArray[n3].a(countDownLatch);
        }
        try {
            if (n2 == -1) {
                countDownLatch.await();
            } else if (n2 == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(n2, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        for (n3 = 0; n3 < waitHandleArray.length; ++n3) {
            Object object = waitHandleArray[n3].syncObj;
            synchronized (object) {
                if (waitHandleArray[n3].isReady) {
                    waitHandleArray[n3].a();
                    return n3;
                }
                continue;
            }
        }
        return 258;
    }

    public boolean waitOne() {
        return this.waitOne(-1, false);
    }

    public boolean waitOne(int n2) {
        return this.waitOne(n2, false);
    }

    public boolean waitOne(TimeSpan timeSpan) {
        return this.waitOne(timeSpan, false);
    }

    public boolean waitOne(TimeSpan timeSpan, boolean bl2) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return this.waitOne((int)l2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(int n2, boolean bl2) {
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl3 = false;
            if (!this.isReady) {
                try {
                    if (n2 == -1) {
                        this.syncObj.wait();
                        this.a();
                        return true;
                    }
                    this.syncObj.wait(n2 == 0 ? 1L : (long)n2);
                    bl3 = this.isReady;
                    this.a();
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException.getMessage());
                }
            }
            this.a();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventResetMode == 0 && this.isReady) {
                this.isReady = false;
                this.a(new CountDownLatch(1));
            }
        }
    }
}

