/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Text;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Text.Decoder;
import com.aspose.html.utils.ms.System.Text.DecoderFallback;
import com.aspose.html.utils.ms.System.Text.DecoderReplacementFallback;
import com.aspose.html.utils.ms.System.Text.Encoder;
import com.aspose.html.utils.ms.System.Text.EncoderFallback;
import com.aspose.html.utils.ms.System.Text.EncoderReplacementFallback;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.mscorlib.f.a;
import com.aspose.html.utils.ms.core.mscorlib.f.f;

public class UTF32Encoding
extends Encoding {
    static final int a = 12000;
    static final int n = 12001;
    private boolean o;
    private boolean p;

    public UTF32Encoding() {
        this(false, true, false);
    }

    public UTF32Encoding(boolean bl2, boolean bl3) {
        this(bl2, bl3, false);
    }

    public UTF32Encoding(boolean bl2, boolean bl3, boolean bl4) {
        super(bl2 ? 12001 : 12000);
        this.o = bl2;
        this.p = bl3;
        if (bl4) {
            this.setFallbackInternal(EncoderFallback.getExceptionFallback(), DecoderFallback.getExceptionFallback());
        } else {
            this.setFallbackInternal(new EncoderReplacementFallback("\ufffd"), new DecoderReplacementFallback("\ufffd"));
        }
        if (bl2) {
            this.body_name = "utf-32BE";
            this.encoding_name = "UTF-32 (Big-Endian)";
            this.header_name = "utf-32BE";
            this.web_name = "utf-32BE";
        } else {
            this.body_name = "utf-32";
            this.encoding_name = "Unicode (UTF-32)";
            this.header_name = "utf-32";
            this.web_name = "utf-32";
        }
        this.windows_code_page = 12000;
    }

    @Override
    public int getByteCount(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw new ArgumentNullException("chars");
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new ArgumentOutOfRangeException("index", UTF32Encoding._arg("ArgRange_Array"));
        }
        if (n3 < 0 || n3 > cArray.length - n2) {
            throw new ArgumentOutOfRangeException("count", UTF32Encoding._arg("ArgRange_Array"));
        }
        f f2 = new f(this.o, this.getEncoderFallback());
        return f2.a(cArray, n2, n3);
    }

    @Override
    public int getBytes(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        int n5 = byArray.length - n4;
        int n6 = this.getByteCount(cArray, n2, n3);
        if (n5 < n6) {
            throw new ArgumentException(UTF32Encoding._arg("Arg_InsufficientSpace"));
        }
        f f2 = new f(this.o, this.getEncoderFallback());
        f2.a(cArray, n2, n3, byArray, n4);
        return n6;
    }

    @Override
    public Encoder getEncoder() {
        return new UTF32Encoder(this.o, this.getEncoderFallback());
    }

    @Override
    public int getMaxByteCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return (n2 + 1) * 4;
    }

    @Override
    public int getMaxCharCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return n2 / 2 + 2;
    }

    @Override
    public byte[] getPreamble() {
        if (this.p) {
            byte[] byArray = new byte[4];
            if (this.o) {
                byArray[2] = -2;
                byArray[3] = -1;
            } else {
                byArray[0] = -1;
                byArray[1] = -2;
            }
            return byArray;
        }
        return new byte[0];
    }

    @Override
    public boolean equals(Object object) {
        UTF32Encoding uTF32Encoding = object instanceof UTF32Encoding ? (UTF32Encoding)object : null;
        return uTF32Encoding != null && this.codePage == uTF32Encoding.codePage && this.o == uTF32Encoding.o && this.p == uTF32Encoding.p && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        if (this.o) {
            n2 ^= 0x1F;
        }
        if (this.p) {
            n2 ^= 0x3F;
        }
        return n2;
    }

    @Override
    public int getCharCount(byte[] byArray, int n2, int n3) {
        com.aspose.html.utils.ms.core.mscorlib.e.f f2 = new com.aspose.html.utils.ms.core.mscorlib.e.f(this.o, this.getDecoderFallback());
        return f2.a(byArray, n2, n3);
    }

    @Override
    public int getChars(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        com.aspose.html.utils.ms.core.mscorlib.e.f f2 = new com.aspose.html.utils.ms.core.mscorlib.e.f(this.o, this.getDecoderFallback());
        return f2.a(byArray, n2, n3, cArray, n4);
    }

    @Override
    public Decoder getDecoder() {
        return new UTF32Decoder(this.o, this.getDecoderFallback());
    }

    static final class UTF32Decoder
    extends com.aspose.html.utils.ms.core.mscorlib.e.a {
        public UTF32Decoder(boolean bl2, DecoderFallback decoderFallback) {
            super(new com.aspose.html.utils.ms.core.mscorlib.e.f(bl2, decoderFallback));
        }
    }

    static class UTF32Encoder
    extends a {
        private UTF32Encoder(boolean bl2, EncoderFallback encoderFallback) {
            super(new f(bl2, encoderFallback));
        }
    }
}

