/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Collections.CollectionBase;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public class X509CertificateCollection
extends CollectionBase {
    public X509CertificateCollection() {
    }

    public X509CertificateCollection(X509Certificate[] x509CertificateArray) {
        this.addRange(x509CertificateArray);
    }

    public X509CertificateCollection(X509CertificateCollection x509CertificateCollection) {
        this.addRange(x509CertificateCollection);
    }

    @Override
    public X509Certificate get_Item(int n2) {
        return (X509Certificate)this.getInnerList().get_Item(n2);
    }

    public void set_Item(int n2, X509Certificate x509Certificate) {
        this.getInnerList().set_Item(n2, x509Certificate);
    }

    public int add(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new ArgumentNullException("value");
        }
        return this.getInnerList().addItem(x509Certificate);
    }

    public void addRange(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            throw new ArgumentNullException("value");
        }
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            this.getInnerList().addItem(x509CertificateArray[i2]);
        }
    }

    public void addRange(X509CertificateCollection x509CertificateCollection) {
        if (x509CertificateCollection == null) {
            throw new ArgumentNullException("value");
        }
        for (int i2 = 0; i2 < x509CertificateCollection.getInnerList().size(); ++i2) {
            this.getInnerList().addItem(x509CertificateCollection.get_Item(i2));
        }
    }

    public boolean contains(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        byte[] byArray = x509Certificate.getCertHash();
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Certificate x509Certificate2 = (X509Certificate)this.getInnerList().get_Item(i2);
            if (!this.a(x509Certificate2.getCertHash(), byArray)) continue;
            return true;
        }
        return false;
    }

    public void copyTo(X509Certificate[] x509CertificateArray, int n2) {
        if (x509CertificateArray == null) {
            throw new ArgumentNullException("array");
        }
        this.getInnerList().copyTo(Array.boxing(x509CertificateArray), n2);
    }

    @Override
    public IEnumerator iterator() {
        return new X509CertificateEnumerator(this);
    }

    public int hashCode() {
        return this.getInnerList().hashCode();
    }

    public boolean equals(Object object) {
        return this.getInnerList().equals(object);
    }

    public int indexOf(X509Certificate x509Certificate) {
        return this.getInnerList().indexOf(x509Certificate);
    }

    public void insert(int n2, X509Certificate x509Certificate) {
        this.getInnerList().insertItem(n2, x509Certificate);
    }

    public void remove(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new ArgumentNullException("value");
        }
        if (this.indexOf(x509Certificate) == -1) {
            throw new ArgumentException("value", StringExtensions.format("Not part of the collection.", new Object[0]));
        }
        this.getInnerList().removeItem(x509Certificate);
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (Operators.castToInt32(byArray[i2], 6) == Operators.castToInt32(byArray2[i2], 6)) continue;
            return false;
        }
        return true;
    }

    protected ArrayList get_InnerList() {
        return this.getInnerList();
    }

    public static class X509CertificateEnumerator
    implements IEnumerator {
        private IEnumerator a;

        public X509CertificateEnumerator(X509CertificateCollection x509CertificateCollection) {
            this.a = x509CertificateCollection.get_InnerList().iterator();
        }

        @Override
        public X509Certificate next() {
            return (X509Certificate)this.a.next();
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public void reset() {
            this.a.reset();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

