/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.adw;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Enumerator;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509CertificateCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509KeyUsageExtension;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public class X509Certificate2Collection
extends X509CertificateCollection {
    static String[] a = new String[]{Environment.get_NewLine()};

    public X509Certificate2Collection() {
    }

    public X509Certificate2Collection(X509Certificate2Collection x509Certificate2Collection) {
        this.addRange(x509Certificate2Collection);
    }

    public X509Certificate2Collection(X509Certificate2 x509Certificate2) {
        this.add(x509Certificate2);
    }

    public X509Certificate2Collection(X509Certificate2[] x509Certificate2Array) {
        this.addRange(x509Certificate2Array);
    }

    @Override
    public X509Certificate2 get_Item(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (n2 >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        return (X509Certificate2)this.getInnerList().get_Item(n2);
    }

    public void set_Item(int n2, X509Certificate2 x509Certificate2) {
        this.getInnerList().set_Item(n2, x509Certificate2);
    }

    public int add(X509Certificate2 x509Certificate2) {
        if (x509Certificate2 == null) {
            throw new ArgumentNullException("certificate");
        }
        return this.getInnerList().addItem(x509Certificate2);
    }

    public void addRange(X509Certificate2[] x509Certificate2Array) {
        if (x509Certificate2Array == null) {
            throw new ArgumentNullException("certificates");
        }
        for (int i2 = 0; i2 < x509Certificate2Array.length; ++i2) {
            this.getInnerList().addItem(x509Certificate2Array[i2]);
        }
    }

    public void addRange(X509Certificate2Collection x509Certificate2Collection) {
        if (x509Certificate2Collection == null) {
            throw new ArgumentNullException("certificates");
        }
        this.getInnerList().addRange(x509Certificate2Collection);
    }

    public boolean contains(X509Certificate2 x509Certificate2) {
        if (x509Certificate2 == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate22 : this.getInnerList()) {
            if (!x509Certificate22.equals(x509Certificate2)) continue;
            return true;
        }
        return false;
    }

    public byte[] export(int n2) {
        return this.export(n2, null);
    }

    public byte[] export(int n2, String string) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size() <= 0) break;
                return this.get_Item(this.size() - 1).export(n2, string);
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                String string2 = StringExtensions.format("Cannot export certificate(s) to the '{0}' format", Operators.boxing(n2));
                throw new CryptographicException(string2);
            }
        }
        return null;
    }

    public X509Certificate2Collection find(int n2, Object object, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("findValue");
        }
        String string = StringExtensions.Empty;
        String string2 = StringExtensions.Empty;
        int n3 = 0;
        adw adw2 = adw.hCE.asI();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: {
                try {
                    string = (String)object;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string3 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(object), "string");
                    throw new CryptographicException(string3, runtimeException);
                }
            }
            case 10: 
            case 11: 
            case 12: {
                try {
                    string2 = (String)object;
                }
                catch (RuntimeException runtimeException) {
                    String string4 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(object), "X509KeyUsageFlags");
                    throw new CryptographicException(string4, runtimeException);
                }
                try {
                    CryptoConfig.encodeOID(string2);
                    break;
                }
                catch (CryptographicUnexpectedOperationException cryptographicUnexpectedOperationException) {
                    String string5 = StringExtensions.format("Invalid OID value '{0}'.", string2);
                    throw new ArgumentException("findValue", string5);
                }
            }
            case 13: {
                try {
                    n3 = (Integer)object;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string6 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(object), "X509KeyUsageFlags");
                    throw new CryptographicException(string6, runtimeException);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                try {
                    Operators.unboxing(object, adw.class).x(adw2);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string7 = StringExtensions.format("Invalid find value type '{0}', expected '{1}'.", ObjectExtensions.getType(object), "X509DateTime");
                    throw new CryptographicException(string7, runtimeException);
                }
            }
            default: {
                String string8 = StringExtensions.format("Invalid find type '{0}'.", Operators.boxing(n2));
                throw new CryptographicException(string8);
            }
        }
        CultureInfo cultureInfo = CultureInfo.getInvariantCulture();
        X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
        for (X509Certificate2 x509Certificate2 : this.getInnerList()) {
            boolean bl3 = false;
            block12 : switch (n2) {
                case 0: {
                    bl3 = StringExtensions.compare(string, x509Certificate2.getThumbprint(), true, cultureInfo) == 0 || StringExtensions.compare(string, x509Certificate2.getCertHashString(), true, cultureInfo) == 0;
                    break;
                }
                case 1: {
                    String[] stringArray;
                    for (String string9 : stringArray = StringExtensions.split(x509Certificate2.getSubjectName().format(true), a, 1)) {
                        int n4 = StringExtensions.indexOf(string9, '=');
                        boolean bl4 = bl3 = StringExtensions.indexOf(string9, string, n4, (short)3) >= 0;
                        if (bl3) break block12;
                    }
                    break;
                }
                case 2: {
                    bl3 = StringExtensions.compare(string, x509Certificate2.getSubject(), true, cultureInfo) == 0;
                    break;
                }
                case 3: {
                    String[] stringArray = x509Certificate2.getNameInfo(0, true);
                    bl3 = StringExtensions.indexOf((String)stringArray, string, (short)3) >= 0;
                    break;
                }
                case 4: {
                    bl3 = StringExtensions.compare(string, x509Certificate2.getIssuer(), true, cultureInfo) == 0;
                    break;
                }
                case 5: {
                    bl3 = StringExtensions.compare(string, x509Certificate2.get_SerialNumber(), true, cultureInfo) == 0;
                    break;
                }
                case 9: {
                    break;
                }
                case 14: {
                    X509SubjectKeyIdentifierExtension x509SubjectKeyIdentifierExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.14"), X509SubjectKeyIdentifierExtension.class);
                    if (x509SubjectKeyIdentifierExtension == null) break;
                    bl3 = StringExtensions.compare(string, x509SubjectKeyIdentifierExtension.getSubjectKeyIdentifier(), true, cultureInfo) == 0;
                    break;
                }
                case 10: {
                    bl3 = x509Certificate2.getExtensions().size() == 0;
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    bl3 = x509Certificate2.getExtensions().get_Item(string2) != null;
                    break;
                }
                case 13: {
                    X509KeyUsageExtension x509KeyUsageExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.15"), X509KeyUsageExtension.class);
                    if (x509KeyUsageExtension == null) {
                        bl3 = true;
                        break;
                    }
                    bl3 = (x509KeyUsageExtension.getKeyUsages() & n3) == n3;
                    break;
                }
                case 6: {
                    bl3 = adw.b(adw2, x509Certificate2.getNotBefore()) && adw.d(adw2, x509Certificate2.getNotAfter());
                    break;
                }
                case 7: {
                    bl3 = adw.c(adw2, x509Certificate2.getNotBefore());
                    break;
                }
                case 8: {
                    bl3 = adw.a(adw2, x509Certificate2.getNotAfter());
                }
            }
            if (!bl3) continue;
            if (bl2) {
                try {
                    if (!x509Certificate2.verify()) continue;
                    x509Certificate2Collection.add(x509Certificate2);
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            x509Certificate2Collection.add(x509Certificate2);
        }
        return x509Certificate2Collection;
    }

    @Override
    public IEnumerator iterator() {
        return new X509Certificate2Enumerator(this);
    }

    public void import_(byte[] byArray) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(byArray);
        this.add(x509Certificate2);
    }

    public void import_(byte[] byArray, String string, int n2) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(byArray, string, n2);
        this.add(x509Certificate2);
    }

    public void import_(String string) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(string);
        this.add(x509Certificate2);
    }

    public void import_(String string, String string2, int n2) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(string, string2, n2);
        this.add(x509Certificate2);
    }

    public void insert(int n2, X509Certificate2 x509Certificate2) {
        if (x509Certificate2 == null) {
            throw new ArgumentNullException("certificate");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (n2 >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        this.getInnerList().insertItem(n2, x509Certificate2);
    }

    public void remove(X509Certificate2 x509Certificate2) {
        if (x509Certificate2 == null) {
            throw new ArgumentNullException("certificate");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)this.getInnerList().get_Item(i2);
            if (!x509Certificate.equals(x509Certificate2)) continue;
            this.getInnerList().removeAt(i2);
            return;
        }
    }

    public void removeRange(X509Certificate2[] x509Certificate2Array) {
        if (x509Certificate2Array == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : x509Certificate2Array) {
            this.remove(x509Certificate2);
        }
    }

    public void removeRange(X509Certificate2Collection x509Certificate2Collection) {
        if (x509Certificate2Collection == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : x509Certificate2Collection) {
            this.remove(x509Certificate2);
        }
    }
}

