/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricSignatureFormatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.utils.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.utils.ms.System.bc.BouncyCastleProviderHelper;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.n;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.s;
import com.aspose.html.utils.ms.core.bc.asn1.DERNull;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.DigestInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x509.X509ObjectIdentifiers;
import com.aspose.html.utils.ms.core.logger.Log4jLogger;
import com.aspose.html.utils.ms.lang.Operators;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;

public class RSAPKCS1SignatureFormatter
extends AsymmetricSignatureFormatter {
    private RSA a;
    private HashAlgorithm b;
    private String c;

    public RSAPKCS1SignatureFormatter() {
    }

    public RSAPKCS1SignatureFormatter(AsymmetricAlgorithm asymmetricAlgorithm) {
        this.setKey(asymmetricAlgorithm);
    }

    @Override
    public byte[] createSignature(byte[] byArray) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException(n.a("No key pair available."));
        }
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException(n.a("Missing hash algorithm."));
        }
        if (byArray == null) {
            throw new ArgumentNullException("rgbHash");
        }
        RSACryptoServiceProvider rSACryptoServiceProvider = Operators.as(this.a, RSACryptoServiceProvider.class);
        if (rSACryptoServiceProvider != null && rSACryptoServiceProvider.hasJavaPrivateKey()) {
            boolean bl2;
            PrivateKey privateKey = rSACryptoServiceProvider.getJavaPrivateKey();
            boolean bl3 = bl2 = privateKey.getEncoded() == null;
            if (bl2) {
                throw new NotSupportedException("Java does not support NONEwithRSA signature for this type of private key");
            }
            try {
                Provider provider = BouncyCastleProviderHelper.getBCProvider();
                Signature signature = Signature.getInstance("NONEwithRSA", provider);
                signature.initSign(privateKey);
                byte[] byArray2 = new DigestInfo(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, DERNull.INSTANCE), byArray).getEncoded();
                signature.update(byArray2);
                return signature.sign();
            }
            catch (Exception exception) {
                Log4jLogger.debug(exception.toString(), exception);
            }
        }
        return s.b(this.a, this.b, byArray);
    }

    @Override
    public byte[] computeHashAndCreateSignature(byte[] byArray) {
        RSACryptoServiceProvider rSACryptoServiceProvider = Operators.as(this.a, RSACryptoServiceProvider.class);
        if (rSACryptoServiceProvider != null && rSACryptoServiceProvider.hasJavaPrivateKey()) {
            try {
                Signature signature = Signature.getInstance(this.c + "withRSA");
                signature.initSign(rSACryptoServiceProvider.getJavaPrivateKey());
                signature.update(byArray);
                return signature.sign();
            }
            catch (Exception exception) {
                Log4jLogger.debug(exception.toString(), exception);
            }
        }
        byte[] byArray2 = this.b.computeHash(byArray);
        return this.createSignature(byArray2);
    }

    @Override
    public void setHashAlgorithm(String string) {
        this.b = HashAlgorithm.create(string);
        this.c = string;
    }

    @Override
    public void setKey(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (asymmetricAlgorithm == null) {
            throw new ArgumentNullException("key");
        }
        this.a = (RSA)asymmetricAlgorithm;
    }
}

