/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Globalization;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Globalization.TextElementEnumerator;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public class StringInfo {
    private String a;
    private int b;

    public StringInfo() {
        this(StringExtensions.Empty);
    }

    public StringInfo(String string) {
        this.setString(string);
    }

    public boolean equals(Object object) {
        StringInfo stringInfo = Operators.as(object, StringInfo.class);
        return stringInfo != null && StringExtensions.equals(this.a, stringInfo.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public int getLengthInTextElements() {
        if (this.b < 0) {
            this.b = 0;
            int n2 = 0;
            while (n2 < this.a.length()) {
                n2 += StringInfo.a(this.a, n2);
                ++this.b;
            }
        }
        return this.b;
    }

    public String getString() {
        return this.a;
    }

    public void setString(String string) {
        if (string == null) {
            throw new ArgumentNullException("value");
        }
        this.b = -1;
        this.a = string;
    }

    public String substringByTextElements(int n2) {
        if (n2 < 0 || this.a.length() == 0) {
            throw new ArgumentOutOfRangeException("startingTextElement");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n3 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("startingTextElement");
            }
            n3 += StringInfo.a(this.a, n3);
        }
        return StringExtensions.substring(this.a, n3);
    }

    public String substringByTextElements(int n2, int n3) {
        int n4;
        if (n2 < 0 || this.a.length() == 0) {
            throw new ArgumentOutOfRangeException("startingTextElement");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("lengthInTextElements");
        }
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            if (n5 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("startingTextElement");
            }
            n5 += StringInfo.a(this.a, n5);
        }
        n4 = n5;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n5 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("lengthInTextElements");
            }
            n5 += StringInfo.a(this.a, n5);
        }
        return StringExtensions.substring(this.a, n4, n5 - n4);
    }

    public static String getNextTextElement(String string) {
        if (string == null || string.length() == 0) {
            throw new ArgumentNullException("string is null");
        }
        return StringInfo.getNextTextElement(string, 0);
    }

    public static String getNextTextElement(String string, int n2) {
        int n3 = StringInfo.a(string, n2);
        return n3 != 1 ? StringExtensions.substring(string, n2, n3) : StringExtensions.newString(string.charAt(n2), 1);
    }

    static int a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("string is null");
        }
        if (n2 >= string.length()) {
            return 0;
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Index is not valid");
        }
        char c2 = string.charAt(n2);
        int n3 = Char.getUnicodeCategory(c2);
        if (n3 == 16) {
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                if (n2 + 1 < string.length() && string.charAt(n2 + 1) >= '\udc00' && string.charAt(n2 + 1) <= '\udfff') {
                    return 2;
                }
                return 1;
            }
            return 1;
        }
        if (n3 == 5 || n3 == 6 || n3 == 7) {
            return 1;
        }
        int n4 = 1;
        while (n2 + n4 < string.length() && ((n3 = Char.getUnicodeCategory(string.charAt(n2 + n4))) == 5 || n3 == 6 || n3 == 7)) {
            ++n4;
        }
        return n4;
    }

    public static TextElementEnumerator getTextElementEnumerator(String string) {
        if (string == null || string.length() == 0) {
            throw new ArgumentNullException("string is null");
        }
        return new TextElementEnumerator(string, 0);
    }

    public static TextElementEnumerator getTextElementEnumerator(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("string is null");
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("Index is not valid");
        }
        return new TextElementEnumerator(string, n2);
    }

    public static int[] parseCombiningCharacters(String string) {
        if (string == null) {
            throw new ArgumentNullException("string is null");
        }
        ArrayList arrayList = new ArrayList(string.length());
        TextElementEnumerator textElementEnumerator = StringInfo.getTextElementEnumerator(string);
        textElementEnumerator.reset();
        while (textElementEnumerator.hasNext()) {
            arrayList.addItem(textElementEnumerator.getElementIndex());
        }
        return (int[])Array.unboxing(arrayList.toArray(Operators.typeOf(Integer.TYPE)));
    }
}

