/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.lang.Struct;

public class Point
extends Struct<Point> {
    private java.awt.Point b = new java.awt.Point(0, 0);
    public static Point Empty = new Point();

    public Point() {
    }

    private Point(java.awt.Point point) {
        this.b = point;
    }

    public static Point ceiling(PointF pointF) {
        int n2 = (int)Math.ceil(pointF.getX());
        int n3 = (int)Math.ceil(pointF.getY());
        return new Point(n2, n3);
    }

    public static Point round(PointF pointF) {
        int n2 = (int)msMath.round(pointF.getX());
        int n3 = (int)msMath.round(pointF.getY());
        return new Point(n2, n3);
    }

    public static Point truncate(PointF pointF) {
        int n2 = (int)pointF.getX();
        int n3 = (int)pointF.getY();
        return new Point(n2, n3);
    }

    public static Point op_Addition(Point point, Size size) {
        return new Point(point.getX() + size.getWidth(), point.getY() + size.getHeight());
    }

    public static boolean op_Equality(Point point, Point point2) {
        return point.getX() == point2.getX() && point.getY() == point2.getY();
    }

    public static boolean op_Inequality(Point point, Point point2) {
        return point.getX() != point2.getX() || point.getY() != point2.getY();
    }

    public static Point op_Subtraction(Point point, Size size) {
        return new Point(point.getX() - size.getWidth(), point.getY() - size.getHeight());
    }

    public static Size to_Size(Point point) {
        return new Size(point.getX(), point.getY());
    }

    public static PointF to_PointF(Point point) {
        return new PointF(point.getX(), point.getY());
    }

    public static PointF toPointF(java.awt.Point point) {
        return new PointF(point.x, point.y);
    }

    public Point(int n2) {
        this.b = new java.awt.Point(n2 >> 16, n2 & 0xFFFF);
    }

    public Point(Size size) {
        this.b = new java.awt.Point(size.getWidth(), size.getHeight());
    }

    public Point(int n2, int n3) {
        this.b = new java.awt.Point(n2, n3);
    }

    public boolean isEmpty() {
        return this.getX() == 0 && this.getY() == 0;
    }

    public int getX() {
        return this.b.x;
    }

    public void setX(int n2) {
        this.b.x = n2;
    }

    public int getY() {
        return this.b.y;
    }

    public void setY(int n2) {
        this.b.y = n2;
    }

    public int hashCode() {
        return this.getX() ^ this.getY();
    }

    public void offset(int n2, int n3) {
        this.b.x += n2;
        this.b.y += n3;
    }

    public String toString() {
        return StringExtensions.format("{{X={0},Y={1}}}", Int32Extensions.toString(this.getX(), CultureInfo.getInvariantCulture()), Int32Extensions.toString(this.getY(), CultureInfo.getInvariantCulture()));
    }

    public static Point add(Point point, Size size) {
        return new Point(point.getX() + size.getWidth(), point.getY() + size.getHeight());
    }

    public void offset(Point point) {
        this.offset(point.getX(), point.getY());
    }

    public static Point subtract(Point point, Size size) {
        return new Point(point.getX() - size.getWidth(), point.getY() - size.getHeight());
    }

    @Override
    public void CloneTo(Point point) {
        point.setX(this.getX());
        point.setY(this.getY());
    }

    @Override
    public Point Clone() {
        Point point = new Point();
        this.CloneTo(point);
        return point;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Point point) {
        return point.getX() == this.getX() && point.getY() == this.getY();
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        return this.a((Point)object);
    }

    public static boolean equals(Point point, Point point2) {
        return point.equals(point2);
    }

    public static Point fromJava(java.awt.Point point) {
        if (point == null) {
            return new Point(0, 0);
        }
        return new Point(point);
    }

    public static java.awt.Point toJava(Point point) {
        if (point == null) {
            return null;
        }
        return point.b;
    }

    public PointF toPointF() {
        return PointF.fromPoint(this);
    }

    public static Point fromPointF(PointF pointF) {
        return pointF.toPoint();
    }

    public static Point roundedFromPointF(PointF pointF) {
        return pointF.toPointRounded();
    }

    public static Point[] fromPointFs(PointF[] pointFArray) {
        if (pointFArray == null) {
            return null;
        }
        if (pointFArray.length == 0) {
            return new Point[0];
        }
        Point[] pointArray = new Point[pointFArray.length];
        for (int i2 = 0; i2 < pointFArray.length; ++i2) {
            pointArray[i2] = pointFArray[i2].toPoint();
        }
        return pointArray;
    }
}

