/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.core.System.ByteArrayUtil;

public class BitConverter {
    public static final boolean IsLittleEndian = true;

    public static int toUInt16(byte[] byArray, int n2) {
        return ByteArrayUtil.getShort(byArray, n2 << 3, true) & 0xFFFF;
    }

    public static long toUInt32(byte[] byArray, int n2) {
        return (long)ByteArrayUtil.getInt(byArray, n2 << 3, true) & 0xFFFFFFFFL;
    }

    public static long toUInt64(byte[] byArray, int n2) {
        return ByteArrayUtil.getLong(byArray, n2 << 3, true);
    }

    public static int toInt16(byte[] byArray, int n2) {
        return ByteArrayUtil.getShort(byArray, n2 << 3, true);
    }

    public static int toInt32(byte[] byArray, int n2) {
        return ByteArrayUtil.getInt(byArray, n2 << 3, true);
    }

    public static long toInt64(byte[] byArray, int n2) {
        return ByteArrayUtil.getLong(byArray, n2 << 3, true);
    }

    public static boolean toBoolean(byte[] byArray, int n2) {
        return byArray[n2] != 0;
    }

    public static char toChar(byte[] byArray, int n2) {
        return (char)ByteArrayUtil.getShort(byArray, n2 << 3, true);
    }

    public static float toSingle(byte[] byArray, int n2) {
        return ByteArrayUtil.getFloat(byArray, n2 << 3, true);
    }

    public static double toDouble(byte[] byArray, int n2) {
        return ByteArrayUtil.getDouble(byArray, n2 << 3, true);
    }

    public static byte[] getBytes(byte by2) {
        return new byte[]{by2};
    }

    public static byte[] getBytesBoolean(Boolean bl2) {
        byte[] byArray = new byte[]{(byte)(bl2 != false ? 1 : 0)};
        return byArray;
    }

    public static byte[] getBytesChar(char c2) {
        return BitConverter.getBytesInt16((short)c2);
    }

    public static byte[] getBytesDouble(double d2) {
        return ByteArrayUtil.toArray(d2, true);
    }

    public static byte[] getBytesSingle(float f2) {
        return ByteArrayUtil.toArray(f2, true);
    }

    public static byte[] getBytesInt16(short s2) {
        return ByteArrayUtil.toArray(s2, true);
    }

    public static byte[] getBytesUInt16(int n2) {
        return ByteArrayUtil.toArray((short)(n2 & 0xFFFF), true);
    }

    public static byte[] getBytesInt32(int n2) {
        return ByteArrayUtil.toArray(n2, true);
    }

    public static byte[] getBytesUInt32(long l2) {
        return ByteArrayUtil.toArray((int)(l2 & 0xFFFFFFFFL), true);
    }

    public static byte[] getBytesInt64(long l2) {
        return ByteArrayUtil.toArray(l2, true);
    }

    public static byte[] getBytesUInt64(long l2) {
        return ByteArrayUtil.toArray(l2, true);
    }

    public static String toString(byte[] byArray) {
        return BitConverter.toString(byArray, 0);
    }

    public static String toString(byte[] byArray, int n2) {
        int n3 = byArray.length - n2;
        return BitConverter.toString(byArray, n2, n3);
    }

    public static String toString(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return ByteArrayUtil.toString(byArray2, ByteArrayUtil.Format.HEX, ByteArrayUtil.Separator.HYPHEN, false, ByteArrayUtil.Declaration.NONE);
    }

    public static double int64BitsToDouble(long l2) {
        return BitConverter.toDouble(BitConverter.getBytesInt64(l2), 0);
    }

    public static long doubleToInt64Bits(double d2) {
        return BitConverter.toInt64(BitConverter.getBytesDouble(d2), 0);
    }
}

