/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.collections.generic;

import com.aspose.html.IDisposable;
import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.aeX;
import com.aspose.html.utils.aeY;
import com.aspose.html.utils.collections.generic.IGenericEnumerable;
import com.aspose.html.utils.collections.generic.IGenericList;
import com.aspose.html.utils.ms.System.Action;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.utils.ms.System.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.html.utils.ms.System.Comparison;
import com.aspose.html.utils.ms.System.Converter;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Predicate;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.lang.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] b;
    private int c;
    private int d;
    static Object[] a = new Object[0];
    private static final int e = 4;

    public List() {
        this.b = a;
    }

    public List(IGenericEnumerable<T> iGenericEnumerable) {
        if (iGenericEnumerable == null) {
            throw new ArgumentNullException("collection");
        }
        this.b = a;
        this.a(iGenericEnumerable);
    }

    public List(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.b = new Object[n2];
    }

    private List(T[] TArray, int n2) {
        this.b = TArray;
        this.c = n2;
    }

    protected int getVersion() {
        return this.d;
    }

    @Override
    public void addItem(T t2) {
        if (this.c == this.b.length) {
            this.b(1);
        }
        this.b[this.c++] = t2;
        ++this.d;
    }

    private void b(int n2) {
        int n3 = this.c + n2;
        if (n3 > this.b.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n3));
        }
    }

    private void a(int n2, int n3) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void a(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.addItem(t2);
        }
    }

    public void addRange(IGenericEnumerable<T> iGenericEnumerable) {
        this.insertRange(this.c, iGenericEnumerable);
    }

    public void addRange(T[] TArray) {
        if (TArray == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t2 : TArray) {
            this.addItem(t2);
        }
        ++this.d;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T t2) {
        return msArray.binarySearch(this.b, 0, this.c, t2);
    }

    public int binarySearch(T t2, Comparator<T> comparator) {
        return msArray.binarySearch(this.b, 0, this.c, t2, comparator);
    }

    public int binarySearch(int n2, int n3, T t2, Comparator<T> comparator) {
        this.a(n2, n3);
        return msArray.binarySearch(this.b, n2, n3, t2, comparator);
    }

    @Override
    public void clear() {
        msArray.clear(this.b, 0, this.b.length);
        this.c = 0;
        ++this.d;
    }

    public <TOutput> List<TOutput> convertAll(Converter<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            list.b[i2] = converter.invoke(this.b[i2]);
        }
        list.c = this.c;
        return list;
    }

    public void copyTo(T[] TArray) {
        Array.copy(Array.boxing(this.b), 0, Array.boxing(TArray), 0, this.c);
    }

    @Override
    public void copyToTArray(T[] TArray, int n2) {
        Array.copy(Array.boxing(this.b), 0, Array.boxing(TArray), n2, this.c);
    }

    public void copyTo(int n2, T[] TArray, int n3, int n4) {
        this.a(n2, n4);
        Array.copy(Array.boxing(this.b), n2, Array.boxing(TArray), n3, n4);
    }

    public boolean exists(Predicate<T> predicate) {
        List.a(predicate);
        return this.a(0, this.c, predicate) != -1;
    }

    public T find(Predicate<T> predicate) {
        List.a(predicate);
        int n2 = this.a(0, this.c, predicate);
        return (T)(n2 != -1 ? this.b[n2] : null);
    }

    static <T> void a(Predicate<T> predicate) {
        if (predicate == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(Predicate<T> predicate) {
        List.a(predicate);
        return this.b(predicate);
    }

    private List<T> b(Predicate<T> predicate) {
        List<Object> list = new List<Object>();
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!predicate.invoke(this.b[i2])) continue;
            list.addItem(this.b[i2]);
        }
        return list;
    }

    public int findIndex(Predicate<T> predicate) {
        List.a(predicate);
        return this.a(0, this.c, predicate);
    }

    public int findIndex(int n2, Predicate<T> predicate) {
        List.a(predicate);
        this.c(n2);
        return this.a(n2, this.c - n2, predicate);
    }

    public int findIndex(int n2, int n3, Predicate<T> predicate) {
        List.a(predicate);
        this.a(n2, n3);
        return this.a(n2, n3, predicate);
    }

    private int a(int n2, int n3, Predicate<T> predicate) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!predicate.invoke(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public T findLast(Predicate<T> predicate) {
        List.a(predicate);
        int n2 = this.b(0, this.c, predicate);
        if (n2 == -1) {
            return null;
        }
        return this.get_Item(n2);
    }

    public int findLastIndex(Predicate<T> predicate) {
        List.a(predicate);
        return this.b(0, this.c, predicate);
    }

    public int findLastIndex(int n2, Predicate<T> predicate) {
        List.a(predicate);
        this.c(n2);
        return this.b(0, n2 + 1, predicate);
    }

    public int findLastIndex(int n2, int n3, Predicate<T> predicate) {
        List.a(predicate);
        int n4 = n2 - n3 + 1;
        this.a(n4, n3);
        return this.b(n4, n3, predicate);
    }

    private int b(int n2, int n3, Predicate<T> predicate) {
        int n4 = n2 + n3;
        while (n4 != n2) {
            if (!predicate.invoke(this.b[--n4])) continue;
            return n4;
        }
        return -1;
    }

    @Override
    public void forEach(Action<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            action.invoke(this.b[i2]);
        }
    }

    @Override
    public a<T> iterator() {
        return new a(this);
    }

    public List<T> getRange(int n2, int n3) {
        this.a(n2, n3);
        Object[] objectArray = new Object[n3];
        Array.copy(Array.boxing(this.b), n2, Array.boxing(objectArray), 0, n3);
        return new List<Object>(objectArray, n3);
    }

    @Override
    public int indexOfItem(T t2) {
        return Array.indexOf(this.b, t2, 0, this.c);
    }

    public int indexOf(T t2, int n2) {
        this.c(n2);
        return Array.indexOf(this.b, t2, n2, this.c - n2);
    }

    public int indexOf(T t2, int n2, int n3) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return msArray.indexOf(this.b, t2, n2, n3);
    }

    private void b(int n2, int n3) {
        if (n3 < 0) {
            n2 -= n3;
        }
        if (n2 < this.c) {
            Array.copy(Array.boxing(this.b), n2, Array.boxing(this.b), n2 + n3, this.c - n2);
        }
        this.c += n3;
        if (n3 < 0) {
            msArray.clear(this.b, this.c, -n3);
        }
    }

    private void c(int n2) {
        if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int n2, T t2) {
        this.c(n2);
        if (this.c == this.b.length) {
            this.b(1);
        }
        this.b(n2, 1);
        this.b[n2] = t2;
        ++this.d;
    }

    void a(int n2) {
        Object[] objectArray = new Object[this.c];
        this.copyToTArray(objectArray, 0);
        this.b(this.c);
        this.b(n2, objectArray.length);
        Array.copy(Array.boxing(objectArray), 0, Array.boxing(this.b), n2, objectArray.length);
    }

    public void insertRange(int n2, IGenericEnumerable<T> iGenericEnumerable) {
        if (iGenericEnumerable == null) {
            throw new ArgumentNullException("collection");
        }
        this.c(n2);
        if (iGenericEnumerable == this) {
            this.a(n2);
        } else {
            this.a(n2, iGenericEnumerable);
        }
        ++this.d;
    }

    private void a(int n2, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.insertItem(n2++, t2);
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.c == 0) {
            return -1;
        }
        return msArray.lastIndexOf(this.b, object, this.c - 1, this.c);
    }

    public int lastIndexOf(T t2, int n2) {
        this.c(n2);
        return msArray.lastIndexOf(this.b, t2, n2, n2 + 1);
    }

    public int lastIndexOf(T t2, int n2, int n3) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index", n2, "index is negative");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", n3, "count is negative");
        }
        if (n2 - n3 + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", n3, "count is too large");
        }
        return msArray.lastIndexOf(this.b, t2, n2, n3);
    }

    @Override
    public boolean removeItem(T t2) {
        int n2 = this.indexOfItem(t2);
        if (n2 != -1) {
            this.removeAt(n2);
        }
        return n2 != -1;
    }

    public int removeAll(Predicate<T> predicate) {
        List.a(predicate);
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < this.c && !predicate.invoke(this.b[n2]); ++n2) {
        }
        if (n2 == this.c) {
            return 0;
        }
        ++this.d;
        for (n3 = n2 + 1; n3 < this.c; ++n3) {
            if (predicate.invoke(this.b[n3])) continue;
            this.b[n2++] = this.b[n3];
        }
        if (n3 - n2 > 0) {
            msArray.clear(this.b, n2, n3 - n2);
        }
        this.c = n2;
        return n3 - n2;
    }

    @Override
    public void removeAt(int n2) {
        if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b(n2, -1);
        msArray.clear(this.b, this.c, 1);
        ++this.d;
    }

    public void removeRange(int n2, int n3) {
        this.a(n2, n3);
        if (n3 > 0) {
            this.b(n2, -n3);
            msArray.clear(this.b, this.c, n3);
            ++this.d;
        }
    }

    public void reverse() {
        msArray.reverse(this.b, 0, this.c);
        ++this.d;
    }

    public void reverse(int n2, int n3) {
        this.a(n2, n3);
        msArray.reverse(this.b, n2, n3);
        ++this.d;
    }

    public void sort() {
        Arrays.sort(this.b, 0, this.c);
        ++this.d;
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        Arrays.sort(this.b, 0, this.c, comparator);
        ++this.d;
    }

    @Override
    public void sort(Comparison<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.b, 0, this.c, new msArray.FunctorComparer<T>(comparison));
        ++this.d;
    }

    public void sort(int n2, int n3, Comparator<T> comparator) {
        this.a(n2, n3);
        Arrays.sort(this.b, n2, n2 + n3, comparator);
        ++this.d;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.c) {
            return Arrays.copyOf(this.b, this.c, TArray.getClass());
        }
        System.arraycopy(this.b, 0, TArray, 0, this.c);
        if (TArray.length > this.c) {
            TArray[this.c] = null;
        }
        return TArray;
    }

    public void trimExcess() {
        this.setCapacity(this.c);
    }

    public boolean trueForAll(Predicate<T> predicate) {
        List.a(predicate);
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (predicate.invoke(this.b[i2])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int n2) {
        if (((long)n2 & 0xFFFFFFFFL) < ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.b = Arrays.copyOf(this.b, n2);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public T get_Item(int n2) {
        if (((long)n2 & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.b[n2];
    }

    @Override
    public void set_Item(int n2, T t2) {
        this.c(n2);
        if ((long)n2 == (long)this.c) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b[n2] = t2;
        ++this.d;
    }

    public void copyTo(Array array, int n2) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1 || array.getLowerBound(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        Array.copy(Array.boxing(this.b), 0, array, n2, this.c);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.c == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!this.b[i3].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T t2) {
        if (t2 == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!this.b[i3].equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.c];
        System.arraycopy(this.b, 0, objectArray, 0, this.c);
        return objectArray;
    }

    @Override
    public boolean add(T t2) {
        int n2 = this.c;
        this.addItem(t2);
        return n2 != this.c;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.c;
        this.removeItem(object);
        return n2 != this.c;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n2 = 0;
        int n3 = this.size();
        if (collection == this) {
            this.a(n3);
        } else {
            for (T t2 : collection) {
                this.insertItem(n2++, t2);
            }
        }
        return n3 != this.size();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> collection) {
        int n3 = n2;
        int n4 = this.size();
        for (T t2 : collection) {
            this.insertItem(n3++, t2);
        }
        return n4 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n2 = this.size();
        for (Object obj : collection) {
            this.remove(obj);
        }
        return n2 != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Object[] objectArray;
        int n2 = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (collection.contains(object)) continue;
            this.remove(object);
        }
        return n2 != this.size();
    }

    @Override
    public T get(int n2) {
        return this.get_Item(n2);
    }

    @Override
    public T set(int n2, T t2) {
        T t3 = this.get_Item(n2);
        this.set_Item(n2, t2);
        return t3;
    }

    @Override
    public void add(int n2, T t2) {
        this.insertItem(n2, t2);
    }

    @Override
    public T remove(int n2) {
        T t2 = this.get_Item(n2);
        this.removeAt(n2);
        return t2;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!object.equals(this.b[i3])) continue;
            return i3;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new d(0);
    }

    @Override
    public ListIterator listIterator(int n2) {
        return new d(n2);
    }

    @Override
    public java.util.List<T> subList(int n2, int n3) {
        int n4 = n3 - n2;
        List<T> list = this.getRange(n2, n4);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new c<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    /* synthetic */ List(Object[] objectArray, int n2, aeX aeX2) {
        this(objectArray, n2);
    }

    public static class c<T>
    extends List<T> {
        private java.util.List<T> b;
        private int c;

        public c() {
            this.b = new ArrayList<T>();
        }

        public c(java.util.List<T> list) {
            super(list.size());
            for (T t2 : list) {
                super.addItem(t2);
            }
            this.b = list;
        }

        public c(IGenericEnumerable<T> iGenericEnumerable) {
            if (iGenericEnumerable == null) {
                throw new ArgumentNullException("collection");
            }
            this.b = new ArrayList<T>();
            this.a(iGenericEnumerable);
        }

        public c(int n2) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: capacity");
            }
            this.b = new ArrayList<T>(n2);
        }

        @Override
        protected int getVersion() {
            return this.c;
        }

        @Override
        public void addRange(IGenericEnumerable<T> iGenericEnumerable) {
            if (iGenericEnumerable == null) {
                throw new ArgumentNullException("collection");
            }
            this.a(iGenericEnumerable);
            ++this.c;
        }

        @Override
        public void addRange(T[] TArray) {
            if (TArray == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t2 : TArray) {
                this.addItem(t2);
            }
            ++this.c;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T t2) {
            return msArray.binarySearch(this.b.toArray(), 0, this.b.size(), t2);
        }

        @Override
        public int binarySearch(T t2, Comparator<T> comparator) {
            return msArray.binarySearch(this.b.toArray(), 0, this.b.size(), t2, comparator);
        }

        @Override
        public int binarySearch(int n2, int n3, T t2, Comparator<T> comparator) {
            this.a(n2, n3);
            return msArray.binarySearch(this.b.toArray(), n2, n3, t2, comparator);
        }

        @Override
        private void a(int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(Converter<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.b.size());
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                list.b[i2] = converter.invoke(this.get_Item(i2));
            }
            list.c = this.b.size();
            return list;
        }

        @Override
        public void copyTo(T[] TArray) {
            Array.copy(Array.boxing(this.b.toArray()), 0, Array.boxing(TArray), 0, this.b.size());
        }

        @Override
        public void copyToTArray(T[] TArray, int n2) {
            Array.copy(Array.boxing(this.b.toArray()), 0, Array.boxing(TArray), n2, this.b.size());
        }

        @Override
        public void copyTo(int n2, T[] TArray, int n3, int n4) {
            this.a(n2, n4);
            Array.copy(Array.boxing(this.b.toArray()), n2, Array.boxing(TArray), n3, n4);
        }

        @Override
        public boolean exists(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            return this.a(0, this.b.size(), predicate) != -1;
        }

        @Override
        private int a(int n2, int n3, Predicate<T> predicate) {
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                if (!predicate.invoke(this.b.get(i2))) continue;
                return i2;
            }
            return -1;
        }

        static <T> void c(Predicate<T> predicate) {
            if (predicate == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            int n2 = this.a(0, this.b.size(), predicate);
            return n2 != -1 ? (T)this.b.get(n2) : null;
        }

        @Override
        public List<T> findAll(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            return this.d(predicate);
        }

        private List<T> d(Predicate<T> predicate) {
            List<T> list = new List<T>();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (!predicate.invoke(this.b.get(i2))) continue;
                list.addItem(this.b.get(i2));
            }
            return list;
        }

        @Override
        public int findIndex(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            return this.a(0, this.b.size(), predicate);
        }

        @Override
        public int findIndex(int n2, Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            this.b(n2);
            return this.a(n2, this.b.size() - n2, predicate);
        }

        @Override
        private void b(int n2) {
            if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int n2, int n3, Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            this.a(n2, n3);
            return this.a(n2, n3, predicate);
        }

        @Override
        public T findLast(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            int n2 = this.b(0, this.b.size(), predicate);
            if (n2 == -1) {
                return null;
            }
            return this.get_Item(n2);
        }

        @Override
        private int b(int n2, int n3, Predicate<T> predicate) {
            int n4 = n2 + n3;
            while (n4 != n2) {
                if (!predicate.invoke(this.b.get(--n4))) continue;
                return n4;
            }
            return -1;
        }

        @Override
        public int findLastIndex(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            return this.b(0, this.b.size(), predicate);
        }

        @Override
        public int findLastIndex(int n2, Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            this.b(n2);
            return this.b(0, n2 + 1, predicate);
        }

        @Override
        public int findLastIndex(int n2, int n3, Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            int n4 = n2 - n3 + 1;
            this.a(n4, n3);
            return this.b(n4, n3, predicate);
        }

        @Override
        public void forEach(Action<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                action.invoke(this.b.get(i2));
            }
        }

        @Override
        public a<T> iterator() {
            return new a(this);
        }

        @Override
        public List<T> getRange(int n2, int n3) {
            this.a(n2, n3);
            Object[] objectArray = new Object[n3];
            Array.copy(Array.boxing(this.b.toArray()), n2, Array.boxing(objectArray), 0, n3);
            return new List(objectArray, n3, null);
        }

        @Override
        public int indexOfItem(T t2) {
            return this.b.indexOf(t2);
        }

        @Override
        public int indexOf(T t2, int n2) {
            this.b(n2);
            return Array.indexOf(this.b.toArray(), t2, n2, this.b.size() - n2);
        }

        @Override
        public int indexOf(T t2, int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return msArray.indexOf(this.b.toArray(), t2, n2, n3);
        }

        @Override
        public int lastIndexOf(Object object) {
            if (this.b.size() == 0) {
                return -1;
            }
            return msArray.lastIndexOf(this.b.toArray(), object, this.b.size() - 1, this.b.size());
        }

        @Override
        public int lastIndexOf(T t2, int n2) {
            this.b(n2);
            return msArray.lastIndexOf(this.b.toArray(), t2, n2, n2 + 1);
        }

        @Override
        public int lastIndexOf(T t2, int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("index", n2, "index is negative");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("count", n3, "count is negative");
            }
            if (n2 - n3 + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", n3, "count is too large");
            }
            return msArray.lastIndexOf(this.b.toArray(), t2, n2, n3);
        }

        @Override
        public boolean removeItem(T t2) {
            int n2 = this.indexOfItem(t2);
            if (n2 != -1) {
                this.removeAt(n2);
            }
            return n2 != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] T1Array) {
            return this.b.toArray(T1Array);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.b.size());
        }

        @Override
        public boolean trueForAll(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                if (predicate.invoke(this.b.get(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.b.size();
        }

        @Override
        public void setCapacity(int n2) {
            if (((long)n2 & 0xFFFFFFFFL) < ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i2 = 0; i2 < n2 - this.b.size(); ++i2) {
                this.b.add(null);
            }
        }

        @Override
        public int size() {
            return this.b.size();
        }

        @Override
        public T get_Item(int n2) {
            return this.b.get(n2);
        }

        @Override
        public void copyTo(Array array, int n2) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.getRank() > 1 || array.getLowerBound(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            Array.copy(Array.boxing(this.b.toArray()), 0, array, n2, this.b.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    if (this.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < this.b.size(); ++i3) {
                if (!this.get(i3).equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T t2) {
            if (t2 == null) {
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    if (this.b.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < this.b.size(); ++i3) {
                if (!this.b.get(i3).equals(t2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.b.toArray();
        }

        @Override
        public boolean add(T t2) {
            ++this.c;
            return this.b.add(t2);
        }

        @Override
        public boolean remove(Object object) {
            ++this.c;
            return this.b.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.b.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            ++this.c;
            return this.b.addAll(collection);
        }

        @Override
        public boolean addAll(int n2, Collection<? extends T> collection) {
            ++this.c;
            return this.b.addAll(n2, collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            ++this.c;
            return this.b.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            ++this.c;
            return this.b.retainAll(collection);
        }

        @Override
        public T get(int n2) {
            return this.b.get(n2);
        }

        @Override
        public T set(int n2, T t2) {
            ++this.c;
            return this.b.set(n2, t2);
        }

        @Override
        public void add(int n2, T t2) {
            ++this.c;
            this.b.add(n2, t2);
        }

        @Override
        public T remove(int n2) {
            ++this.c;
            return this.b.remove(n2);
        }

        @Override
        public int indexOf(Object object) {
            return this.b.indexOf(object);
        }

        @Override
        public ListIterator listIterator() {
            return this.b.listIterator();
        }

        @Override
        public ListIterator listIterator(int n2) {
            return this.b.listIterator(n2);
        }

        @Override
        public java.util.List<T> subList(int n2, int n3) {
            return this.b.subList(n2, n3);
        }

        @Override
        public void addItem(T t2) {
            this.b.add(t2);
            ++this.c;
        }

        @Override
        public void clear() {
            this.b.clear();
            ++this.c;
        }

        @Override
        public void insertItem(int n2, T t2) {
            this.b.add(n2, t2);
            ++this.c;
        }

        @Override
        public void insertRange(int n2, IGenericEnumerable<T> iGenericEnumerable) {
            if (iGenericEnumerable == null) {
                throw new ArgumentNullException("collection");
            }
            if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n3 = n2;
            if (iGenericEnumerable == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.b.add(n3++, object);
                }
            } else {
                for (Object e2 : iGenericEnumerable) {
                    this.b.add(n3++, e2);
                }
            }
            ++this.c;
        }

        @Override
        public int removeAll(Predicate<T> predicate) {
            com.aspose.html.utils.collections.generic.List$c.c(predicate);
            int n2 = 0;
            int n3 = 0;
            for (n2 = 0; n2 < this.b.size() && !predicate.invoke(this.b.get(n2)); ++n2) {
            }
            if (n2 == this.b.size()) {
                return 0;
            }
            ++this.c;
            for (n3 = n2 + 1; n3 < this.b.size(); ++n3) {
                if (predicate.invoke(this.b.get(n3))) continue;
                this.b.set(n2++, this.b.get(n3));
            }
            if (n3 - n2 > 0) {
                for (int i2 = 0; i2 < n3 - n2; ++i2) {
                    this.b.remove(this.b.size() - 1);
                }
            }
            return n3 - n2;
        }

        @Override
        public void removeAt(int n2) {
            if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) >= ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.remove(n2);
            ++this.c;
        }

        @Override
        public void removeRange(int n2, int n3) {
            this.a(n2, n3);
            if (n3 > 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.b.remove(n2);
                }
                ++this.c;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int n2, int n3) {
            this.a(n2, n3);
            int n4 = n2;
            for (int i2 = n2 + n3 - 1; n4 < i2; ++n4, --i2) {
                T t2 = this.b.get(n4);
                this.b.set(n4, this.b.get(i2));
                this.b.set(i2, t2);
            }
            ++this.c;
        }

        @Override
        public void sort() {
            Collections.sort(this.b, null);
            ++this.c;
        }

        @Override
        public void sort(Comparator<? super T> comparator) {
            Collections.sort(this.b, comparator);
            ++this.c;
        }

        @Override
        public void sort(Comparison<T> comparison) {
            if (comparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.b, new aeY(this, comparison));
            ++this.c;
        }

        @Override
        public void sort(int n2, int n3, Comparator<T> comparator) {
            this.a(n2, n3);
            java.util.List<T> list = this.b.subList(n2, n3);
            Collections.sort(list, comparator);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.b.set(n2 + i2, list.get(i2));
            }
            ++this.c;
        }

        @Override
        public void set_Item(int n2, T t2) {
            this.b(n2);
            if ((long)n2 == (long)this.b.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.set(n2, t2);
            ++this.c;
        }

        @Override
        private void a(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t2 : iGenericEnumerable) {
                this.addItem(t2);
            }
        }
    }

    public static class a<T>
    extends Struct<a<T>>
    implements IDisposable,
    IGenericEnumerator<T> {
        private List<T> b = new List();
        private int c;
        private int d;
        private T e;

        public a() {
        }

        a(List<T> list) {
            this();
            this.b = list;
            this.d = list.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void a() {
            if (this.d != this.b.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.d == this.b.getVersion()) {
                if (this.c < 0) {
                    return false;
                }
                if (this.c < this.b.size()) {
                    this.e = this.b.get_Item(this.c++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.c = this.b.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.a();
            this.c = 0;
        }

        @Override
        public T next() {
            if (this.c < 0 || this.c >= this.b.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.e;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        public void a(a<T> a2) {
            a2.b = this.b;
            a2.c = this.c;
            a2.d = this.d;
            a2.e = this.e;
        }

        public a<T> auQ() {
            a<T> a2 = new a<T>();
            this.a(a2);
            return a2;
        }

        public Object clone() {
            return this.auQ();
        }

        private boolean b(a a2) {
            return ObjectExtensions.equals(a2.b, this.b) && a2.c == this.c && a2.d == this.d && ObjectExtensions.equals(a2.e, this.e);
        }

        public boolean equals(Object object) {
            assert (object != null);
            if (ObjectExtensions.referenceEquals(null, object)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, object)) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            return this.b((a)object);
        }

        public static boolean a(a a2, a a3) {
            return a2.equals(a3);
        }

        public int hashCode() {
            int n2 = this.b != null ? this.b.hashCode() : 0;
            n2 = 31 * n2 + this.c;
            n2 = 31 * n2 + this.d;
            n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
            return n2;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.auQ();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.a((a)object);
        }
    }

    class d
    extends b
    implements ListIterator {
        d(int n2) {
            super(null);
            this.a = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        public T previous() {
            int n2 = this.a - 1;
            if (n2 < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2;
            this.b = n2;
            return objectArray[this.b];
        }

        public void set(T t2) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.b, t2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T t2) {
            try {
                int n2 = this.a;
                List.this.add(n2, t2);
                this.a = n2 + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class b<T>
    implements Iterator<T> {
        int a;
        int b = -1;

        private b() {
        }

        @Override
        public boolean hasNext() {
            return this.a != List.this.c;
        }

        @Override
        public T next() {
            int n2 = this.a;
            if (n2 >= List.this.c) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2 + 1;
            this.b = n2;
            return (T)objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ b(aeX aeX2) {
            this();
        }
    }
}

