/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aAB;
import com.aspose.html.utils.aAx;
import com.aspose.html.utils.aAy;
import com.aspose.html.utils.aAz;
import com.aspose.html.utils.aCE;
import com.aspose.html.utils.aCO;
import com.aspose.html.utils.aCP;
import com.aspose.html.utils.aCR;
import com.aspose.html.utils.aCc;
import com.aspose.html.utils.aCh;
import com.aspose.html.utils.aCo;
import com.aspose.html.utils.aCr;
import com.aspose.html.utils.aCz;
import com.aspose.html.utils.aDa;
import com.aspose.html.utils.aWq;
import com.aspose.html.utils.aYq;
import com.aspose.html.utils.aYz;
import com.aspose.html.utils.auI;
import com.aspose.html.utils.auL;
import com.aspose.html.utils.auN;
import com.aspose.html.utils.auO;
import com.aspose.html.utils.auT;
import com.aspose.html.utils.auw;
import com.aspose.html.utils.avB;
import com.aspose.html.utils.avq;
import com.aspose.html.utils.avy;
import com.aspose.html.utils.avz;
import com.aspose.html.utils.bgE;
import com.aspose.html.utils.bgP;
import com.aspose.html.utils.bgY;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aYx
extends X509Certificate {
    private final aWq mci;
    private final aCE mcj;
    private final aCz mck;
    private final boolean[] mcl;
    private volatile PublicKey publicKeyValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public aYx(aWq aWq2, aCE aCE2) throws CertificateParsingException {
        byte[] byArray;
        this.mci = aWq2;
        this.mcj = aCE2;
        try {
            byArray = this.getExtensionBytes("2.5.29.19");
            this.mck = byArray != null ? aCz.gR(auN.aP(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.getExtensionBytes("2.5.29.15");
            if (byArray != null) {
                avq avq2 = avq.bP(auN.aP(byArray));
                int n2 = (byArray = avq2.getBytes()).length * 8 - avq2.getPadBits();
                this.mcl = new boolean[n2 < 9 ? 9 : n2];
                for (int i2 = 0; i2 != n2; ++i2) {
                    this.mcl[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
                }
            } else {
                this.mcl = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.mcj.bgx().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.mcj.bgw().getTime());
        }
    }

    public int getVersion() {
        return this.mcj.getVersionNumber();
    }

    public BigInteger getSerialNumber() {
        return this.mcj.bat().getValue();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            auL auL2 = new auL(byteArrayOutputStream);
            auL2.b(this.mcj.bbF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            auL auL2 = new auL(byteArrayOutputStream);
            auL2.b(this.mcj.bbH());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.mcj.bgw().getDate();
    }

    public Date getNotAfter() {
        return this.mcj.bgx().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.mcj.bgv().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.mcj.bce().getOctets();
    }

    public String getSigAlgName() {
        Object object;
        aWq aWq2 = this.mci;
        if (aWq2 != null && (object = aWq2.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i2 = 0; i2 != ((Provider[])object).length; ++i2) {
            String string = object[i2].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.mcj.baf().bfo().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.mcj.baf().bfp() != null) {
            try {
                return this.mcj.baf().bfp().aXN().getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        avq avq2 = this.mcj.bgv().bhw();
        if (avq2 != null) {
            byte[] byArray = avq2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - avq2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        avq avq2 = this.mcj.bgv().bhx();
        if (avq2 != null) {
            byte[] byArray = avq2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - avq2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.mcl;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.getExtensionBytes("2.5.29.37");
        if (byArray != null) {
            try {
                auO auO2 = auO.bK(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 != auO2.size(); ++i2) {
                    arrayList.add(((auI)auO2.lG(i2)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.mck != null) {
            if (this.mck.isCA()) {
                if (this.mck.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.mck.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return aYx.getAlternativeNames(this.getExtensionBytes(aCO.khl.getId()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return aYx.getAlternativeNames(this.getExtensionBytes(aCO.khm.getId()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aCP aCP2 = this.mcj.bgv().bbL();
            if (aCP2 != null) {
                Enumeration enumeration = aCP2.oids();
                while (enumeration.hasMoreElements()) {
                    auI auI2 = (auI)enumeration.nextElement();
                    aCO aCO2 = aCP2.q(auI2);
                    if (!aCO2.isCritical()) continue;
                    hashSet.add(auI2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String string) {
        aCO aCO2;
        aCP aCP2 = this.mcj.bgv().bbL();
        if (aCP2 != null && (aCO2 = aCP2.q(new auI(string))) != null) {
            return aCO2.bgM().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        aCO aCO2;
        aCP aCP2 = this.mcj.bgv().bbL();
        if (aCP2 != null && (aCO2 = aCP2.q(new auI(string))) != null) {
            try {
                return aCO2.bgM().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aCP aCP2 = this.mcj.bgv().bbL();
            if (aCP2 != null) {
                Enumeration enumeration = aCP2.oids();
                while (enumeration.hasMoreElements()) {
                    auI auI2 = (auI)enumeration.nextElement();
                    aCO aCO2 = aCP2.q(auI2);
                    if (aCO2.isCritical()) continue;
                    hashSet.add(auI2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        aCP aCP2;
        if (this.getVersion() == 3 && (aCP2 = this.mcj.bgv().bbL()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(aYq.mbW);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.publicKeyValue == null) {
                this.publicKeyValue = this.mci.q(this.mcj.beA());
            }
            return this.publicKeyValue;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.mcj.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof aYx) {
            aYx aYx2 = (aYx)object;
            if (this.hashValueSet && aYx2.hashValueSet && this.hashValue != aYx2.hashValue) {
                return false;
            }
            return this.mcj.equals(aYx2.mcj);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = super.hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = bgP.lineSeparator();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bgP.fromByteArray(bgY.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bgP.fromByteArray(bgY.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bgP.fromByteArray(bgY.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aCP aCP2 = this.mcj.bgv().bbL();
        if (aCP2 != null) {
            Enumeration enumeration = aCP2.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                auI auI2 = (auI)enumeration.nextElement();
                aCO aCO2 = aCP2.q(auI2);
                if (aCO2.bgM() != null) {
                    byte[] byArray2 = aCO2.bgM().getOctets();
                    stringBuffer.append("                       critical(").append(aCO2.isCritical()).append(") ");
                    try {
                        auN auN2 = auN.aP(byArray2);
                        if (auI2.equals(aCO.khn)) {
                            stringBuffer.append(aCz.gR(auN2)).append(string);
                            continue;
                        }
                        if (auI2.equals(aCO.khj)) {
                            stringBuffer.append(aDa.hq(auN2)).append(string);
                            continue;
                        }
                        if (auI2.equals(aAx.jRC)) {
                            stringBuffer.append(new aAy((avq)auN2)).append(string);
                            continue;
                        }
                        if (auI2.equals(aAx.jRE)) {
                            stringBuffer.append(new aAz((avy)auN2)).append(string);
                            continue;
                        }
                        if (auI2.equals(aAx.jRL)) {
                            stringBuffer.append(new aAB((avy)auN2)).append(string);
                            continue;
                        }
                        stringBuffer.append(auI2.getId());
                        stringBuffer.append(" value = ").append(aCc.dumpAsString(auN2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(auI2.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = aYz.v(this.mcj.baf());
        Signature signature = this.getSignatureFromProvider(this.mci, string);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = aYz.v(this.mcj.baf());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = aYz.v(this.mcj.baf());
        Signature signature = this.getSignatureFromProvider(provider, string);
        this.checkSignature(publicKey, signature);
    }

    private Signature getSignatureFromProvider(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void checkSignature(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.a(this.mcj.baf(), this.mcj.bgv().bgo())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        auw auw2 = this.mcj.baf().bfp();
        aYz.a(signature, auw2);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean a(aCr aCr2, aCr aCr3) {
        if (!aCr2.bfo().equals(aCr3.bfo())) {
            return false;
        }
        if (aCr2.bfp() == null) {
            return aCr3.bfp() == null || aCr3.bfp().equals(avz.jxf);
        }
        if (aCr3.bfp() == null) {
            return aCr2.bfp() == null || aCr2.bfp().equals(avz.jxf);
        }
        return aCr2.bfp().equals(aCr3.bfp());
    }

    private static Collection getAlternativeNames(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = auO.bK(byArray).getObjects();
            block11: while (enumeration.hasMoreElements()) {
                aCR aCR2 = aCR.hi(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(bgE.valueOf(aCR2.getTagNo()));
                switch (aCR2.getTagNo()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(aCR2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(aCh.a(aCo.kge, aCR2.bgJ()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((auT)((Object)aCR2.bgJ())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(auI.bI(aCR2.bgJ()).getId());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = avB.bJ(aCR2.bgJ()).getOctets();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + aCR2.getTagNo());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

