/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aCA;
import com.aspose.html.utils.aCB;
import com.aspose.html.utils.aCF;
import com.aspose.html.utils.aCO;
import com.aspose.html.utils.aCP;
import com.aspose.html.utils.aCS;
import com.aspose.html.utils.aCY;
import com.aspose.html.utils.aCc;
import com.aspose.html.utils.aCh;
import com.aspose.html.utils.aDt;
import com.aspose.html.utils.aDu;
import com.aspose.html.utils.aYq;
import com.aspose.html.utils.aYv;
import com.aspose.html.utils.aYz;
import com.aspose.html.utils.auF;
import com.aspose.html.utils.auH;
import com.aspose.html.utils.auI;
import com.aspose.html.utils.auJ;
import com.aspose.html.utils.auN;
import com.aspose.html.utils.bgP;
import com.aspose.html.utils.bgY;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aYw
extends X509CRL {
    private final Provider mcd;
    private final aCF mce;
    private final String mcf;
    private final byte[] mcg;
    private final boolean mch;
    private volatile boolean isHashCodeSet = false;
    private volatile int hashCodeValue;

    static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(aCO.kht.getId());
            return byArray != null && aCY.ho(auJ.bJ(byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected aYw(Provider provider, aCF aCF2) throws CRLException {
        this.mcd = provider;
        this.mce = aCF2;
        try {
            this.mcf = aYz.v(aCF2.baf());
            this.mcg = (byte[])(aCF2.baf().bfp() != null ? aCF2.baf().bfp().aXN().getEncoded("DER") : null);
            this.mch = aYw.isIndirectCRL(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(aYq.mbX);
        return !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl2) {
        aCP aCP2;
        if (this.getVersion() == 2 && (aCP2 = this.mce.bgy().bbL()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = aCP2.oids();
            while (enumeration.hasMoreElements()) {
                auI auI2 = (auI)enumeration.nextElement();
                aCO aCO2 = aCP2.q(auI2);
                if (bl2 != aCO2.isCritical()) continue;
                hashSet.add(auI2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        aCO aCO2;
        aCP aCP2 = this.mce.bgy().bbL();
        if (aCP2 != null && (aCO2 = aCP2.q(new auI(string))) != null) {
            try {
                return aCO2.bgM().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.mce.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.mcd);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    private void doVerify(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.mce.baf().equals(this.mce.bgy().bgo())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.mcg != null) {
            try {
                aYz.a(signature, auN.aP(this.mcg));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.mce.getVersionNumber();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.mce.bbF().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.mce.bgA().getDate();
    }

    public Date getNextUpdate() {
        if (this.mce.bgB() != null) {
            return this.mce.bgB().getDate();
        }
        return null;
    }

    private Set loadCRLEntries() {
        HashSet<aYv> hashSet = new HashSet<aYv>();
        Enumeration enumeration = this.mce.getRevokedCertificateEnumeration();
        aCh aCh2 = null;
        while (enumeration.hasMoreElements()) {
            aCO aCO2;
            aDt.a a2 = (aDt.a)enumeration.nextElement();
            aYv aYv2 = new aYv(a2, this.mch, aCh2);
            hashSet.add(aYv2);
            if (!this.mch || !a2.hasExtensions() || (aCO2 = a2.bbL().q(aCO.khu)) == null) continue;
            aCh2 = aCh.gH(aCS.hj(aCO2.bgN()).bgS()[0].bgJ());
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.mce.getRevokedCertificateEnumeration();
        aCh aCh2 = null;
        while (enumeration.hasMoreElements()) {
            aCO aCO2;
            aDt.a a2 = (aDt.a)enumeration.nextElement();
            if (bigInteger.equals(a2.bhu().getValue())) {
                return new aYv(a2, this.mch, aCh2);
            }
            if (!this.mch || !a2.hasExtensions() || (aCO2 = a2.bbL().q(aCO.khu)) == null) continue;
            aCh2 = aCh.gH(aCS.hj(aCO2.bgN()).bgS()[0].bgJ());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.loadCRLEntries();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.mce.bgy().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.mce.bce().getOctets();
    }

    public String getSigAlgName() {
        return this.mcf;
    }

    public String getSigAlgOID() {
        return this.mce.baf().bfo().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.mcg != null) {
            byte[] byArray = new byte[this.mcg.length];
            System.arraycopy(this.mcg, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = bgP.lineSeparator();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bgP.fromByteArray(bgY.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bgP.fromByteArray(bgY.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bgP.fromByteArray(bgY.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aCP aCP2 = this.mce.bgy().bbL();
        if (aCP2 != null) {
            object2 = aCP2.oids();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (auI)object2.nextElement();
                aCO aCO2 = aCP2.q((auI)object);
                if (aCO2.bgM() != null) {
                    byte[] byArray2 = aCO2.bgM().getOctets();
                    stringBuffer.append("                       critical(").append(aCO2.isCritical()).append(") ");
                    try {
                        auN auN2 = auN.aP(byArray2);
                        if (((auN)object).equals(aCO.kho)) {
                            stringBuffer.append(new aCB(auF.bG(auN2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((auN)object).equals(aCO.khs)) {
                            stringBuffer.append("Base CRL: " + new aCB(auF.bG(auN2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((auN)object).equals(aCO.kht)) {
                            stringBuffer.append(aCY.ho(auN2)).append(string);
                            continue;
                        }
                        if (((auN)object).equals(aCO.khw)) {
                            stringBuffer.append(aCA.gS(auN2)).append(string);
                            continue;
                        }
                        if (((auN)object).equals(aCO.khC)) {
                            stringBuffer.append(aCA.gS(auN2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((auI)object).getId());
                        stringBuffer.append(" value = ").append(aCc.dumpAsString(auN2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((auI)object).getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.mce.getRevokedCertificateEnumeration();
        aCh aCh2 = this.mce.bbF();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                auH auH2;
                aDt.a a2 = aDt.a.hF(enumeration.nextElement());
                if (this.mch && a2.hasExtensions() && (auH2 = a2.bbL().q(aCO.khu)) != null) {
                    aCh2 = aCh.gH(aCS.hj(auH2.bgN()).bgS()[0].bgJ());
                }
                if (!a2.bhu().getValue().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    auH2 = aCh.gH(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        auH2 = aDu.hG(certificate.getEncoded()).bbF();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return aCh2.equals(auH2);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof aYw) {
            boolean bl2;
            aYw aYw2 = (aYw)object;
            if (this.isHashCodeSet && (bl2 = aYw2.isHashCodeSet) && aYw2.hashCodeValue != this.hashCodeValue) {
                return false;
            }
            return this.mce.equals(aYw2.mce);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.isHashCodeSet) {
            this.hashCodeValue = super.hashCode();
            this.isHashCodeSet = true;
        }
        return this.hashCodeValue;
    }
}

