/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aJW;
import com.aspose.html.utils.aJn;
import com.aspose.html.utils.aJz;
import com.aspose.html.utils.aKC;
import com.aspose.html.utils.aKF;
import com.aspose.html.utils.aMo;
import com.aspose.html.utils.aNb;
import com.aspose.html.utils.aQu;
import com.aspose.html.utils.aYg;
import com.aspose.html.utils.auw;
import com.aspose.html.utils.avz;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class aYt {
    static Map<String, aJz> digestNameToAlgMap = new HashMap<String, aJz>();
    static Map<aJz, aJz> hmacToAlgMap = new HashMap<aJz, aJz>();

    aYt() {
    }

    static boolean h(aJn aJn2) {
        String string = aJn2.getName();
        return string.contains("/CCM") || string.contains("/EAX") || string.contains("/GCM") || string.contains("/CFB8MAC") || string.contains("/OCB") || string.contains("/GMAC") || string.contains("/CMAC") || string.contains("/CBCMAC") || string.contains("/MAC");
    }

    static String i(aJn aJn2) {
        String string = aJn2.getName();
        int n2 = string.indexOf(47);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (string.equals("TripleDES")) {
            return "DESede";
        }
        return string;
    }

    static boolean k(auw auw2) {
        return auw2 != null && !avz.jxf.equals(auw2.aXN());
    }

    static <T> T addRandomIfNeeded(T t2, SecureRandom secureRandom) {
        if (t2 instanceof aJW) {
            return ((aJW)t2).withSecureRandom(secureRandom);
        }
        return t2;
    }

    static byte[] getKeyEncoding(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("no encoding for key");
        }
        return byArray;
    }

    static Set<aJn> b(aJn[] aJnArray) {
        LinkedHashSet<aJn> linkedHashSet = new LinkedHashSet<aJn>();
        for (aJn aJn2 : aJnArray) {
            if (!(aJn2 instanceof aMo)) continue;
            linkedHashSet.add(aJn2);
        }
        return linkedHashSet;
    }

    static aKC a(aJn aJn2, Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key needs to be SecretKey.");
        }
        if (key instanceof aYg) {
            return ((aYg)key).bqW();
        }
        return new aKF(aJn2, key.getEncoded());
    }

    static aJz j(aJn aJn2) {
        aJz aJz2 = hmacToAlgMap.get(aJn2);
        if (aJz2 != null) {
            return aJz2;
        }
        throw new IllegalStateException("HMAC algorithm not recognized: " + aJn2.getName());
    }

    static boolean a(final aKC aKC2, int n2) {
        byte[] byArray = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return aKC2.getKeyBytes();
            }
        });
        return byArray.length != (n2 + 7) / 8;
    }

    static char[] extractPassword(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException {
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter == null) {
            return null;
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            return ((KeyStore.PasswordProtection)protectionParameter).getPassword();
        }
        if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
            PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
            try {
                callbackHandler.handle(new Callback[]{passwordCallback});
                return passwordCallback.getPassword();
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new IllegalArgumentException("PasswordCallback not recognised: " + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
            }
        }
        throw new IllegalArgumentException("no support for protection parameter of type " + protectionParameter.getClass().getName());
    }

    static {
        digestNameToAlgMap.put("SHA-1", aNb.a.kOk);
        digestNameToAlgMap.put("SHA-224", aNb.a.kOm);
        digestNameToAlgMap.put("SHA-256", aNb.a.kOo);
        digestNameToAlgMap.put("SHA-384", aNb.a.kOq);
        digestNameToAlgMap.put("SHA-512", aNb.a.kOs);
        digestNameToAlgMap.put("SHA3-224", aNb.a.kOy);
        digestNameToAlgMap.put("SHA3-256", aNb.a.kOA);
        digestNameToAlgMap.put("SHA3-384", aNb.a.kOC);
        digestNameToAlgMap.put("SHA3-512", aNb.a.kOE);
        hmacToAlgMap.put(aNb.a.kOl, aNb.a.kOk);
        hmacToAlgMap.put(aNb.a.kOn, aNb.a.kOm);
        hmacToAlgMap.put(aNb.a.kOp, aNb.a.kOo);
        hmacToAlgMap.put(aNb.a.kOr, aNb.a.kOq);
        hmacToAlgMap.put(aNb.a.kOt, aNb.a.kOs);
        hmacToAlgMap.put(aNb.a.kOv, aNb.a.kOu);
        hmacToAlgMap.put(aNb.a.kOx, aNb.a.kOw);
        hmacToAlgMap.put(aNb.a.kOz, aNb.a.kOy);
        hmacToAlgMap.put(aNb.a.kOB, aNb.a.kOA);
        hmacToAlgMap.put(aNb.a.kOD, aNb.a.kOC);
        hmacToAlgMap.put(aNb.a.kOF, aNb.a.kOE);
        hmacToAlgMap.put(aQu.a.lkt, aQu.a.lks);
        hmacToAlgMap.put(aQu.a.lkv, aQu.a.lku);
        hmacToAlgMap.put(aQu.a.lkx, aQu.a.lkw);
        hmacToAlgMap.put(aQu.a.lkz, aQu.a.lky);
        hmacToAlgMap.put(aQu.a.lkB, aQu.a.lkA);
        hmacToAlgMap.put(aQu.a.lkD, aQu.a.lkC);
        hmacToAlgMap.put(aQu.a.lkH, aQu.a.lkG);
        hmacToAlgMap.put(aQu.a.lkF, aQu.a.lkE);
    }
}

