/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aCO;
import com.aspose.html.utils.aCr;
import com.aspose.html.utils.aDh;
import com.aspose.html.utils.aVC;
import com.aspose.html.utils.aVD;
import com.aspose.html.utils.aVY;
import com.aspose.html.utils.aWr;
import com.aspose.html.utils.aXb;
import com.aspose.html.utils.aYq;
import com.aspose.html.utils.auI;
import com.aspose.html.utils.auw;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aXa
extends CertPathValidatorSpi {
    private final Provider lCe;

    aXa(Provider provider) {
        this.lCe = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        aVD aVD2;
        if (certPathParameters instanceof aVD) {
            aVD2 = (aVD)certPathParameters;
        } else if (certPathParameters instanceof aVC) {
            aVD2 = ((aVC)certPathParameters).bpM();
        } else if (certPathParameters instanceof PKIXParameters) {
            aVD2 = new aVD.a((PKIXParameters)certPathParameters).bpP();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + aVD.class.getName() + " instance.");
        }
        if (aVD2.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = aVD2.getInitialPolicies();
        try {
            trustAnchor = aWr.findTrustAnchor((X509Certificate)list.get(list.size() - 1), aVD2.getTrustAnchors(), aVD2.getSigProvider());
        }
        catch (aVY aVY2) {
            throw new CertPathValidatorException(aVY2.getMessage(), (Throwable)aVY2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        aVD2 = new aVD.a(aVD2).a(trustAnchor).bpP();
        int n3 = 0;
        List[] listArray = new ArrayList[n2 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        aXb aXb2 = new aXb(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(aXb2);
        aDh aDh2 = new aDh();
        HashSet hashSet3 = new HashSet();
        int n4 = aVD2.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = aVD2.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = aVD2.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = aWr.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        aCr aCr2 = null;
        try {
            aCr2 = aWr.g(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        auI auI2 = aCr2.bfo();
        auw auw2 = aCr2.bfp();
        int n7 = n2;
        if (aVD2.bpO() != null && !aVD2.bpO().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = aVD2.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            boolean bl2;
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            boolean bl3 = bl2 = n3 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n3);
            }
            aYq.a(certPath, aVD2, n3, publicKey, bl2, x500Principal, x509Certificate, this.lCe);
            aYq.a(certPath, n3, aDh2);
            aXb2 = aYq.a(certPath, n3, hashSet3, aXb2, listArray, n5);
            aXb2 = aYq.a(certPath, n3, aXb2);
            aYq.a(certPath, n3, aXb2, n4);
            if (n8 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n3);
            }
            aYq.prepareNextCertA(certPath, n3);
            aXb2 = aYq.a(certPath, n3, listArray, aXb2, n6);
            aYq.b(certPath, n3, aDh2);
            n4 = aYq.prepareNextCertH1(certPath, n3, n4);
            n6 = aYq.prepareNextCertH2(certPath, n3, n6);
            n5 = aYq.prepareNextCertH3(certPath, n3, n5);
            n4 = aYq.prepareNextCertI1(certPath, n3, n4);
            n6 = aYq.prepareNextCertI2(certPath, n3, n6);
            n5 = aYq.prepareNextCertJ(certPath, n3, n5);
            aYq.prepareNextCertK(certPath, n3);
            n7 = aYq.prepareNextCertL(certPath, n3, n7);
            n7 = aYq.prepareNextCertM(certPath, n3, n7);
            aYq.prepareNextCertN(certPath, n3);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(aYq.mbW);
            } else {
                hashSet = new HashSet();
            }
            aYq.prepareNextCertO(certPath, n3, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = aWr.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = aWr.getNextWorkingKey(certPath.getCertificates(), n3, this.lCe);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n3);
            }
            aCr2 = aWr.g(publicKey);
            auI2 = aCr2.bfo();
            auw2 = aCr2.bfp();
        }
        n4 = aYq.wrapupCertA(n4, x509Certificate2);
        n4 = aYq.wrapupCertB(certPath, n3 + 1, n4);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(aYq.mbW);
            set2.remove(aCO.khB.getId());
        } else {
            set2 = new HashSet<String>();
        }
        aYq.wrapupCertF(certPath, n3 + 1, list2, set2);
        hashSet = aYq.a(certPath, aVD2, set, n3 + 1, listArray, aXb2, hashSet3);
        if (n4 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }
}

