/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aCO;
import com.aspose.html.utils.aVA;
import com.aspose.html.utils.aVB;
import com.aspose.html.utils.aVC;
import com.aspose.html.utils.aVY;
import com.aspose.html.utils.aWq;
import com.aspose.html.utils.aWr;
import com.aspose.html.utils.aWu;
import com.aspose.html.utils.aXa;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class aWZ
extends CertPathBuilderSpi {
    private final aWq lCc;
    private aVY lCd;

    aWZ(aWq aWq2) {
        this.lCc = aWq2;
    }

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        aVC aVC2 = null;
        if (certPathParameters instanceof aVC) {
            aVC2 = (aVC)certPathParameters;
        } else if (certPathParameters instanceof PKIXBuilderParameters) {
            aVC2 = new aVC.a((PKIXBuilderParameters)certPathParameters).bpN();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + aVC.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        aVB aVB2 = aVC2.bpM().bpO();
        try {
            collection = aWr.a(aVB2, aVC2.bpM().getCertificateStores());
            collection.addAll(aWr.a(aVB2, aVC2.bpM().getCertStores()));
        }
        catch (aVY aVY2) {
            throw new CertPathBuilderException("Error finding target certificate.", aVY2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.a(x509Certificate, aVC2, arrayList);
        }
        if (certPathBuilderResult == null && this.lCd != null) {
            throw new CertPathBuilderException(this.lCd.getMessage(), this.lCd.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult a(X509Certificate x509Certificate, aVC aVC2, List list) throws CertPathBuilderException {
        aXa aXa2;
        aWu aWu2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (aVC2.getExcludedCerts().contains(x509Certificate)) {
            return null;
        }
        if (aVC2.getMaxPathLength() != -1 && list.size() - 1 > aVC2.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            aWu2 = new aWu(this.lCc);
            aXa2 = new aXa(this.lCc);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (aWr.findTrustAnchor(x509Certificate, aVC2.bpM().getTrustAnchors(), aVC2.bpM().getSigProvider()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = aWu2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new aVY("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)aXa2.engineValidate(certPath, aVC2);
                }
                catch (Exception exception) {
                    throw new aVY("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<aVA> arrayList = new ArrayList<aVA>();
            arrayList.addAll(aVC2.bpM().getCertificateStores());
            try {
                arrayList.addAll(aWr.getAdditionalStoresFromAltNames(x509Certificate.getExtensionValue(aCO.khm.getId()), aVC2.bpM().getNamedCertificateStoreMap()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new aVY("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(aWr.findIssuerCerts(x509Certificate, aVC2.bpM().getCertStores(), arrayList));
            }
            catch (aVY aVY2) {
                throw new aVY("Cannot find issuer certificate for certificate in certification path.", aVY2);
            }
            if (hashSet.isEmpty()) {
                throw new aVY("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.a(x509Certificate2, aVC2, list);
            }
        }
        catch (aVY aVY3) {
            this.lCd = aVY3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

